import { Button, Modal } from "antd";
import { numberFormat } from "helpers/format";
import { useRouter } from "next/router";
const PozModal = ({ open, setOpen, data, setData }) => {
    const router = useRouter();
    const close = () => {
        setOpen(false);
        setData({})
    };
    const onFinish = async (values) => {

    };
    return (
        <>
            <Modal
                title={`پرداخت مبلغ ${numberFormat(data['total'] * 10)} ریال`}
                centered
                open={open}
                onCancel={close}
                footer={''}
            >
                {
                    data['offline_id'] ? <>
                        <Button
                            type="primary"
                            className=" poz_cart w-full"
                            data-price={
                                data['total'] * 10
                            }
                            data-id={data.offline_id}
                            onClick={close}
                        >
                            پرداخت با دستگاه پوز
                        </Button>
                    </> : ''
                }

            </Modal>
        </>
    );
};

export default PozModal;
