import React from 'react';
import IMenuItem from "../interfaces/menuItem";
import MenuItem from "./Category";

function PictureMenu({menuItems, onSelectCategory}) {
    return (
        <div className="flex flex-wrap justify-around mb-10">
            {menuItems.map((menuItem: IMenuItem, index: number) => (
                <MenuItem key={index} data={menuItem} onSelect={() => onSelectCategory(menuItem)}/>
            ))}
        </div>
    );
}

export default PictureMenu;