import { useEffect, useState } from 'react';
const Pagination = (props) => {

    const [pageHtml, setPageHtml] = useState<any>('');
    let page = parseInt(props.page)
    let post_count = props.pages

    const link = (i) => {
        return <a className="page-link" onClick={() => handleChangePage(i)}>
            {i}
        </a>
    }
    const pagination = () => {
        let html = [], i
        if (post_count < 8) {
            for (i = 1; i <= post_count; i++) {

                html.push(<li className={"page-item " + ((i == page) ? 'active' : '')}>
                    {link(i)}
                </li>)
            }
        } else if (page == post_count) {
            html.push(<>
                <li className={"page-item " + ((page == 1) ? 'active' : '')}>
                    {link(1)}
                </li>
                <li className="page-item"><a className="page-link">...</a></li>
            </>)
            for (i = page - 2; i <= post_count; i++) {
                html.push(<li className={"page-item " + ((page == i) ? 'active' : '')}>
                    {link(i)}
                </li>)
            }
        } else if (page < 5) {
            for (i = 1; i <= 5; i++) {
                html.push(<li className={"page-item " + ((page == i) ? 'active' : '')}>
                    {link(i)}
                </li>)
            }
            html.push(<>
                <li className="page-item"><a className="page-link">...</a></li>
                <li className={"page-item " + ((page == post_count) ? 'active' : '')}>
                    {link(post_count)}
                </li>
            </>)
        } else if (page >= 5 && page + 1 != post_count && page + 2 != post_count) {
            html.push(<>
                <li className={"page-item " + ((page == 1) ? 'active' : '')}>
                    {link(1)}
                </li>
                <li className="page-item"><a className="page-link">...</a></li>
            </>)
            for (i = page - 1; i <= page + 1; i++) {
                html.push(<li className={"page-item " + ((page == i) ? 'active' : '')}>
                    {link(i)}
                </li>)
            }
            html.push(<>
                <li className="page-item"><a className="page-link">...</a></li>
                <li className={"page-item " + ((page == post_count) ? 'active' : '')}>
                    {link(post_count)}
                </li>
            </>)

        } else if (page + 2 == post_count) {
            html.push(<>
                <li className={"page-item " + ((page == 1) ? 'active' : '')}>{link(1)}</li>
                <li className="page-item"><a className="page-link">...</a></li>
            </>)
            for (i = page - 1; i <= post_count; i++) {
                html.push(<li className={"page-item " + ((page == i) ? 'active' : '')}>{link(i)}</li>)
            }
        } else if (page + 1 == post_count) {
            html.push(<>
                <li className={"page-item " + ((page == 1) ? 'active' : '')}>{link(1)}</li>
                <li className="page-item"><a className="page-link">...</a></li>
            </>)

            for (i = post_count - 2; i <= post_count; i++) {
                html.push(<li className={"page-item " + ((page == i) ? 'active' : '')}>{link(i)}</li>)
            }
        }

        setPageHtml(html)
    };
    const handleChangePage = (p) => {
        if (p == props.page)
            return
        props.setPage(p);
        props.getData(null, p)
    }
    useEffect(() => {
        pagination();
    }, [post_count]);
    useEffect(() => {
        pagination();
    }, [page]);

    return (
        <>
            {
                (post_count > 1) ?
                    <ul className="pagination">
                        <li className={"page-item " + ((!page || page == 1) ? 'deactive' : '')}>
                            <a className="page-link" onClick={(e) => handleChangePage(((page && page != 1) ? page - 1 : 1))}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" className="bi bi-arrow-right" viewBox="0 0 16 16"> <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z" /> </svg>
                            </a>
                        </li>
                        {pageHtml}
                        <li className={"page-item " + ((page == post_count) ? 'deactive' : '')}>
                            <a className="page-link" onClick={(e) => handleChangePage((page ? page + 1 : 2))}>
                                <svg style={{ rotate: '180deg' }} xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" className="bi bi-arrow-right" viewBox="0 0 16 16"> <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z" /> </svg>
                            </a>
                        </li>
                    </ul>
                    : null
            }

        </>
    );
}

export default Pagination;
