import { formatPrice } from "helpers/format";
import { useEffect, useState, useRef } from "react";
const OrderDetails = (props) => {
  const selectRef = useRef<HTMLDivElement>();
  const closeOpenMenus = (e) => {
    if (selectRef.current) {
      if (!selectRef.current.contains(e.target)) {
        props.setShowModal(false);
      }
    }
  };
  useEffect(() => {
    document.addEventListener("mousedown", closeOpenMenus);
  }, [selectRef]);
  return (
    <>
      {props.showModal ? (
        <>
          <div className="justify-center items-center flex overflow-x-hidden overflow-y-auto fixed inset-0 z-50 outline-none focus:outline-none">
            <div
              className="relative w-auto my-6 mx-auto max-w-3xl"
              ref={selectRef}
            >
              {/*content*/}
              <div className="border-0 rounded-lg shadow-lg relative flex flex-col w-full bg-white outline-none focus:outline-none">
                {/*header*/}
                <div className="flex items-start justify-between p-5 border-b border-solid border-slate-200 rounded-t">
                  <h3 className="text-3xl font-semibold">جزئیات سفارش</h3>
                  <button
                    className="text-red-500"
                    onClick={() => props.setShowModal(false)}
                  >
                    <span className="">×</span>
                  </button>
                </div>
                {/*body*/}
                <div className="relative p-6 flex-auto">
                  <table className="w-full divide-y divide-gray-200">
                    <thead className="bg-gray-50">
                      <tr>
                        <th
                          scope="col"
                          className="px-4 py-3 text-xs font-bold text-center text-gray-500 uppercase "
                        >
                          نام
                        </th>
                        <th
                          scope="col"
                          className="px-4 py-3 text-xs font-bold text-center text-gray-500 uppercase "
                        >
                          قیمت
                        </th>
                        <th
                          scope="col"
                          className="px-4 py-3 text-xs font-bold text-center text-gray-500 uppercase "
                        >
                          تعداد
                        </th>
                        <th
                          scope="col"
                          className="px-4 py-3 text-xs font-bold text-center text-gray-500 uppercase "
                        >
                          مجموع
                        </th>
                        <th
                          scope="col"
                          className="px-4 py-3 text-xs font-bold text-center text-gray-500 uppercase "
                        >
                          توضیح
                        </th>
                      </tr>
                    </thead>
                    <tbody className="divide-y divide-gray-200">
                      {(props.details || []).length
                        ? props.details.map((item) => (
                          <tr>
                            <td className="px-4 py-4 text-sm font-medium text-gray-800 text-center">
                              {item.product.name}
                            </td>
                            <td className="px-4 py-4 text-sm font-medium text-gray-800 text-center">
                              {formatPrice(item.product.price)}
                            </td>
                            <td className="px-4 py-4 text-sm font-medium text-gray-800 text-center">
                              {item.count}
                            </td>
                            <td className="px-4 py-4 text-sm font-medium text-gray-800 text-center">
                              {formatPrice(
                                parseInt(item.count) *
                                parseInt(item.product.price)
                              )}
                            </td>
                            <td className="px-4 py-4 text-sm font-medium text-gray-800 text-center" style={{ whiteSpace: 'break-spaces' }}>
                              {item.note}
                            </td>
                          </tr>
                        ))
                        : null}
                      {props.order.discount > 0 ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-center"
                          >
                            تخفیف: {formatPrice(props.order.discount)}
                          </td>
                        </tr>
                      ) : null}
                      {props.order.loviuna ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-center"
                          >
                            Loviuna: {props.order.loviuna["name"]}{" "}
                            {formatPrice(props.order.loviuna["price"] * 1000)}
                          </td>
                        </tr>
                      ) : null}
                      {props.order.service > 0 ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-center"
                          >
                            سرویس: {formatPrice(props.order.service)}
                          </td>
                        </tr>
                      ) : null}
                      {props.order.tip > 0 ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-center"
                          >
                            <span style={{ display: "inline-flex" }}>
                              tip:{" "}
                            </span>{" "}
                            <span> {formatPrice(props.order.tip)}</span>
                          </td>
                        </tr>
                      ) : null}
                      {props.order.tax > 0 ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-center"
                          >
                            <span style={{ display: "inline-flex" }}>
                              مالیات بر ارزش افزوده VAT:{" "}
                            </span>{" "}
                            <span> {formatPrice(props.order.tax)}</span>
                          </td>
                        </tr>
                      ) : null}
                      <tr>
                        <td
                          colSpan={5}
                          className="px-4 py-4 text-sm font-medium text-gray-800 text-center"
                        >
                          مجموع: {formatPrice(props.order.total)}
                        </td>
                      </tr>
                      {props.order.table_id ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-right"
                          >
                            شماره میز: {props.order.table_id}
                          </td>
                        </tr>
                      ) : null}
                      {props.order.numPeople ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-right"
                          >
                            تعداد نفرات: {props.order.numPeople}
                          </td>
                        </tr>
                      ) : null}
                      {props.order.note ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-right"
                            style={{ whiteSpace: 'break-spaces' }}
                          >
                            توضیح: {props.order.note}
                          </td>
                        </tr>
                      ) : null}
                      {props.order.customer ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-right"
                          >
                            مشتری:{" "}
                            {
                              props.order.customer
                                .split("  ")
                                .join("-")
                                .split("-")[1]
                            }
                          </td>
                        </tr>
                      ) : null}
                      {props.order.name_and_fam ? (
                        <tr>
                          <td
                            colSpan={5}
                            className="px-4 py-4 text-sm font-medium text-gray-800 text-right"
                          >
                            ثبت شده توسط: {props.order.name_and_fam}
                          </td>
                        </tr>
                      ) : null}
                    </tbody>
                  </table>
                </div>
                {/*footer*/}
                <div className="flex items-center justify-end p-6 border-t border-solid border-slate-200 rounded-b">
                  <button
                    className="text-red-500 background-transparent font-bold uppercase px-6 py-2 text-sm outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150"
                    type="button"
                    onClick={() => props.setShowModal(false)}
                  >
                    بستن
                  </button>
                </div>
              </div>
            </div>
          </div>
          <div className="opacity-25 fixed inset-0 z-40 bg-black"></div>
        </>
      ) : null}
    </>
  );
};

export default OrderDetails;
