import React from 'react';
import ImageComponent from "./shared/image-component";

function Option({option, setSelectedOptions, selectedOptions, withImage=false}) {

    const isOptionSelected = () => {
        return selectedOptions.filter(selectedOption => selectedOption.id === option.id && selectedOption.name === option.name).length
    }

    const onOptionClick = () => {
        if (!isOptionSelected()) {
            setSelectedOptions([...selectedOptions, option])
        }
        else {
            const newSelectedOptions = selectedOptions.filter(selectedOption => {
                //TODO refactor when backend option ids has been changed
                if (selectedOption.name !== option.name) {
                    return true;
                }
            })
            setSelectedOptions(newSelectedOptions)
        }
    }
    return (
        <>
            <li className={isOptionSelected() ? 'bg-green-500 text-white' : 'bg-white'} onClick={() => onOptionClick()} style={{fontSize: '0.8rem'}}>
                <a className={`active:bg-yellow-500 flex justify-between`} style={{padding: '8px'}}>

                    {/* {withImage ? (
                        <ImageComponent
                            src={option.image ? option.image : '/images/items/placeholder.webp'}
                            // className="rounded-badge"
                            alt={option.name}
                            height={80}
                            width={80}
                        />
                    ) : ( */}
                        <div>{option.name}</div>
                    {/* )} */}


                    {option.price ? (
                        <div className={"rounded-md bg-yellow-200"} style={{padding: '3px 6px'}}>{option.price}</div>
                    ) : ("")}
                </a>
            </li>
        </>
    );
}

export default Option;