import clsx from "clsx";
import {
  getChildren,
  getChildrenOffline,
  GetCurrentPageUpdate,
  saveItemsOffline,
} from "helpers/check-items";
import IMenuItem from "interfaces/menuItem";
import Link from "next/link";
import { useRouter } from "next/router";
import { useEffect, useState } from "react";
import MenuItem from "./Category";
import { useProductContext } from "./Products";
import PictureMenu from "./PictureMenu";
import TextMenu from "./TextMenu";
import { simpleContext } from "./contexts/simpleContext";
import { getRawItems, getTable, getTable2 } from "services/table";

const Menu = ({ title }) => {
  const [errorMessage, setErrorMessage] = useState(
    "امکان خواندن اطلاعات از سرور وجود ندارد"
  );
  const [showErrBtn, setShowErrBtn] = useState(false);
  const [isError, setIsError] = useState(false);
  const [reloadItems, setReloadItems] = useState(false);

  const { setListMode, listMode } = simpleContext();

  useEffect(() => {
    setListMode(
      localStorage.getItem("list_mode")
        ? localStorage.getItem("list_mode")
        : "text"
    );
  }, []);

  useEffect(() => {
    localStorage.setItem("list_mode", listMode);
  }, [listMode]);

  const { menuItems, setMenuItems, setCatItems, catItems, token, offline } =
    useProductContext();
  const router = useRouter();
  const onSelectCategory = (item: IMenuItem) => {
    setMenuItems([]);
    setCatItems([]);
    router.push(`/${item.parent}/${item.id}`);
  };
  const isMainPage = router.query.parentId ? false : true;
  const saveImportantData = () => {
    let s = localStorage.getItem("salon");
    if (!s || s == "null") {
      getTable2().then((r) => {
        localStorage.setItem("salon", JSON.stringify(r));
      });
    }
    if (!localStorage.getItem("tables")) {
      getTable()
        .then((data) => {
          localStorage.setItem("tables", JSON.stringify(data));
        })
        .catch((err) => {});
    }
    if (!localStorage.getItem("raw_items")) {
      getRawItems()
        .then((res) => {
          localStorage.setItem("raw_items", JSON.stringify(res));
        })
        .catch((err) => {
          localStorage.setItem(
            "raw_items",
            localStorage.getItem("raw_items") || "{}"
          );
        });
    }
  };
  const generateItems = async (loadId: number) => {
    // console.log('loading items')
    if (offline) {
      // console.log('Offline mode is ON, force loading items offline')
      getChildrenOffline(0)
        .then((resp: IMenuItem[]) => {
          setIsError(false);
          setCatItems(resp);
        })
        .catch((err) => {
          setShowErrBtn(true);
          setErrorMessage(
            "اطلاعات محصول موجود نیست برای دریافت اطلاعات به اینترنت متصل شوید"
          );
          setIsError(true);
        });
      getChildrenOffline(loadId)
        .then((resp: IMenuItem[]) => {
          setIsError(false);
          setMenuItems(resp);
        })
        .catch((err) => {
          setShowErrBtn(true);
          setErrorMessage(
            "اطلاعات محصول موجود نیست برای دریافت اطلاعات به اینترنت متصل شوید"
          );
          setIsError(true);
        });
    } else {
      saveImportantData();
      // check if available offline
      // console.log('Checking if items are available offline')
      const offlineItemsCat = localStorage.getItem(`level${0}`);
      if (offlineItemsCat) {
        // console.log('Items are available offline')
        let offlineItemsParsed: IMenuItem[] = JSON.parse(offlineItemsCat);
        if (offlineItemsParsed.length > 0) {
          getChildrenOffline(0)
            .then((items: IMenuItem[]) => setCatItems(items))
            .catch(() => {
              const clientLastUpdate = localStorage.getItem(`date${0}`);
              GetCurrentPageUpdate(0, token).then((serverLastUpdate) => {
                if (Number(clientLastUpdate) < Number(serverLastUpdate)) {
                  // we need to update
                  setCatItems([]);
                  generateItemsOnline(0);
                }
              });
            });
        }
      }

      const offlineItems = localStorage.getItem(`level${loadId}`);
      if (offlineItems) {
        // console.log('Items are available offline')
        let offlineItemsParsed: IMenuItem[] = JSON.parse(offlineItems);
        if (offlineItemsParsed.length > 0) {
          getChildrenOffline(loadId)
            .then((items: IMenuItem[]) => setMenuItems(items))
            .catch(() => {
              const clientLastUpdate = localStorage.getItem(`date${loadId}`);
              GetCurrentPageUpdate(loadId, token).then((serverLastUpdate) => {
                if (Number(clientLastUpdate) < Number(serverLastUpdate)) {
                  // we need to update
                  setMenuItems([]);
                  generateItemsOnline(loadId);
                }
              });
            });
        }
      } else {
        generateItemsOnline(loadId);
      }
    }
  };

  const getItems = (id) => {
    getChildren(id, token)
      .then((resp) => {
        setIsError(false);
        let normalizedItems = resp.items;
        localStorage.setItem(`level${id}`, JSON.stringify(normalizedItems));
        localStorage.setItem(`date${id}`, String(resp.last_update));

        for (let itmN in resp.items) {
          if (resp.items[itmN].isCat) {
            getItems(resp.items[itmN].id);
          }
        }
        //save items offline
        // saveItemsOffline(resp.items, id, resp.last_update)
        //   .then((normalizedItems) => {
        //     localStorage.setItem(`level${id}`, JSON.stringify(normalizedItems));
        //     localStorage.setItem(`date${id}`, String(resp.last_update));

        //     for (let itmN in resp.items) {
        //       if (resp.items[itmN].isCat) {
        //         getItems(resp.items[itmN].id);
        //       }
        //     }
        //   })
        //   .catch((err) => {
        //     setErrorMessage("سرور داخلی در دسترس نیست");
        //     setIsError(true);
        //   });
      })
      .catch((err) => {
        console.log(err);
        if (err !== "no data") setIsError(true);
      });
  };

  function generateItemsOnline(loadId: number) {
    getChildren(0, token)
      .then((resp) => {
        setIsError(false);
        setCatItems(resp.items);
        for (let catItem in resp.items) {
          getItems(resp.items[catItem].id);
        }
      })
      .catch((err) => {
        console.log(err);
        if (err !== "no data") setIsError(true);
      });
    getChildren(loadId, token)
      .then((resp) => {
        setIsError(false);
        setMenuItems(resp.items);

        //save items offline
        saveItemsOffline(resp.items, loadId, resp.last_update)
          .then((normalizedItems) => {
            localStorage.setItem(
              `level${loadId}`,
              JSON.stringify(normalizedItems)
            );
            localStorage.setItem(`date${loadId}`, String(resp.last_update));
          })
          .catch((err) => {
            setErrorMessage("سرور داخلی در دسترس نیست");
            setIsError(true);
          });
      })
      .catch((err) => {
        console.log(err);
        if (err !== "no data") setIsError(true);
      });
  }

  useEffect(() => {
    // cleanup
    setIsError(false);
    setShowErrBtn(false);

    let loadId = 0;
    const parentId = router.query.parentId;
    const id = router.query.id;

    // console.log(parentId)
    if (!parentId) {
      loadId = 0;
    } else {
      loadId = Number(id);
    }

    generateItems(loadId);
  }, [router, token, reloadItems]);

  const onBack = () => {
    router.back();
  };

  return (
    <>
      <section
        className="flex flex-col h-screen"
        style={{ paddingTop: "90px" }}
      >
        {isError && (
          <div className="mt-12 alert alert-error">
            <div className="flex-1 ">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                fill="none"
                viewBox="0 0 24 24"
                className="w-6 h-6 mx-2 stroke-current"
              >
                <path
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  strokeWidth={2}
                  d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
                />
              </svg>
              <label>{errorMessage}</label>
            </div>
            <div className={clsx("flex-none", !showErrBtn && "hidden")}>
              <button
                onClick={() => {
                  setReloadItems(!reloadItems);
                }}
                className="mr-2 btn btn-sm btn-accent"
              >
                دریافت
              </button>
            </div>
          </div>
        )}

        <main className="w-full my-8">
          {!isMainPage && (
            <div className="flex w-full pr-8 mb-4 text-yellow-700">
              <p style={{ fontSize: "0.8rem" }}>
                <Link href="/">
                  <a className="cursor-pointer">بازگشت</a>
                </Link>
              </p>
              <p style={{ fontSize: "0.8rem" }}>
                <a className="pr-8 cursor-pointer" onClick={onBack}>
                  صفحه قبل
                </a>
              </p>
            </div>
          )}

          {router.query.id ? (
            <TextMenu
              menuItems={catItems}
              onSelectCategory={onSelectCategory}
            />
          ) : (
            ""
          )}
          <br />
          <br />
          {/* {
                        listMode === 'picture' ?
                            (<PictureMenu menuItems={menuItems} onSelectCategory={onSelectCategory}/>) :
                            (<TextMenu menuItems={menuItems} onSelectCategory={onSelectCategory}/>)
                    } */}
          <TextMenu menuItems={menuItems} onSelectCategory={onSelectCategory} />
        </main>
      </section>
    </>
  );
};

export default Menu;
