import React from 'react';
import clsx from "clsx";
import ImageComponent from "./shared/image-component";
import AddToOrderButton from "./AddToOrderButton";
import AdditionalOptionsMenu from "./AdditionalOptionsMenu";
import IMenuItem from "../interfaces/menuItem";
import { useProductContext } from "./Products";
import { addToOrder } from './shared/addToOrder';

function ImageMenuItem({ data, onSelect }) {

    const { img, name, isCat, price, id }: IMenuItem = data
    const { setOrder, order } = useProductContext()


    return (
        <>
            <div className="relative flex flex-col items-center m-2 transition-all" onClick={(e) => addToOrder(e, isCat, onSelect, data, order, id, setOrder, price, name, 1)}>
                <div className="absolute z-20 pt-4 pr-32 text-3xl text-red-800 md:pr-36 lg:pr-44 ">{price}</div>
                <div className={clsx('flex flex-col items-center bg-white shadow-lg hover:shadow-sm rounded-xl')}>
                    <div>
                        {
                            <ImageComponent
                                src={img ? img : '/images/items/placeholder.webp'}
                                // className="rounded-badge"
                                alt={name}
                                height={150}
                                width={150}
                            />
                        }
                    </div>
                    <div className={clsx('flex flex-col items-center justify-center min-h-16 w-48  lg:w-64 p-2', isCat ? 'bg-yellow-50' : 'bg-red-100')}>
                        <div className="w-100 text-center flex justify-start items-center">
                            <span className="text-sm text-gray-800 ml-auto">{name}</span>
                            <AddToOrderButton order={order} setOrder={setOrder}
                                                                  onSelect={onSelect} id={id} name={name}
                                                                  data={data} isCat={isCat} price={price} noClick={true}/>
                            {data.option?.length ? (
                                <div className='flex content-center justify-center' id={`i${id}`}>
                                    <AdditionalOptionsMenu data={data} withImage={true} idel={'id' + 'i'}/>
                                </div>
                            ) : ('')}
                            {/* <p> ({Object.keys(item).length})</p> */}
                        </div>
                    </div>

                    {/*<div className={'flex justify-center items-center py-2'}>*/}
                    {/*    <AddToOrderButton order={order} setOrder={setOrder}*/}
                    {/*                      onSelect={onSelect} id={id} name={name}*/}
                    {/*                      data={data} isCat={isCat} price={price}*/}
                    {/*    />*/}
                    {/*    <AdditionalOptionsMenu data={data} />*/}
                    {/*</div>*/}

                </div>
            </div>
        </>
    );
}

export default ImageMenuItem;