import { useEffect, useRef, useState, Fragment } from "react";
import { useRouter } from "next/router";
import Logo, { logoType } from "./shared/Logo";
import Link from "next/link";
import { useProductContext } from "./Products";
import { cartTotalPrice } from "helpers/format";
import ImageComponent from "./shared/image-component";
import { checkConnectionStatus } from "helpers/connection";
import { IConnectionStatus } from "interfaces/connection";
import { uploadOfflineOrders } from "helpers/offline";
import { simpleContext } from "./contexts/simpleContext";

const Header = ({ showSidebar, setShowSidebar }) => {
  const router = useRouter();
  const isHomepage = router.pathname == "/";
  const [scrolled, setScrolled] = useState(false);
  const [havePrintersList, setHavePrintersList] = useState(false);
  const {
    order,
    setOrder,
    offline,
    setOffline,
    offlineBills,
    setOfflineBills,
    setToken,
    token,
    tableId,
  } = useProductContext();
  const alert = useRef(null);

  function toggleNavClass() {
    if (scrolled == false) {
      return false;
    } else {
      return true;
    }
  }

  function handleUploadOfflineBills() {
    uploadOfflineOrders(localStorage.getItem("token"))
      .then((resp) => {
        updateBills();
      })
      .catch((err) => {
        // console.log(err)
      });
  }

  function showConnectionError() {
    alert.current.classList.remove("hidden");
    setTimeout(() => {
      hideConnectionError();
    }, 2000);
  }

  function hideConnectionError() {
    alert.current.classList.add("hidden");
  }

  function reloadItems() {
    let id = router.query.id;
    if (!id) {
      id = "0";
    }
    localStorage.removeItem(`level${id}`);
    router.reload();
  }

  function logOut() {
    setToken(null);
    localStorage.removeItem("token");
    setOrder([]);
    router.push("/login");
  }

  function updateBills() {
    let storageOrders = localStorage.getItem("localOrders");
    if (storageOrders) {
      setOfflineBills(JSON.parse(storageOrders).length);
    } else {
      setOfflineBills(0);
    }
  }

  function updateToken() {
    if (router.pathname !== "/login") {
      if (!token) {
        let _token = localStorage.getItem("token");
        if (_token) {
          setToken(_token);
        } else {
          router.push("/login");
        }
      }
    }
  }

  useEffect(() => {
    if (router.pathname === "/login") return;

    updateBills();
    updateToken();
    const printers = localStorage.getItem("printers");
    if (printers) setHavePrintersList(true);
    window.document.onscroll = () => {
      const navBar = document.getElementById("nav");
      if (window.scrollY > navBar.offsetTop) {
        setScrolled(true);
      } else {
        setScrolled(false);
      }
    };

    // checkConnectionStatus()
    //   .then((resp: IConnectionStatus) => {
    //     if (resp.msg !== 'Connection Established ..') {
    //       setOffline(true)
    //     } else {
    //       // setOffline(false)
    //       // ask user to go online
    //     }
    //   })
    //   .catch((err) => {
    //     setOffline(true)
    //   })
  }, [router, token]);

  const { setListMode, listMode } = simpleContext();

  const RefButtonToggleStatusConnection = useRef(null);
  useEffect(() => {
    // window.addEventListener('load', () => {
    //   if (!offline) {
    //     RefButtonToggleStatusConnection.current.click();
    //   }
    // });
    // window.addEventListener('online', () => {
    //   hideConnectionError()
    //   checkConnectionStatus()
    //     .then((res: IConnectionStatus) => {
    //       if (res.msg === 'Connection Established ..') {
    //         setOffline(false)
    //         updateToken()
    //         RefButtonToggleStatusConnection.current.click();
    //       } else {
    //         showConnectionError()
    //       }
    //     })
    //     .catch((err) => {
    //       // console.log(err)
    //       showConnectionError()
    //     })
    // });
    // window.addEventListener('offline', () => {
    //   hideConnectionError()
    //   setOffline(true)
    // });
    window.addEventListener("resize", () => {
      if (window.innerWidth < 1050 && listMode != "text") {
        setListMode("text");
      }
    });
    window.addEventListener("load", () => {
      if (window.innerWidth < 1050 && listMode != "text") {
        setListMode("text");
      }
    });
  }, []);

  const ToggleStatusConnection = () => {
    hideConnectionError();
    if (!offline) {
      setOffline(true);
    } else {
      checkConnectionStatus()
        .then((res: IConnectionStatus) => {
          if (res.msg === "Connection Established ..") {
            setOffline(false);
            updateToken();
            handleUploadOfflineBills();
          } else {
            showConnectionError();
          }
        })
        .catch((err) => {
          // console.log(err)
          showConnectionError();
        });
    }
  };

  return (
    <div
      id="nav"
      className="fixed inset-x-0 top-0 z-50 w-full transition duration-200 ease-in-out border-b border-base-200 bg-base-100 text-base-content"
    >
      <div className="mx-auto ml-4 space-x-1 navbar max-w-none">
        <div className="flex-none">
          <label
            className="btn btn-square btn-ghost drawer-button md:hidden"
            onClick={() => setShowSidebar(!showSidebar)}
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 24 24"
              className="inline-block w-6 h-6 stroke-current"
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                strokeWidth="2"
                d="M4 6h16M4 12h16M4 18h16"
              ></path>
            </svg>
          </label>
        </div>

        {/* {!offline && (
          <a
            className="mr-10 btn btn-circle btn-outline btn-secondary"
            onClick={(e) => {
              reloadItems()
            }}>
            <ImageComponent src="/images/undo.png" alt="printer" width={30} height={30} />
          </a>
        )} */}
        {toggleNavClass() && <Logo w={65} h={19} type={logoType.Full} />}
        {!toggleNavClass() && <Logo w={130} h={37.5} type={logoType.Full} />}
        <div className={"flex flex-inline my-6"}>
          {/* <button style={{ fontSize: '0.8rem' }}
            onClick={() => setListMode('picture')}
            className={'py-2 px-4 bg-gray-200 hidden lg:flex justify-center items-center text-gray-700 rounded-md shadow-md ml-4'}>
            <span>لیست تصویری</span>
            <svg xmlns="http://www.w3.org/2000/svg" className="h-6 w-6" fill="none" viewBox="0 0 24 24"
              stroke="currentColor">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2"
                d="M9 17V7m0 10a2 2 0 01-2 2H5a2 2 0 01-2-2V7a2 2 0 012-2h2a2 2 0 012 2m0 10a2 2 0 002 2h2a2 2 0 002-2M9 7a2 2 0 012-2h2a2 2 0 012 2m0 10V7m0 10a2 2 0 002 2h2a2 2 0 002-2V7a2 2 0 00-2-2h-2a2 2 0 00-2 2" />
            </svg>
          </button>
          <button style={{ fontSize: '0.8rem' }}
            onClick={() => setListMode('text')}
            className={'py-2 px-4 bg-gray-200 hidden lg:flex justify-center items-center text-gray-700 rounded-md shadow-md ml-4'}>
            <span>لیست متنی</span>
            <svg xmlns="http://www.w3.org/2000/svg" className="h-6 w-6" fill="none" viewBox="0 0 24 24"
              stroke="currentColor">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2"
                d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
            </svg>
          </button> */}
          {router.asPath != "/tables" ? (
            <Fragment>
              <button
                style={{ fontSize: "0.8rem" }}
                onClick={() => router.push("/tables")}
                className={
                  "py-2 px-4 bg-gray-200 flex justify-center items-center text-gray-700 rounded-md shadow-md"
                }
              >
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  version="1.1"
                  className="h-6 w-6"
                  x="0"
                  y="0"
                  viewBox="0 0 64 64"
                >
                  <g>
                    <path
                      xmlns="http://www.w3.org/2000/svg"
                      d="M53.346,6.18A170.349,170.349,0,0,0,32,5,170.349,170.349,0,0,0,10.654,6.18C2.147,7.315,1,8.748,1,10v4c0,1.252,1.147,2.685,9.654,3.82,2.842.378,6.149.672,9.746.872l2.519,6.3L9.079,57.609A1,1,0,0,0,10,59h6a1,1,0,0,0,.931-.633L28,30.27V58a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V30.268l11.069,28.1A1,1,0,0,0,48,59h6a1,1,0,0,0,.921-1.391l-13.84-32.62,2.52-6.3c3.6-.2,6.9-.494,9.745-.872C61.853,16.685,63,15.252,63,14V10C63,8.748,61.853,7.315,53.346,6.18ZM32,7c16.356,0,27.008,1.708,28.837,3C59.008,11.292,48.356,13,32,13S4.992,11.292,3.163,10C4.992,8.708,15.644,7,32,7ZM15.319,57H11.511l13.41-31.609a1.013,1.013,0,0,0,.008-.763L22.6,18.8c1.508.066,3.058.114,4.64.148l.739,5.926Zm18.8-33H29.882l-.627-5.017Q30.617,19,32,19t2.744-.018ZM30,57V26h4V57Zm9.072-32.372a1.013,1.013,0,0,0,.008.763L52.489,57H48.681L36.024,24.87l.74-5.924c1.582-.034,3.132-.082,4.64-.148ZM32,17C15.054,17,4.232,15.166,3,13.862V12.114a31.329,31.329,0,0,0,7.654,1.706A170.349,170.349,0,0,0,32,15a170.349,170.349,0,0,0,21.346-1.18A31.329,31.329,0,0,0,61,12.114v1.748C59.768,15.166,48.946,17,32,17Z"
                      fill="#000000"
                      data-original="#000000"
                    ></path>
                  </g>
                </svg>
              </button>
              <span
                className={`text-gray-400 mr-2 ${tableId ? "" : "hidden"}`}
                style={{ fontSize: "0.8rem" }}
              >
                {tableId ? tableId : ""}
              </span>
            </Fragment>
          ) : null}
        </div>
        <div className="flex-1"></div>
        <div className="flex items-center py-4 pr-4 pl-4 md:pl-20 bg-red-100 rounded-2xl">
          {order.length > 0 ? (
            <div className="flex items-center justify-between p-2 ml-4 bg-red-50 rounded-xl">
              {/* <span className="">
                <Image src="/images/undo.png" width={24} height={24} />
              </span> */}
              {/* <p className="mx-2 hidden md:block">{cartTotalPrice(order)}</p> */}
              <span>
                <a
                  className="cursor-pointer"
                  onClick={() => {
                    setOrder([]);
                  }}
                >
                  <ImageComponent
                    src="/images/trash.png"
                    width={24}
                    height={24}
                    alt="trash"
                  />
                </a>
              </span>
            </div>
          ) : (
            <span />
          )}
          <div className="relative  ml-4 md:items-center flex">
            <ImageComponent
              src="/images/paperbag.png"
              alt="printer"
              width={30}
              height={30}
            />
            <span className="absolute flex items-center justify-center pt-1 text-sm text-red-800 bg-white border-2 border-gray-600 rounded-full w-5 h-5">
              {order
                .map((item) => item.count)
                .reduce((prev, next) => prev + next, 0)}
            </span>
          </div>
          {/* {router.asPath == '/printers' ? (
            <div
              className="md:ml-4 cursor-pointer"
              onClick={ToggleStatusConnection}
            >
              <ImageComponent
                src={offline ? '/images/disconnected.png' : '/images/connected.png'}
                alt="connection status"
                width={30}
                height={30}
              />
            </div>
          ) : null} */}
          {/* {offlineBills > 0 && (
            <div className="hidden lg:flex items-center justify-between p-2 ml-4 bg-red-50 rounded-xl mr-2 md:mr-0">
              <p className="mx-2">{offlineBills}</p>
              <span>
                <a className="cursor-pointer" onClick={handleUploadOfflineBills} ref={RefButtonToggleStatusConnection}>
                  <ImageComponent src="/images/bill.png" width={24} height={24} alt="offline bills" />
                </a>
              </span>
            </div>
          )} */}
          {havePrintersList && (
            <Link href="/printers">
              <a className=" lg:inline">
                <div className=" md:items-center md:flex">
                  <div className="hidden lg:inline">
                    <span className="ml-2">تنظیمات</span>
                  </div>
                  <div className="items-center flex-none" title="Printers ↗︎">
                    <ImageComponent
                      src="/images/printer.png"
                      alt="printer"
                      width={30}
                      height={30}
                    />
                  </div>
                </div>
              </a>
            </Link>
          )}
        </div>
      </div>
      <div className="hidden mx-8 alert alert-error mt 4" ref={alert}>
        <div className="flex-1">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            className="w-6 h-6 mx-2 stroke-current"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth={2}
              d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
            ></path>
          </svg>
          <label>ارتباط با سرور برقرار نمیشود</label>
        </div>
      </div>
    </div>
  );
};

export default Header;
