import { useEffect, useRef, useState } from "react";
import { getCustomer } from "services/order";
import { useProductContext } from "./Products";
import { toast } from "react-toastify";
import { Tabs } from "antd";

const CustomerSuggest = ({
  customer,
  setCustomer,
  setIsError,
  setUserPoint,
  setUserDiscount,
}) => {
  const selectRef = useRef<HTMLDivElement>();
  const [customerText, setCustomerText] = useState("");
  const [pointFree, setPointFree] = useState(20);
  const [customerText2, setCustomerText2] = useState("");
  const [customerList, setCustomerList] = useState([]);
  const [showOptions, setShowOptions] = useState(false);
  const [bg, setBg] = useState("");
  const { token, offline } = useProductContext();
  const customerNameError = useRef(null);
  const [customerPhone, setCustomerPhone] = useState<any>("");
  const [customerFirstName, setCustomerFirstName] = useState<any>("");
  const [customerLastName, setCustomerLastName] = useState<any>("");
  const [searchType, setSearchType] = useState<string>("phone");
  const [customerLoviuna, setCustomerLoviuna] = useState<any>("");

  const getCustomerData = async (value) => {
    const inputValue = value?.trim()?.toLowerCase()?.split("-")?.[0];

    if (searchType === "phone" && inputValue?.length < 11) return;

    getCustomer(token, inputValue, searchType === "loviuna" ? 1 : 0)
      .then((result) => {
        setCustomerList(result.map((item: any) => {
          let newText = "";

          if (searchType === "phone") {
            newText = item.text.replace("_", " ")

          } else {
            const name = item.text.split("  ")?.[1]?.replace("_", " ") || '';
            newText = `${item.id}  ${name}`;
          }

          return {...item, text: newText };
        }));
        if (!result?.length) {

          if (searchType === "phone") {

            setCustomer({
              id: 0,
              name: `${inputValue}-${customerFirstName}${customerLastName ? `_${customerLastName}` : ''}`,
              filledByUser: true
            });

            setCustomerLoviuna("");

          }
        }
      })
      .catch((err) => setIsError(true));
  };

  // useEffect(() => {
  //   if (offline) return;
  //   // eslint-disable-next-line react-hooks/exhaustive-deps
  // }, [customerText]);

  const closeOpenMenus = (e) => {
    if (selectRef.current && !selectRef.current.contains(e.target)) {
      setShowOptions(false);
    } else setShowOptions(true);
  };

  useEffect(() => {
    document.addEventListener("mousedown", closeOpenMenus);
  }, [selectRef]);

  useEffect(() => {
    let point_free: any = localStorage.getItem('point_free');
    point_free = point_free ? parseInt(point_free) : 20;
    setPointFree(point_free);
  }, []);

  useEffect(() => {

    if (customer?.filledByUser) return;

    if (!Object.keys(customer)?.length || (Object.keys(customer)?.length > 0 && customer?.id == -1)) {

      setCustomerText("");
      setCustomerLoviuna("");
      setCustomerFirstName("");
      setCustomerLastName("");
      setSearchType("phone");

    } else {

      const code = customer?.name?.split("-")?.[0];
      const name = customer?.name?.split("-")?.length === 2 ? customer?.name?.split("-")?.[1] : null;

      if (code?.length === 11 && code?.startsWith("09")) {
        setCustomerText(code);
        setCustomerLoviuna("");
        setSearchType("phone");

      } else {
        setCustomerLoviuna(code);
        setCustomerText("");
        setSearchType("loviuna");
      }

      if (name) {
        setCustomerFirstName(name.split("_")[0]);
        setCustomerLastName(name.split("_")[1] || "");
      }

    }

  }, [customer]);

  return (
    <div className="flex form-control">
      <div className="flex flex-col items-center">
        <div className="w-full flex items-center justify-center p-0.5 h-8 rounded-full border-2 border-yellow-300 mb-2 text-xs">
          <button className={`w-1/2 h-full rounded-r-full ${searchType === 'phone' && 'bg-yellow-300'}`} onClick={() => setSearchType("phone")}>جستجو با شماره موبایل</button>
          <button className={`w-1/2 h-full rounded-l-full ${searchType === 'loviuna' && 'bg-yellow-300'}`} onClick={() => setSearchType("loviuna")}>جستجو با کد Loviuna</button>
        </div>
        <div className="relative z-50 flex w-full" ref={selectRef}>
          {searchType === "phone" ? (
            <>
              <input
                type="text"
                tabIndex={0}
                value={customerText}
                onChange={(e) => {
                  const value = e.target.value;

                  setCustomerList([]);
                  setCustomerText(value);
                  getCustomerData(value);
                  setBg("");
                }}
                placeholder="شماره موبایل"
                className={
                  "w-full input input-secondary input-bordered p-3 py-0 h-8 min-h-0 text-center" +
                  bg
                }
                style={{ direction: "ltr" }}
              />
            </>
          ) : (
            <>
              <input
                type="text"
                tabIndex={0}
                value={customerLoviuna}
                onChange={(e) => {
                  const value = e.target.value;

                  setCustomerList([]);
                  setCustomerLoviuna(value);
                  setBg("");
                }}
                placeholder="Loviuna کد"
                className={
                  "w-full input input-secondary input-bordered p-3 py-0 h-8 min-h-0 text-center" +
                  bg
                }
                style={{ direction: "ltr" }}
              />
              <button
                className="mr-3 btn btn-secondary btn-sm text-sm"
                onClick={() => getCustomerData(customerLoviuna)}
              >
                جستجو
              </button>
            </>
          )}
          {showOptions ? (
            <div
              className="absolute flex flex-col w-full p-2 space-y-1 top-8 border-secondary"
              style={{ overflowY: "auto", maxHeight: "90vh" }}
            >
              {customerList.map((customerItem) => (
                <button
                  key={customerItem.id}
                  className={
                    "text-center text-black btn  btn-secondary p-1 h-auto flex flex-col items-center justify-center btn-sm text-sm " +
                    (customerItem.point_balance &&
                      parseInt(customerItem.point_balance) > pointFree
                      ? "bg-green-300"
                      : "bg-yellow-50")
                  }
                  onClick={() => {
                    setIsError(false);
                    setCustomerFirstName(customerItem?.first_name || "");
                    setCustomerLastName(customerItem?.last_name || "");
                    // setCustomerPhone(customerItem.first_name);
                    setCustomer({
                      id: customerItem.id,
                      name: `${searchType === "phone" ? customerItem.username : customerItem.id}-${customerItem.first_name || ""}${customerItem.last_name ? `_${customerItem.last_name}` : ''}`,
                      filledByUser: true,
                    });

                    if (searchType === "phone") {
                      setCustomerLoviuna("");
                      setCustomerText(customerItem.username);
                    } else {
                      setCustomerText("");
                      setCustomerLoviuna(customerItem.id);
                    }

                    if (
                      customerItem.point_balance &&
                      parseInt(customerItem.point_balance) > pointFree
                    ) {
                      setBg("bg-green-300");
                      setUserPoint(customerItem.point_balance);
                    }

                    setCustomerList([]);
                    setShowOptions(false);
                    if (customerItem.discount_percent) {
                      setUserDiscount(customerItem.discount_percent);
                    }
                  }}
                >
                  {customerItem.text}
                  <span style={{ fontSize: ".650rem" }}>
                    {customerItem.discount_percent}% -{" "}
                    {customerItem.point_balance} امتیاز
                  </span>
                </button>
              ))}
            </div>
          ) : (
            ""
          )}
        </div>
        <div className="relative w-full flex items-center justify-between gap-2">
          <input
            type="text"
            tabIndex={1}
            value={customerFirstName}
            onChange={(e) => {
              setCustomerFirstName(e.target.value);
              setCustomer((prev: any) => {
                return {
                  id: prev?.id ? prev.id : 0,
                  name: `${searchType === "phone" ? customerText : customerLoviuna}-${e.target.value}${customerLastName ? `_${customerLastName}` : ''}`,
                  filledByUser: true,
                }
              });
            }}
            placeholder="نام"
            className={
              "w-full input input-secondary input-bordered mt-2 p-3 py-0 h-8 min-h-0 text-center" +
              bg
            }
            style={{ direction: "ltr" }}
          />
          <input
            type="text"
            tabIndex={1}
            value={customerLastName}
            onChange={(e) => {
              setCustomerLastName(e.target.value);
              setCustomer((prev: any) => {
                return {
                  id: prev?.id ? prev.id : 0,
                  name: `${searchType === "phone" ? customerText : customerLoviuna}-${customerFirstName}${e.target.value ? `_${e.target.value}` : ''}`,
                  filledByUser: true,
                }
              });
            }}
            placeholder="نام خانوادگی"
            className={
              "w-full input input-secondary input-bordered mt-2 p-3 py-0 h-8 min-h-0 text-center" +
              bg
            }
            style={{ direction: "ltr" }}
          />
        </div>
        <label
          ref={customerNameError}
          className={"hidden mt-3 text-xs text-red-900 " + bg}
        >
          نام مشتری را وارد کنید .
        </label>
      </div>
    </div>
  );
};

export default CustomerSuggest;
