import React from 'react';
import clsx from "clsx";
import ImageComponent from "./shared/image-component";
import IMenuItem from "../interfaces/menuItem";

function CategoryImageItem({ data, onSelect }) {

    const { img, name, isCat, price}: IMenuItem = data
    return (
        <>
            <a
                className="cursor-pointer indicator"
                onClick={() => onSelect(data)}>
                <div className="relative flex flex-col items-center m-2 transition-all">
                    {!isCat && <div className="absolute z-20 pt-4 pr-32 text-3xl text-red-800 md:pr-36 lg:pr-44 ">{price}</div>}
                    <div className={clsx('flex flex-col items-center overflow-hidden bg-white shadow-lg hover:shadow-sm rounded-xl')}>
                        <div>
                            {
                                <ImageComponent
                                    src={img ? img : '/images/items/placeholder.webp'}
                                    alt={name}
                                    height={150}
                                    width={150}
                                />
                            }
                        </div>
                        <div className={clsx('flex flex-col items-center justify-center min-h-16 w-48  lg:w-64 p-2', isCat ? 'bg-yellow-50' : 'bg-red-100')}>
                            <div className="text-center">
                                <span className="text-sm text-gray-800">{name}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </>
    );
}

export default CategoryImageItem;