import IMenuItem from 'interfaces/menuItem'
import Image from 'next/image'
import clsx from 'clsx'
import {useProductContext} from './Products'
import ImageComponent from './shared/image-component'
import AddToOrderButton from "./AddToOrderButton";
import AdditionalOptionsMenu from "./AdditionalOptionsMenu";
import React from "react";
import CategoryImageItem from "./CategoryImageItem";
import ImageMenuItem from "./ImageMenuItem";

const MenuItem = ({data, onSelect}) => {
    const {isCat}: IMenuItem = data
    return (

        <>
            {isCat ? (
                <CategoryImageItem onSelect={onSelect} data={data}/>
            ) : (<ImageMenuItem onSelect={onSelect} data={data}/>)}
        </>

    )
}
export default MenuItem
