import React, { Fragment, useEffect, useState } from "react";
import { useProductContext } from "./Products";
import Option from "./Option";

function AdditionalOptionsMenu({ data, withImage = false, idel }) {
  const { setOrder, order } = useProductContext();

  const [selectedOptions, setSelectedOptions] = useState([]);

  const generateName = () => {
    if (selectedOptions.length) {
      return `${data.name}(${selectedOptions
        .map((option) => option.name)
        .join("-")})`;
    }
    return data.name;
  };

  const generatePrice = () => {
    let optionsPrice = 0;
    selectedOptions.map((option) => {
      if (option.price) {
        optionsPrice = Number(option.price) + Number(optionsPrice);
      }
    });
    let price = Number(data.price) + optionsPrice;
    if (price > 0) price *= 1000;
    return price;
  };

  const setOptionalOrder = () => {
    const isDuplicateOrder = order.some((item, idx) => {
      // if (item.product.id === Number(data.id) && item.product.options == selectedOptions) {
      if (item.product.unique === `${data.id}-${generateName()}`) {
        let garbage = [...order];
        ++garbage[idx].count;
        setOrder([...garbage]);
        return true;
      }
      return false;
    });
    if (!isDuplicateOrder) {
      setOrder([
        ...order,
        {
          product: {
            name: generateName(),
            baseName: data.name,
            id: Number(data.id),
            price: generatePrice(),
            options: selectedOptions,
            unique: `${data.id}-${generateName()}`,
          },
          count: 1,
        },
      ]);
    }

    setSelectedOptions([]);
  };

  return (
    <Fragment>
      {data.option?.length ? (
        <div className="dropdown" id={`i${idel}`}>
          <div
            tabIndex={0}
            className="mx-4 cursor-pointer hover:text-yellow-500"
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              className="h-8 w-8"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                strokeWidth={2}
                d="M4 6h16M4 12h16M4 18h16"
              />
            </svg>
          </div>
          <ul
            tabIndex={0}
            className="menu dropdown-content py-3 w-52 shadow-lg bg-base-100 rounded-box"
            style={{ zIndex: 1000 }}
          >
            {data.option?.map((option, idx) => {
              return (
                <Option
                  key={idx}
                  option={option}
                  setSelectedOptions={setSelectedOptions}
                  selectedOptions={selectedOptions}
                  withImage={withImage}
                />
              );
            })}
            <li className={"border-t-2"}>
              <button
                tabIndex={0}
                className={
                  "flex justify-center items-center bg-yellow-300 hover:bg-yellow-400 shadow h-10 mt-2 text-gray-700"
                }
                onClick={() => setOptionalOrder()}
              >
                <div className={"ml-1"} style={{ fontSize: "0.8rem" }}>
                  ثبت در سفارش
                </div>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"
                  />
                </svg>
              </button>
            </li>
          </ul>
        </div>
      ) : (
        ""
      )}
    </Fragment>
  );
}

export default AdditionalOptionsMenu;
