import React from 'react';
import { addToOrder } from './shared/addToOrder';

function AddToOrderButton({ isCat, onSelect, data, order, id, setOrder, price, name, noClick = false }) {
    return (
        <>
            <div className={'mr-4 cursor-pointer hover:text-yellow-400'}
                onClick={() => noClick ? void(0) : addToOrder(false, isCat, onSelect, data, order, id, setOrder, price, name, 1)}
            >
                <svg xmlns="http://www.w3.org/2000/svg" className="h-8 w-8" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2}
                        d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
        </>
    );
}

export default AddToOrderButton;