import { CloseOutlined } from '@ant-design/icons';
import { Button, Modal } from 'antd';
import { numberFormat } from 'helpers/format';
import { removeOrder, setOrderStatus } from 'services/order';
import { sendAlert } from 'services/table';

export default function AcceptOrderModal({ show, setShow, data, setData }) {
    const close = () => {
        if (confirm('آیا مطمئن هستید؟')) {
            setShow(false);
            setData({})
        }
    }
    if (!data['priceDetails'])
        return <></>;
    const handleAccept = async () => {
        try {
            if (confirm('آیا مطمئن هستید؟')) {
                let res = await setOrderStatus(data['id'], 10);
                if (res) {
                    sendAlert(true, 'سفارش با موفقیت تایید شد')
                    setShow(false);
                    setData({})
                }
            }
        } catch (error) {

        }
    }
    const handleReject = async () => {
        try {
            if (confirm('آیا مطمئن هستید؟')) {
                let res = await removeOrder(data['id']);
                if (res) {
                    sendAlert(true, 'سفارش با موفقیت رد شد')
                    setShow(false);
                    setData({})
                } else {
                    sendAlert(true, 'سفارش با موفقیت رد شد')
                    setShow(false);
                    setData({})
                }
            }
        } catch (error) {

        }
    }
    return (
        <Modal title="تایید سفارش" open={show} footer={
            <div className='flex gap-2 mt-3'>
                <Button type='primary' className='w-full' danger onClick={handleReject}>رد</Button>
                <Button type='primary' className='w-full' onClick={handleAccept}>تایید</Button>
            </div>
        } closeIcon={<CloseOutlined onClick={close} />}>
            <table className='table w-full'>
                <thead>
                    <tr>
                        <th>نام مشتری</th>
                        <td>{data['customer']['name']}</td>
                        <th>شماره مشتری</th>
                        <td>{data['customer']['username']}</td>
                    </tr>
                </thead>
            </table>
            <table className='table w-full mt-2'>
                <thead>
                    <tr>
                        <th>نام</th>
                        <th>قیمت</th>
                        <th>تعداد</th>
                        <th>مجموع</th>
                    </tr>
                </thead>
                <tbody>
                    {
                        data['cart'] && data['cart']?.length ?
                            data['cart'].map((item, index) => (
                                <tr key={index}>
                                    <td>{item['full_name']}</td>
                                    <td>{item['price']}</td>
                                    <td>{item['qty']}</td>
                                    <td>{item['total']}</td>
                                </tr>
                            )) : ""
                    }
                    <tr>
                        <td colSpan={4} style={{ whiteSpace: 'break-spaces' }}>توضیحات: {data['note']}</td>
                    </tr>
                    <tr>
                        <td colSpan={2}>مالیات: </td>
                        <td colSpan={2}>{numberFormat(data['priceDetails']['tax'])} ت </td>
                    </tr>
                    <tr>
                        <td colSpan={2}>مبلغ قابل پرداخت:</td>
                        <td colSpan={2}>{numberFormat(data['priceDetails']['total'])} ت</td>
                    </tr>
                </tbody>
            </table>
        </Modal>
    )
}
