# A Node.js project which handles orders of a restaurant and sends bills to different printers

## Steps to run this project

### dev

- database
  - docker run -itd -p 5432:5432 -e POSTGRES_PASSWORD=root -e POSTGRES_USER=postgres -e POSTGRES_DB=cafe_db postgres
- app
  - npm run dev

### production

- Install docker for windows
- clone the main repo (not any submodules)
- cd into cloned directory
- git submodule update --init --recursive (this will add all submodules)
- docker-compose up -d (where docker-compose.yml file exists)

## TODO

  - [x] Setup server with typescript and typeormE
  - [x] Setup postgresE
  - [x] Setup docker and compose for orchestrationE
  - [x] All interfacesE
  - [x] User modelE
  - [x] Interactive header based on received dataE
  - [x] All routesE
    - [x] LoginE
    - [x] get dataE
    - [x] Add to basketE
    - [x] submitE
    - [x] autocompleteE
  - [x] Error managementE
  - [x] LoggerE
    - [x] api logger (morgan)E
    - [x] main logger (winston)E
  - [x] middlewaresE
  - [x] validationE
  - [x] Category modelE
  - [x] product modelE
  - [x] Cart modelE
  - [x] Order modelE
  - [x] cart pageE
    - [x] cart functionalitiesE
      - [x] remove itemE
      - [x] add-remove buttonsE
      - [ ] Customer suggestionE
        - [x] functionalE
        - [ ] move between and select items by keyboard E
      - [x] handle new customerE
      - [x] error when no customer selectedE
      - [x] total priceE
      - [x] delete cartE
      - [x] send cartE
      - [x] RefactorE
        - [x] errorsE
        - [x] componentsE
          - [x] customer suggestionE
        - [x] servicesE
          - [x] Get Customer listE
          - [x] Submit OrderE
      - [ ] Sidebar cartE
        - [x] add/remove/delete cartE
        - [x] inner scroll when too many items selectedE
        - [x] get/set customerE
        - [ ] submitE
        - [ ] configE
    - [x] autocomplete boxE
      - [ ] prevent entering farsi charsE
  - [x] LoginE
  - [x] User signoutE
  - [x] Get PrintersE
  - [x] Define PrintersE
    - [x] Reload printers listE
    - [x] Logout user on missing printer info E
    - [x] printer error handlingE
  - [x] Next.jsE
    - [ ] Custom serverE
    - [ ] pkgE
    - [ ] envE
  - [x] FontsE
    - [x] farsi fontsE
    - [x] farsi digitsE
  - [x] RTLE
  - [x] Send to printersE
    - [ ] handle post-print request (garbage collection)E
      - [ ] orderE
      - [ ] customerE
  - [x] final submitE
  - [ ] Show parent title in product pagesE
  - [ ] Save order list in localstorage (or session storage) to prevent losing data on page refreshE
  - [x] optimize and cache product images after first load to speed upE
  - [ ] Single source of truth architecture for offline modeE
    - [ ] Save received info from server into client dbE
    - [ ] Client db is our single source of truthE
    - [ ] Client db needs to get synced with server's db periodicallyE
    - [ ] Check for internet connection availabilityE
    - [ ] Sync menu items and customer dataE
      - [ ] When internet becomes availableE
      - [ ] On a regular basis (like every hour)E
    - [ ] Error HandlingE
      - [ ] Server access is not availableE
      - [ ] Client db is not accessibleE
      - [ ] Syncing errorsE
