"use strict";
(() => {
var exports = {};
exports.id = 302;
exports.ids = [302];
exports.modules = {

/***/ 7377:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ addOrder)
});

;// CONCATENATED MODULE: external "react-toastify"
const external_react_toastify_namespaceObject = require("react-toastify");
;// CONCATENATED MODULE: external "axios"
const external_axios_namespaceObject = require("axios");
var external_axios_default = /*#__PURE__*/__webpack_require__.n(external_axios_namespaceObject);
;// CONCATENATED MODULE: ./helpers/printer.ts


const requestPrintOffline = (order)=>{
    return new Promise((resolve, reject)=>{
        // console.log(order)
        resolve("Thanks");
    });
};
const printer_requestPrint = (order)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: basUrl,
            url: "/print",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(order)
        };
        axios(config).then(function(response) {
            if (response.data.success) {
                resolve(response.data);
            } else reject();
        }).catch(function(error) {
            reject();
        });
    });
};
const getPrinters = ()=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "get",
            baseURL: basUrl,
            url: "/getprinters",
            headers: {}
        };
        axios(config).then(function(response) {
            if (!response.data) {
                //   setIsError(true)
                return reject();
            }
            if (response.data.printers.length === 0) {
                return reject;
            } else {
                // console.log(response.data)
                let printersArr = [];
                response.data.printers.forEach((p)=>{
                    let printer = {
                        name: p.name
                    };
                    printersArr.push(printer);
                });
                // console.log(printersArr)
                resolve(printersArr);
            }
        }).catch(function(error) {
            console.log(error);
            // setIsError(true)
            reject();
        });
    });
};

;// CONCATENATED MODULE: ./baseU.js
// export default "http://192.168.1.103:3000"
// export default "http://192.168.1.4:3000"
/* harmony default export */ const baseU = ("http://localhost:3000");

;// CONCATENATED MODULE: ./services/order.ts




const getCustomer = (token, query, searchWithId = 0)=>{
    return new Promise((resolve, reject)=>{
        var data = new FormData();
        data.append("token", token);
        var config = {
            method: "post",
            url: `/check-user?q=${query}&point=${1}&search_with_id=${searchWithId}&is_seperate_name=1`,
            data: data
        };
        axios(config).then(function(response) {
            resolve(response.data["results"]);
        }).catch(function(error) {
            // console.log(error)
            reject();
        });
    });
};
const submitOrderOffline = (order, customer, totalAmount, printers, offline_id, custom_print_valuet, raw_items, table_id, factorID, discount, print_type, p_bill, p_bar, phone, note, numPeople, borderSize, fontSize, pageWidth, service, reprint, tip, taxPrice, loviuna, branchData, isOnline, customFields)=>{
    let no_brand = "";
    let branchName = "";
    let custom_note = "";
    if (!branchData) {
        no_brand = localStorage.getItem("no_brand");
        if (!no_brand) no_brand = "0";
        branchName = localStorage.getItem("branch_name");
        if (localStorage.getItem("custom_note")) custom_note = localStorage.getItem("custom_note");
    } else {
        no_brand = branchData["no_brand"];
        branchName = branchData["branchName"];
        custom_note = branchData["custom_note"] ? branchData["custom_note"] : "";
    }
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: baseU,
            url: "submit-order",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                order,
                customer,
                totalAmount,
                printers,
                offline_id,
                custom_print_valuet,
                raw_items,
                table_id,
                factorID,
                discount,
                print_type,
                p_bill,
                p_bar,
                phone,
                note,
                numPeople,
                borderSize,
                fontSize,
                pageWidth,
                service,
                reprint,
                tip,
                taxPrice,
                loviuna,
                no_brand,
                branchName,
                isOnline,
                custom_note,
                customFields
            })
        };
        external_axios_default()(config).then(function(response) {
            // console.log(response.data)
            resolve(response.data);
        }).catch((error)=>{
            console.log(error);
            reject(error);
        });
    });
};
const saveOrderOffline = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: baseU,
            url: "api/create",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        external_axios_default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const findOrder = (req, one)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: baseU,
            url: "api/find" + (one == 1 ? "?one=1" : ""),
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        external_axios_default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const saveBranch = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: basUrl,
            url: "api/branch",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const submitOrder = (order, token, customer, note, tableId, orderTypeDefault, paymentTypeDefault, usePoint, useDiscount, customerNote, noCustomer, orderId, numPeople)=>{
    return new Promise((resolve, reject)=>{
        let cart = [];
        order.forEach((item)=>{
            cart.push({
                id: item.product.id,
                options: item.product.options,
                qty: item.count,
                note: item.note
            });
        });
        let finalOrder = {
            cart,
            user_id: customer.id === 0 ? customer.name : customer.id
        };
        var data = new FormData();
        data.append("token", token);
        data.append("cart", JSON.stringify(finalOrder));
        data.append("note", note);
        data.append("table_id", tableId);
        data.append("order_type_default", orderTypeDefault);
        data.append("payment_type", paymentTypeDefault);
        data.append("usePoint", usePoint);
        data.append("useDiscount", useDiscount.id);
        data.append("customer_note", customerNote);
        data.append("noCustomer", noCustomer.toString());
        data.append("order_id", orderId == 0 ? "" : orderId);
        data.append("numPeople", numPeople ? numPeople : "");
        var config = {
            method: "post",
            url: "/submit-order",
            data: data
        };
        axios(config).then(function(response) {
            const printers = response.data.print_list;
            const printerBehave = localStorage.getItem("printer_behave_default");
            if (response.data.msg) {
                // alert(response.data.msg)
                toast.error(response.data.msg, {
                    position: "bottom-right",
                    style: {
                        direction: "rtl",
                        fontFamily: "IRANSansX"
                    },
                    theme: "colored"
                });
            }
            let printersArr = [];
            // console.log(printers);
            if (!printers) return reject();
            Object.keys(printers).forEach((node)=>{
                let printer = localStorage.getItem(node);
                let printerNode = printers[node];
                // Management of individual printers
                const custom_print_valuet = JSON.parse(localStorage.getItem("custom_print_valuet") || "[]");
                const raw_items = JSON.parse(localStorage.getItem("raw_items"));
                if (custom_print_valuet[node] && custom_print_valuet[node].cat) {
                    let PO = [];
                    order.map((item, i)=>{
                        if (custom_print_valuet[node].cat.includes(raw_items[item.product.id].category_id.toString())) {
                            PO.push(i);
                        }
                    });
                    if (PO.length == 0) {
                        return;
                    }
                }
                if (!printer) {
                // router.push('/printers')
                } else {
                    //print behave
                    if (printerBehave == "بدون پرینت") {}
                    if (printerBehave == "پرینت باریستا") {
                        if (printerNode.type == "bar_all") {
                            printersArr.push({
                                id: node,
                                name: printer,
                                page: printerNode.path
                            });
                        }
                    }
                    if (printerBehave == "پرینت مشتری و باریستا") {
                        printersArr.push({
                            id: node,
                            name: printer,
                            page: printerNode.path
                        });
                    }
                }
            });
            if (printerBehave != "بدون پرینت" && printersArr.length) {
                const printOrder = {
                    printers: printersArr,
                    orderId: response.data.order_id,
                    billUrl: printersArr[0].page,
                    totalItems: response.data.item.length
                };
                requestPrint(printOrder).then((resp)=>{
                    resolve(resp);
                }).catch((err)=>{
                    reject(err);
                });
            } else {
                resolve("ok");
            }
        }).catch(function(error) {
            console.log("catch");
            reject();
        });
    });
};
const saveBill5 = (printer_id, pinter_name, pdf_url, status, orderId)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: basUrl,
            url: "print1",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                printer_id,
                pinter_name,
                pdf_url,
                status,
                orderId
            })
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const getTableList = ()=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        const config = {
            method: "post",
            url: "/table?offline=1",
            data
        };
        axios(config).then(function({ data  }) {
            resolve(data.table_list);
        }).catch((error)=>reject(error));
    });
};
const getOnlineOrderData = (order_id, action = null)=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        const config = {
            method: "post",
            url: action ? "/get-order-data2" : "/get-order-data",
            data
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const createOrderData = (order)=>{
    let raw_items = localStorage.getItem("raw_items") || "[]";
    raw_items = JSON.parse(raw_items);
    let newOrder = [];
    Object.keys(order["items"]).map((item)=>{
        let id_item = item.split("_")[0];
        let options = [];
        if (order["items"][item]["options"] != null) {
            const opts = JSON.parse(order["items"][item]["options"] || "[]");
            for (const opt of opts){
                options.push({
                    id: opt,
                    name: raw_items[opt]["name"],
                    price: raw_items[opt]["last_price"] * 1000,
                    image: ""
                });
            }
        }
        newOrder = [
            ...newOrder,
            {
                product: {
                    name: `${options.length ? `${raw_items[id_item].name}(${options.map((opt)=>opt.name).join("-")})` : raw_items[id_item].name}`,
                    baseName: raw_items[id_item].name,
                    id: Number(id_item),
                    price: (options.length ? options.map((i)=>i.price).reduce((accumulator, curr)=>accumulator + curr) + raw_items[id_item].last_price : raw_items[id_item].last_price) * 1000,
                    options: options,
                    vat_include: raw_items[id_item].vat_include,
                    unique: `${id_item}-${options.length ? `${raw_items[id_item].name}(${options.map((opt)=>opt.name).join("-")})` : raw_items[id_item].name}`
                },
                count: order["items"][item]["qty"],
                note: order["items"][item]["note"] ? order["items"][item]["note"] : "",
                custom_fields: order?.["order"]?.["custom"] || null
            }, 
        ];
    });
    return newOrder;
};
const setOrderStatus = (order_id, status)=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        data.append("status", status);
        const config = {
            method: "post",
            url: "/set-order-status",
            data
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const removeOrder = (order_id)=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        const config = {
            method: "post",
            url: "/remove-order",
            data
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const printAllOrders = (orders, pageWidth, startDate, endDate, borderSize, fontSize, totalAmount, printers)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: basUrl,
            url: "print-all-order",
            // url: "api/test",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                orders,
                pageWidth,
                startDate,
                endDate,
                borderSize,
                fontSize,
                totalAmount,
                printers
            })
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};

;// CONCATENATED MODULE: ./apiUrl.js
/* harmony default export */ const apiUrl = ([
    "https://viunaorder.avishost.com",
    "https://viunaorder.avishost.com/restapi"
]);

;// CONCATENATED MODULE: ./helpers/format.ts
function formatPrice(price) {
    // console.log(price);
    price *= 10;
    let formattedPrice = price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice + " ریال";
}
function formatPrice2(price) {
    price = price;
    let price2 = price.toFixed();
    let formattedPrice = price2.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice;
}
function cartTotalPrice(cart, tax) {
    let totalPrice = cart.map((item)=>item.product.price * item.count).reduce((prev, next)=>prev + next, 0);
    if (tax === "1") {
        const noVat = cart.map((item)=>item.product.vat_include == 1 ? item.product.price * item.count : 0).reduce((prev, next)=>prev + next, 0);
        let final = totalPrice - noVat;
        let vat_percent = localStorage.getItem("vat_percent");
        vat_percent = vat_percent ? parseFloat(vat_percent) : 0.1;
        let taxPrice = final * vat_percent;
        totalPrice += taxPrice;
    }
    let finalPrice = formatPrice(roundFinalPrice(totalPrice));
    return finalPrice;
}
function roundFinalPrice(totalPrice, show_zero = false) {
    let text = totalPrice.toFixed();
    let replacement = "00";
    let result = text.substring(0, text.length - 2) + replacement;
    let finalPrice = parseInt(result);
    if (finalPrice == 0 && !show_zero) finalPrice = .1;
    return finalPrice;
}
function cartTotalPrice2(cart) {
    const totalPrice = cart.map((item)=>item.product.price * item.count).reduce((prev, next)=>prev + next, 0);
    return totalPrice;
}
function cartTotalTax(totalPrice, tax, tip, cart) {
    const noVat = cart.map((item)=>item.product.vat_include == 1 ? item.product.price * item.count : 0).reduce((prev, next)=>prev + next, 0);
    if (tip) totalPrice -= parseInt(tip);
    totalPrice -= noVat;
    if (tax !== "1") return 0;
    let vat_percent = localStorage.getItem("vat_percent");
    vat_percent = vat_percent ? parseFloat(vat_percent) : 0.1;
    let taxPrice = totalPrice * vat_percent;
    taxPrice = taxPrice;
    return Math.round(taxPrice);
}
const p2e = (s)=>s.replace(/[۰-۹]/g, (d)=>"۰۱۲۳۴۵۶۷۸۹".indexOf(d));
const e2p = (s)=>s.replace(/\d/g, (d)=>"۰۱۲۳۴۵۶۷۸۹"[d]);
const parseInputValue = (value, number = false)=>{
    if (value) {
        value = p2e(value);
        if (/\D/g.test(value) && number) {
            value = value.replace(/[^0-9.-]/g, "");
        }
        return value;
    }
    return value;
};
function numberFormat(price) {
    let formattedPrice = price ? price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") : "";
    return formattedPrice;
}
function maskm(val) {
    val = p2e(val).replace(/\D/g, "");
    val = val.replace(/,/g, "");
    val = numberFormat(val);
    return val;
}

;// CONCATENATED MODULE: ./services/printOrder.ts



const printOrder = async (order, repeat, salon, printer, reprint, print_type, raw_items, printData)=>{
    if (order["order"]) {
        let o = JSON.parse(order["order"].order_details);
        let local = JSON.parse(order["order"].order_local);
        o["detail"].table_id = order["order"].table_id;
        o["detail"].use_point = order["order"].use_point ? order["order"].use_point : false;
        o["detail"].user_point = order["order"].user_point ? order["order"].user_point : 0;
        o["detail"].service = order["order"].service ? order["order"].service : "";
        o["detail"].tip = order["order"].tip ? order["order"].tip : "";
        o["detail"].payment_card = order["order"].payment_card ? order["order"].payment_card : "";
        o["detail"].payment_pos = order["order"].payment_pos ? order["order"].payment_pos : "";
        o["detail"].payment_cash = order["order"].payment_cash ? order["order"].payment_cash : "";
        o["detail"].numPeople = local.numPeople ? local.numPeople : "";
        o["detail"].note = order["order"].note ? order["order"].note : "";
        o["detail"].userDiscount = order["order"].userDiscount ? order["order"].userDiscount : "";
        if (salon) o["salon"] = salon;
        if (printer) o["printer"] = printer;
        // console.log('sadsadsadsad')
        renderDetailsOrderInCart(o, repeat, order["order"], reprint ? reprint : 0, print_type ? print_type : "", raw_items, printData);
    }
};
const renderDetailsOrderInCart = (order, repeatPrint, orderObj, reprint, print_type, raw_items, printData)=>{
    let newOrder = getNewOrder(order, raw_items);
    if (repeatPrint != 1) {
        return true;
    } else {
        repeatPrintOffline(order, newOrder, orderObj, reprint ? reprint : 0, print_type ? print_type : "", raw_items, printData);
    }
};
const getNewOrder = (order, raw_items)=>{
    let newOrder = [];
    Object.keys(order["items"]).map((item)=>{
        let id_item = item.split("_")[0];
        let options = [];
        if (order["items"][item]["options"] != null) {
            const opts = JSON.parse(order["items"][item]["options"] || "[]");
            for (const opt of opts){
                options.push({
                    id: opt,
                    name: raw_items[opt]["name"],
                    price: raw_items[opt]["last_price"] / 1000,
                    image: apiUrl[0] + "/"
                });
            }
        }
        newOrder = [
            ...newOrder,
            {
                product: {
                    name: `${options.length ? `${raw_items[id_item].name}(${options.map((opt)=>opt.name).join("-")})` : raw_items[id_item].name}`,
                    baseName: raw_items[id_item].name,
                    id: Number(id_item),
                    price: (options.length ? options.map((i)=>i.price).reduce((accumulator, curr)=>accumulator + curr) + raw_items[id_item].last_price : raw_items[id_item].last_price) * 1000,
                    options: options,
                    vat_include: raw_items[id_item].vat_include,
                    unique: `${id_item}-${options.length ? `${raw_items[id_item].name}(${options.map((opt)=>opt.name).join("-")})` : raw_items[id_item].name}`
                },
                count: order["items"][item]["qty"],
                note: order["items"][item]["note"] ? order["items"][item]["note"] : ""
            }, 
        ];
    });
    return newOrder;
};
const repeatPrintOffline = (order, newOrder, orderObj, reprint, print_type, raw_items, printData)=>{
    const orderId = order["detail"].id;
    const tableId = order["detail"].table_id;
    let totalAmount = 0;
    newOrder.map((item)=>{
        totalAmount += item.product.price * item.count;
    });
    let price = totalAmount;
    let discount = orderObj.discount;
    if (discount) totalAmount -= parseInt(discount);
    if (orderObj.service) totalAmount += parseInt(orderObj.service);
    if (orderObj.tip) totalAmount += parseInt(orderObj.tip);
    if (orderObj.tax) totalAmount += orderObj.tax;
    // const totalAmount = orderObj.total;
    const factorID = orderObj._id;
    let customer = {
        name: "",
        id: -1
    };
    if (order["detail"].user_name) customer = {
        name: order["detail"].user_name,
        id: 0
    };
    let p_bill = null;
    let printer = null;
    if (order.printer) printer = order.printer;
    totalAmount = roundFinalPrice(totalAmount);
    printOrder_requestPrintOffline(newOrder, customer, formatPrice(totalAmount), orderId, factorID, discount, tableId, print_type, p_bill, printer, orderObj.note, "", order["detail"].service, reprint, orderObj.tip ? orderObj.tip : null, orderObj.tax, orderObj.loviuna, raw_items, printData);
};
const printOrder_requestPrintOffline = (order, customer, totalAmount, offline_id, factorID, useDiscount, table_id, print_type, p_bill, printer, note, numPeople, service, reprint, tip, taxPrice, loviuna, raw_items, printData)=>{
    let prns = printData["prns"];
    let custom_print_valuet = printData["custom_print_valuet"];
    let salon = printData["salon"];
    let tabales = printData["tabales"];
    let phone = printData["phone"];
    let p_bar;
    if (table_id) {
        if (salon != null) Object.keys(salon).forEach((k)=>{
            if (tabales[k][table_id]) {
                p_bar = salon[k].p_bar;
            }
        });
    }
    let borderSize = printData["borderSize"];
    let fontSize = printData["fontSize"];
    let pageWidth = printData["pageWidth"];
    print_type = "پرینت مشتری و باریستا";
    submitOrderOffline(order, customer, totalAmount, prns, offline_id, custom_print_valuet, raw_items, table_id, factorID, useDiscount, print_type, p_bill, p_bar, phone, note, numPeople, borderSize, fontSize, pageWidth, service, reprint, tip, taxPrice, loviuna, {
        no_brand: printData["no_brand"],
        branchName: printData["branchName"],
        custom_note: printData["custom_note"]
    }).then((response)=>{
    // console.log('response', response);
    }).catch((err)=>{
        console.log("err", err);
    });
};

;// CONCATENATED MODULE: ./pages/api/poz.js



/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */ async function addOrder(req, res) {
    try {
        let order_id = req.body.order_id;
        delete req.body.order_id;
        let raw_items = req.body.raw_items;
        delete req.body.raw_items;
        let print_type = req.body.print_type;
        delete req.body.print_type;
        let print_data = req.body.print_data;
        delete req.body.print_data;
        let update = {
            id: order_id,
            poz_response: req.body
        };
        if (req.body.ResponseCode == "00") {
            update["status"] = 6;
        }
        let order = await findOrder({
            offline_id: order_id
        }, 1);
        saveOrderOffline(update).then((r)=>{
            if (r["order"]) {
                // console.log("test", order["order"]["status"]);
                // console.log("test2", r["order"]["status"]);
                if (order["order"]["status"] == -2 && r["order"]["status"] == 6) {
                    console.log("from poz ==>");
                    console.log(r, order);
                    printOrder(r, 1, null, null, 1, print_type, raw_items, print_data);
                }
                return res.status(200).json({
                    success: true,
                    msg: req.body.ResponseDescription,
                    status: r["order"].status
                });
            }
        });
    } catch (error) {
        console.log(error);
        res.json({
            error
        });
    }
}


/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(7377));
module.exports = __webpack_exports__;

})();