"use strict";
(() => {
var exports = {};
exports.id = 122;
exports.ids = [122];
exports.modules = {

/***/ 1185:
/***/ ((module) => {

module.exports = require("mongoose");

/***/ }),

/***/ 7204:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const materialLogSchema = new mongoose__WEBPACK_IMPORTED_MODULE_0__.Schema({
    _id: Number,
    id: Number,
    qty: Number,
    hash: String,
    status: Number
});
const MaterialLog = mongoose__WEBPACK_IMPORTED_MODULE_0__.models.MaterialLog || (0,mongoose__WEBPACK_IMPORTED_MODULE_0__.model)("MaterialLog", materialLogSchema);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaterialLog);


/***/ }),

/***/ 2496:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ saveMaterialLog)
/* harmony export */ });
/* harmony import */ var models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7204);
/* harmony import */ var util_connectMongo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8016);


const getTime = ()=>{
    const d = new Date();
    let time = d.getTime();
    return time;
};
/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */ async function saveMaterialLog(req, res) {
    try {
        await (0,util_connectMongo__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)();
        let order;
        if (req.body.delete) {
            let logs = await models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"].deleteMany */ .Z.deleteMany();
            return res.status(200).json(logs);
        }
        if (req.body.remove) {
            let logs1 = await models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"].deleteOne */ .Z.deleteOne(req.body);
            return res.status(200).json(logs1);
        }
        if (req.body.update) {
            let logs2 = await models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"].updateMany */ .Z.updateMany({
                status: req.body.status
            }, {
                "$set": {
                    "status": req.body.newStatus
                }
            });
            return res.status(200).json(logs2);
        }
        if (req.body.data) {
            let data = req.body.data;
            for(const key in data){
                let doc = await models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"].findOne */ .Z.findOne({
                    id: key,
                    status: 0
                }).then(async (item)=>{
                    if (item) {
                        item.qty = parseFloat(data[key]) + parseFloat(item.qty);
                        order = await item.save();
                    } else {
                        let count = await models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"].findOne */ .Z.findOne({}, {}, {
                            sort: {
                                "_id": -1
                            }
                        });
                        if (!count) count = 1;
                        else count = count._id + 1;
                        let hash = `${req.body.branch_id}_${key}_${getTime()}`;
                        order = await models_materialLogModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"].create */ .Z.create({
                            _id: count,
                            id: key,
                            qty: data[key],
                            status: 0,
                            hash: hash
                        });
                    }
                });
            }
        }
        return res.status(200).json(order);
    // order = await MaterialLog.findOne({ _id: req.body._id }).then(item => {
    //     if (!item) {
    //         MaterialLog.create(req.body);
    //     } else {
    //         let qty = (parseFloat(req.body.qty) + parseFloat(item.qty));
    //         MaterialLog.updateOne({ _id: req.body._id }, { qty: qty }, function (err, docs) {
    //             if (err) {
    //                 console.log(err)
    //             }
    //             else {
    //                 console.log("Updated Docs : ", docs);
    //             }
    //         })
    //     }
    // })
    // return res.status(200).json(order);
    } catch (error) {
        console.log(error);
        return res.json({
            error
        });
    }
}


/***/ }),

/***/ 8016:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const connectMongo = async ()=>mongoose__WEBPACK_IMPORTED_MODULE_0___default().connect(process.env.MONGO_URI);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (connectMongo);


/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(2496));
module.exports = __webpack_exports__;

})();