"use strict";
(() => {
var exports = {};
exports.id = 762;
exports.ids = [762];
exports.modules = {

/***/ 1185:
/***/ ((module) => {

module.exports = require("mongoose");

/***/ }),

/***/ 5872:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const logSchema = new mongoose__WEBPACK_IMPORTED_MODULE_0__.Schema({
    _id: Number,
    item_id: Number,
    item_name: String,
    qty: Number,
    status: Number,
    info: String
});
const Log = mongoose__WEBPACK_IMPORTED_MODULE_0__.models.Log || (0,mongoose__WEBPACK_IMPORTED_MODULE_0__.model)("Log", logSchema);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Log);


/***/ }),

/***/ 7204:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const materialLogSchema = new mongoose__WEBPACK_IMPORTED_MODULE_0__.Schema({
    _id: Number,
    id: Number,
    qty: Number,
    hash: String,
    status: Number
});
const MaterialLog = mongoose__WEBPACK_IMPORTED_MODULE_0__.models.MaterialLog || (0,mongoose__WEBPACK_IMPORTED_MODULE_0__.model)("MaterialLog", materialLogSchema);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaterialLog);


/***/ }),

/***/ 8261:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const materialSchema = new mongoose__WEBPACK_IMPORTED_MODULE_0__.Schema({
    _id: Number,
    data: Object
});
const Material = mongoose__WEBPACK_IMPORTED_MODULE_0__.models.Material || (0,mongoose__WEBPACK_IMPORTED_MODULE_0__.model)("Material", materialSchema);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Material);


/***/ }),

/***/ 3465:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ findOrder)
/* harmony export */ });
/* harmony import */ var models_logModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5872);
/* harmony import */ var models_materialLogModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7204);
/* harmony import */ var models_materialModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8261);
/* harmony import */ var util_connectMongo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8016);




/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */ async function findOrder(req, res) {
    try {
        await (0,util_connectMongo__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)();
        let order, model;
        switch(req.query.model){
            case "MaterialLog":
                model = models_materialLogModel__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z;
                break;
            case "Material":
                model = models_materialModel__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z;
                break;
            case "Log":
                model = models_logModel__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z;
                break;
        }
        if (req.body.count == 1) {
            delete req.body.count;
            order = await model.find(req.body).count();
            return res.status(200).json(order);
        }
        if (req.body.remove == 1) {
            order = await model.deleteOne(req.body);
            return res.status(200).json(order);
        }
        if (req.body.removeAll == 1) {
            order = await model.deleteMany();
            return res.status(200).json(order);
        }
        let limit = 1000;
        let skip = 0;
        let sort = 1;
        if (req.body.sort) {
            sort = req.body.sort;
            delete req.body.sort;
        }
        if (req.body.limit) {
            limit = req.body.limit;
            skip = req.body.skip;
            delete req.body.limit;
            delete req.body.skip;
        }
        if (req.query.one == 1) order = await model.findOne(req.body);
        else {
            order = await model.find(req.body).skip(skip).limit(limit).sort({
                _id: sort
            });
        }
        return res.status(200).json(order);
    } catch (error) {
        res.json({
            error
        });
    }
}


/***/ }),

/***/ 8016:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const connectMongo = async ()=>mongoose__WEBPACK_IMPORTED_MODULE_0___default().connect(process.env.MONGO_URI);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (connectMongo);


/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(3465));
module.exports = __webpack_exports__;

})();