"use strict";
(() => {
var exports = {};
exports.id = 543;
exports.ids = [543];
exports.modules = {

/***/ 1185:
/***/ ((module) => {

module.exports = require("mongoose");

/***/ }),

/***/ 9491:
/***/ ((module) => {

module.exports = require("assert");

/***/ }),

/***/ 2231:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ saveBranch)
});

// EXTERNAL MODULE: external "assert"
var external_assert_ = __webpack_require__(9491);
// EXTERNAL MODULE: external "mongoose"
var external_mongoose_ = __webpack_require__(1185);
;// CONCATENATED MODULE: ./models/branchModel.js

const branchSchema = new external_mongoose_.Schema({
    _id: Number,
    cronjob: String,
    token: String,
    name: String,
    warehouse: Number
});
const Branch = external_mongoose_.models.Branch || (0,external_mongoose_.model)("Branch", branchSchema);
/* harmony default export */ const branchModel = (Branch);

// EXTERNAL MODULE: ./util/connectMongo.ts
var connectMongo = __webpack_require__(8016);
;// CONCATENATED MODULE: ./pages/api/branch.js



/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */ async function saveBranch(req, res) {
    try {
        await (0,connectMongo/* default */.Z)();
        let order;
        if (req.body.id) {
            order = await branchModel.findOne(req.body);
        } else {
            await branchModel.deleteMany();
            order = await branchModel.create(req.body);
        }
        return res.status(200).json({
            order
        });
    } catch (error) {
        console.log(error);
        res.json({
            error
        });
    }
}


/***/ }),

/***/ 8016:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1185);
/* harmony import */ var mongoose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(mongoose__WEBPACK_IMPORTED_MODULE_0__);

const connectMongo = async ()=>mongoose__WEBPACK_IMPORTED_MODULE_0___default().connect(process.env.MONGO_URI);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (connectMongo);


/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(2231));
module.exports = __webpack_exports__;

})();