(() => {
var exports = {};
exports.id = 888;
exports.ids = [888,231];
exports.modules = {

/***/ 9410:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ AcceptOrderModal)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
;// CONCATENATED MODULE: external "@ant-design/icons"
const icons_namespaceObject = require("@ant-design/icons");
// EXTERNAL MODULE: external "antd"
var external_antd_ = __webpack_require__(5725);
// EXTERNAL MODULE: ./helpers/format.ts
var format = __webpack_require__(890);
// EXTERNAL MODULE: ./services/order.ts
var order = __webpack_require__(2145);
// EXTERNAL MODULE: ./services/table.ts
var table = __webpack_require__(3954);
;// CONCATENATED MODULE: ./components/AcceptOrder.tsx






function AcceptOrderModal({ show , setShow , data , setData  }) {
    const close = ()=>{
        if (confirm("آیا مطمئن هستید؟")) {
            setShow(false);
            setData({});
        }
    };
    if (!data["priceDetails"]) return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {});
    const handleAccept = async ()=>{
        try {
            if (confirm("آیا مطمئن هستید؟")) {
                let res = await (0,order/* setOrderStatus */.hn)(data["id"], 10);
                if (res) {
                    (0,table/* sendAlert */.O1)(true, "سفارش با موفقیت تایید شد");
                    setShow(false);
                    setData({});
                }
            }
        } catch (error) {}
    };
    const handleReject = async ()=>{
        try {
            if (confirm("آیا مطمئن هستید؟")) {
                let res = await (0,order/* removeOrder */.QS)(data["id"]);
                if (res) {
                    (0,table/* sendAlert */.O1)(true, "سفارش با موفقیت رد شد");
                    setShow(false);
                    setData({});
                } else {
                    (0,table/* sendAlert */.O1)(true, "سفارش با موفقیت رد شد");
                    setShow(false);
                    setData({});
                }
            }
        } catch (error) {}
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)(external_antd_.Modal, {
        title: "تایید سفارش",
        open: show,
        footer: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
            className: "flex gap-2 mt-3",
            children: [
                /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Button, {
                    type: "primary",
                    className: "w-full",
                    danger: true,
                    onClick: handleReject,
                    children: "رد"
                }),
                /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Button, {
                    type: "primary",
                    className: "w-full",
                    onClick: handleAccept,
                    children: "تایید"
                })
            ]
        }),
        closeIcon: /*#__PURE__*/ jsx_runtime_.jsx(icons_namespaceObject.CloseOutlined, {
            onClick: close
        }),
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("table", {
                className: "table w-full",
                children: /*#__PURE__*/ jsx_runtime_.jsx("thead", {
                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("tr", {
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("th", {
                                children: "نام مشتری"
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                children: data["customer"]["name"]
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("th", {
                                children: "شماره مشتری"
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                children: data["customer"]["username"]
                            })
                        ]
                    })
                })
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("table", {
                className: "table w-full mt-2",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("thead", {
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("tr", {
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("th", {
                                    children: "نام"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("th", {
                                    children: "قیمت"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("th", {
                                    children: "تعداد"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("th", {
                                    children: "مجموع"
                                })
                            ]
                        })
                    }),
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("tbody", {
                        children: [
                            data["cart"] && data["cart"]?.length ? data["cart"].map((item, index)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("tr", {
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                            children: item["full_name"]
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                            children: item["price"]
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                            children: item["qty"]
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                            children: item["total"]
                                        })
                                    ]
                                }, index)) : "",
                            /*#__PURE__*/ jsx_runtime_.jsx("tr", {
                                children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("td", {
                                    colSpan: 4,
                                    style: {
                                        whiteSpace: "break-spaces"
                                    },
                                    children: [
                                        "توضیحات: ",
                                        data["note"]
                                    ]
                                })
                            }),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("tr", {
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                        colSpan: 2,
                                        children: "مالیات: "
                                    }),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("td", {
                                        colSpan: 2,
                                        children: [
                                            (0,format/* numberFormat */.Y4)(data["priceDetails"]["tax"]),
                                            " ت "
                                        ]
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("tr", {
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx("td", {
                                        colSpan: 2,
                                        children: "مبلغ قابل پرداخت:"
                                    }),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("td", {
                                        colSpan: 2,
                                        children: [
                                            (0,format/* numberFormat */.Y4)(data["priceDetails"]["total"]),
                                            " ت"
                                        ]
                                    })
                                ]
                            })
                        ]
                    })
                ]
            })
        ]
    });
}


/***/ }),

/***/ 9732:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ components_Header)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(1853);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
var link_default = /*#__PURE__*/__webpack_require__.n(next_link);
// EXTERNAL MODULE: ./components/shared/image-component.tsx
var image_component = __webpack_require__(7930);
// EXTERNAL MODULE: ./config/index.ts + 2 modules
var config = __webpack_require__(706);
;// CONCATENATED MODULE: ./components/shared/Logo.tsx





var logoType;
(function(logoType) {
    logoType["Full"] = "logo-full.png";
    logoType["White"] = "logo-w.png";
    logoType["Black"] = "logo-b.png";
    logoType["Text"] = "viuna.png";
    logoType["Gold"] = "logo-g.png";
})(logoType || (logoType = {}));
const Logo = ({ w =260 , h =75 , type =logoType.Full  })=>{
    return /*#__PURE__*/ jsx_runtime_.jsx("div", {
        className: "flex items-center ",
        children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
            href: "/",
            "aria-label": "Homepage",
            children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                className: "px-2 flex-0 md:px-4 md:mt-4",
                children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                    className: "inline-block full-logo-",
                    children: [
                        /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                            src: `/images/logo/${type}`,
                            layout: "fixed",
                            width: w,
                            height: h,
                            alt: "viuna full logo"
                        }),
                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                            className: "hidden lg:inline text-gray-400",
                            style: {
                                fontSize: "0.8rem"
                            },
                            children: [
                                "نسخه",
                                /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    className: "mr-2",
                                    children: config/* default.version */.Z.version
                                })
                            ]
                        })
                    ]
                })
            })
        })
    });
};
/* harmony default export */ const shared_Logo = (Logo);

// EXTERNAL MODULE: ./components/Products.ts
var Products = __webpack_require__(767);
// EXTERNAL MODULE: external "axios"
var external_axios_ = __webpack_require__(2167);
var external_axios_default = /*#__PURE__*/__webpack_require__.n(external_axios_);
;// CONCATENATED MODULE: ./helpers/connection.ts

// import {version} from 'package.json'
const checkConnectionStatus = ()=>{
    const token = localStorage.getItem("token");
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            // url: `/check_connection?token=${token}&version=${version}`,
            url: `/check_connection?token=${token}`,
            headers: {}
        };
        external_axios_default()(config).then(function(response) {
            // * if(response.data.latestVersion == false) {}
            // todo check latest version app from show message update
            resolve(response.data);
        }).catch(function(error) {
            reject(error);
        });
    });
};
const handleOfflineMode = ()=>{};

// EXTERNAL MODULE: ./helpers/offline.ts
var helpers_offline = __webpack_require__(9977);
// EXTERNAL MODULE: ./components/contexts/simpleContext.ts
var simpleContext = __webpack_require__(4373);
;// CONCATENATED MODULE: ./components/Header.tsx










const Header = ({ showSidebar , setShowSidebar  })=>{
    const router = (0,router_.useRouter)();
    const isHomepage = router.pathname == "/";
    const { 0: scrolled , 1: setScrolled  } = (0,external_react_.useState)(false);
    const { 0: havePrintersList , 1: setHavePrintersList  } = (0,external_react_.useState)(false);
    const { order , setOrder , offline , setOffline , offlineBills , setOfflineBills , setToken , token , tableId ,  } = (0,Products/* useProductContext */.$)();
    const alert = (0,external_react_.useRef)(null);
    function toggleNavClass() {
        if (scrolled == false) {
            return false;
        } else {
            return true;
        }
    }
    function handleUploadOfflineBills() {
        (0,helpers_offline/* uploadOfflineOrders */.E7)(localStorage.getItem("token")).then((resp)=>{
            updateBills();
        }).catch((err)=>{
        // console.log(err)
        });
    }
    function showConnectionError() {
        alert.current.classList.remove("hidden");
        setTimeout(()=>{
            hideConnectionError();
        }, 2000);
    }
    function hideConnectionError() {
        alert.current.classList.add("hidden");
    }
    function reloadItems() {
        let id = router.query.id;
        if (!id) {
            id = "0";
        }
        localStorage.removeItem(`level${id}`);
        router.reload();
    }
    function logOut() {
        setToken(null);
        localStorage.removeItem("token");
        setOrder([]);
        router.push("/login");
    }
    function updateBills() {
        let storageOrders = localStorage.getItem("localOrders");
        if (storageOrders) {
            setOfflineBills(JSON.parse(storageOrders).length);
        } else {
            setOfflineBills(0);
        }
    }
    function updateToken() {
        if (router.pathname !== "/login") {
            if (!token) {
                let _token = localStorage.getItem("token");
                if (_token) {
                    setToken(_token);
                } else {
                    router.push("/login");
                }
            }
        }
    }
    (0,external_react_.useEffect)(()=>{
        if (router.pathname === "/login") return;
        updateBills();
        updateToken();
        const printers = localStorage.getItem("printers");
        if (printers) setHavePrintersList(true);
        window.document.onscroll = ()=>{
            const navBar = document.getElementById("nav");
            if (window.scrollY > navBar.offsetTop) {
                setScrolled(true);
            } else {
                setScrolled(false);
            }
        };
    // checkConnectionStatus()
    //   .then((resp: IConnectionStatus) => {
    //     if (resp.msg !== 'Connection Established ..') {
    //       setOffline(true)
    //     } else {
    //       // setOffline(false)
    //       // ask user to go online
    //     }
    //   })
    //   .catch((err) => {
    //     setOffline(true)
    //   })
    }, [
        router,
        token
    ]);
    const { setListMode , listMode  } = (0,simpleContext/* simpleContext */.O)();
    const RefButtonToggleStatusConnection = (0,external_react_.useRef)(null);
    (0,external_react_.useEffect)(()=>{
        // window.addEventListener('load', () => {
        //   if (!offline) {
        //     RefButtonToggleStatusConnection.current.click();
        //   }
        // });
        // window.addEventListener('online', () => {
        //   hideConnectionError()
        //   checkConnectionStatus()
        //     .then((res: IConnectionStatus) => {
        //       if (res.msg === 'Connection Established ..') {
        //         setOffline(false)
        //         updateToken()
        //         RefButtonToggleStatusConnection.current.click();
        //       } else {
        //         showConnectionError()
        //       }
        //     })
        //     .catch((err) => {
        //       // console.log(err)
        //       showConnectionError()
        //     })
        // });
        // window.addEventListener('offline', () => {
        //   hideConnectionError()
        //   setOffline(true)
        // });
        window.addEventListener("resize", ()=>{
            if (window.innerWidth < 1050 && listMode != "text") {
                setListMode("text");
            }
        });
        window.addEventListener("load", ()=>{
            if (window.innerWidth < 1050 && listMode != "text") {
                setListMode("text");
            }
        });
    }, []);
    const ToggleStatusConnection = ()=>{
        hideConnectionError();
        if (!offline) {
            setOffline(true);
        } else {
            checkConnectionStatus().then((res)=>{
                if (res.msg === "Connection Established ..") {
                    setOffline(false);
                    updateToken();
                    handleUploadOfflineBills();
                } else {
                    showConnectionError();
                }
            }).catch((err)=>{
                // console.log(err)
                showConnectionError();
            });
        }
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        id: "nav",
        className: "fixed inset-x-0 top-0 z-50 w-full transition duration-200 ease-in-out border-b border-base-200 bg-base-100 text-base-content",
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "mx-auto ml-4 space-x-1 navbar max-w-none",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "flex-none",
                        children: /*#__PURE__*/ jsx_runtime_.jsx("label", {
                            className: "btn btn-square btn-ghost drawer-button md:hidden",
                            onClick: ()=>setShowSidebar(!showSidebar),
                            children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                xmlns: "http://www.w3.org/2000/svg",
                                fill: "none",
                                viewBox: "0 0 24 24",
                                className: "inline-block w-6 h-6 stroke-current",
                                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                    strokeLinecap: "round",
                                    strokeLinejoin: "round",
                                    strokeWidth: "2",
                                    d: "M4 6h16M4 12h16M4 18h16"
                                })
                            })
                        })
                    }),
                    toggleNavClass() && /*#__PURE__*/ jsx_runtime_.jsx(shared_Logo, {
                        w: 65,
                        h: 19,
                        type: logoType.Full
                    }),
                    !toggleNavClass() && /*#__PURE__*/ jsx_runtime_.jsx(shared_Logo, {
                        w: 130,
                        h: 37.5,
                        type: logoType.Full
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "flex flex-inline my-6",
                        children: router.asPath != "/tables" ? /*#__PURE__*/ (0,jsx_runtime_.jsxs)(external_react_.Fragment, {
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                    style: {
                                        fontSize: "0.8rem"
                                    },
                                    onClick: ()=>router.push("/tables"),
                                    className: "py-2 px-4 bg-gray-200 flex justify-center items-center text-gray-700 rounded-md shadow-md",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                        xmlns: "http://www.w3.org/2000/svg",
                                        version: "1.1",
                                        className: "h-6 w-6",
                                        x: "0",
                                        y: "0",
                                        viewBox: "0 0 64 64",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("g", {
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                                xmlns: "http://www.w3.org/2000/svg",
                                                d: "M53.346,6.18A170.349,170.349,0,0,0,32,5,170.349,170.349,0,0,0,10.654,6.18C2.147,7.315,1,8.748,1,10v4c0,1.252,1.147,2.685,9.654,3.82,2.842.378,6.149.672,9.746.872l2.519,6.3L9.079,57.609A1,1,0,0,0,10,59h6a1,1,0,0,0,.931-.633L28,30.27V58a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V30.268l11.069,28.1A1,1,0,0,0,48,59h6a1,1,0,0,0,.921-1.391l-13.84-32.62,2.52-6.3c3.6-.2,6.9-.494,9.745-.872C61.853,16.685,63,15.252,63,14V10C63,8.748,61.853,7.315,53.346,6.18ZM32,7c16.356,0,27.008,1.708,28.837,3C59.008,11.292,48.356,13,32,13S4.992,11.292,3.163,10C4.992,8.708,15.644,7,32,7ZM15.319,57H11.511l13.41-31.609a1.013,1.013,0,0,0,.008-.763L22.6,18.8c1.508.066,3.058.114,4.64.148l.739,5.926Zm18.8-33H29.882l-.627-5.017Q30.617,19,32,19t2.744-.018ZM30,57V26h4V57Zm9.072-32.372a1.013,1.013,0,0,0,.008.763L52.489,57H48.681L36.024,24.87l.74-5.924c1.582-.034,3.132-.082,4.64-.148ZM32,17C15.054,17,4.232,15.166,3,13.862V12.114a31.329,31.329,0,0,0,7.654,1.706A170.349,170.349,0,0,0,32,15a170.349,170.349,0,0,0,21.346-1.18A31.329,31.329,0,0,0,61,12.114v1.748C59.768,15.166,48.946,17,32,17Z",
                                                fill: "#000000",
                                                "data-original": "#000000"
                                            })
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    className: `text-gray-400 mr-2 ${tableId ? "" : "hidden"}`,
                                    style: {
                                        fontSize: "0.8rem"
                                    },
                                    children: tableId ? tableId : ""
                                })
                            ]
                        }) : null
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "flex-1"
                    }),
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "flex items-center py-4 pr-4 pl-4 md:pl-20 bg-red-100 rounded-2xl",
                        children: [
                            order.length > 0 ? /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                className: "flex items-center justify-between p-2 ml-4 bg-red-50 rounded-xl",
                                children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                        className: "cursor-pointer",
                                        onClick: ()=>{
                                            setOrder([]);
                                        },
                                        children: /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                                            src: "/images/trash.png",
                                            width: 24,
                                            height: 24,
                                            alt: "trash"
                                        })
                                    })
                                })
                            }) : /*#__PURE__*/ jsx_runtime_.jsx("span", {}),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                className: "relative ml-4 md:items-center flex",
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                                        src: "/images/paperbag.png",
                                        alt: "printer",
                                        width: 30,
                                        height: 30
                                    }),
                                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                        className: "absolute flex items-center justify-center pt-1 text-sm text-red-800 bg-white border-2 border-gray-600 rounded-full w-5 h-5",
                                        children: order.map((item)=>item.count).reduce((prev, next)=>prev + next, 0)
                                    })
                                ]
                            }),
                            havePrintersList && /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                href: "/printers",
                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                    className: " lg:inline",
                                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                        className: " md:items-center md:flex",
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                className: "hidden lg:inline",
                                                children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                                    className: "ml-2",
                                                    children: "تنظیمات"
                                                })
                                            }),
                                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                className: "items-center flex-none",
                                                title: "Printers ↗︎",
                                                children: /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                                                    src: "/images/printer.png",
                                                    alt: "printer",
                                                    width: 30,
                                                    height: 30
                                                })
                                            })
                                        ]
                                    })
                                })
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "hidden mx-8 alert alert-error mt 4",
                ref: alert,
                children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                    className: "flex-1",
                    children: [
                        /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                            xmlns: "http://www.w3.org/2000/svg",
                            fill: "none",
                            viewBox: "0 0 24 24",
                            className: "w-6 h-6 mx-2 stroke-current",
                            children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                strokeLinecap: "round",
                                strokeLinejoin: "round",
                                strokeWidth: 2,
                                d: "M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
                            })
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx("label", {
                            children: "ارتباط با سرور برقرار نمیشود"
                        })
                    ]
                })
            })
        ]
    });
};
/* harmony default export */ const components_Header = (Header);


/***/ }),

/***/ 1641:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_jsx_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9816);
/* harmony import */ var styled_jsx_style__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_jsx_style__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_toastify_dist_ReactToastify_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8819);
/* harmony import */ var react_toastify_dist_ReactToastify_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify_dist_ReactToastify_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9732);
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4403);
/* harmony import */ var _contexts_simpleContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4373);
/* harmony import */ var pages_printers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1930);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _Products__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(767);
/* harmony import */ var services_order__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(2145);
/* harmony import */ var _AcceptOrder__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(9410);
/* harmony import */ var _contexts_RefreshContext__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(2738);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([pages_printers__WEBPACK_IMPORTED_MODULE_8__]);
pages_printers__WEBPACK_IMPORTED_MODULE_8__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];














const Layout = (props)=>{
    const { children  } = props;
    const { 0: showSidebar , 1: setShowSidebar  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const { 0: activeClasses , 1: setActiveClasses  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("w-0");
    const { 0: drawerWidth , 1: setDrawerWidth  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("0");
    const { 0: listMode , 1: setListMode  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("picture");
    const { 0: showAcceptOrder , 1: setShowAcceptOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const { 0: acceptOrderData , 1: setAcceptOrderData  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({});
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_9__.useRouter)();
    const acceptOrder = async (order_id)=>{
        try {
            let res = await (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .getOnlineOrderData */ .yb)(order_id, 2);
            if (res["data"]) {
                setShowAcceptOrder(true);
                setAcceptOrderData(res["data"]["details"]);
            }
        } catch (error) {}
    };
    const { offline , loader  } = (0,_Products__WEBPACK_IMPORTED_MODULE_10__/* .useProductContext */ .$)();
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>{
        if (!offline) {
            (0,pages_printers__WEBPACK_IMPORTED_MODULE_8__.socketConnection)(localStorage.getItem("client_type") || 1, router, acceptOrder);
        }
    }, [
        offline
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(()=>{
        if (showSidebar) {
            setDrawerWidth("400px");
        } else {
            setDrawerWidth("0");
        }
    }, [
        showSidebar
    ]);
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_contexts_simpleContext__WEBPACK_IMPORTED_MODULE_7__/* .SimpleStateContext.Provider */ .f.Provider, {
        value: {
            listMode,
            setListMode
        },
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_contexts_RefreshContext__WEBPACK_IMPORTED_MODULE_13__/* .RefreshProvider */ .fg, {
            children: [
                react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((styled_jsx_style__WEBPACK_IMPORTED_MODULE_1___default()), {
                    id: "5c4f6c8892c851cf",
                    children: "@media screen and (max-width:1030px){main.jsx-5c4f6c8892c851cf{margin-left:0!important}import.jsx-5c4f6c8892c851cf{socketConnection }from './../pages/printers';import.jsx-5c4f6c8892c851cf{useRouter }from 'next/router';import.jsx-5c4f6c8892c851cf{useRouter }from 'next/router';}"
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "jsx-5c4f6c8892c851cf" + " " + "overflow-x-hidden",
                    children: [
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("main", {
                            style: {
                                marginLeft: drawerWidth
                            },
                            className: "jsx-5c4f6c8892c851cf" + " " + "h-full",
                            children: [
                                loader ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    role: "status",
                                    className: "jsx-5c4f6c8892c851cf" + " " + "loader",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "jsx-5c4f6c8892c851cf",
                                        children: [
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
                                                viewBox: "0 0 100 101",
                                                xmlns: "http://www.w3.org/2000/svg",
                                                className: "jsx-5c4f6c8892c851cf" + " " + "inline mr-2 w-10 h-10 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600",
                                                children: [
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                                        d: "M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z",
                                                        fill: "currentColor",
                                                        className: "jsx-5c4f6c8892c851cf"
                                                    }),
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                                        d: "M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z",
                                                        fill: "currentFill",
                                                        className: "jsx-5c4f6c8892c851cf"
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                className: "jsx-5c4f6c8892c851cf" + " " + "sr-only",
                                                children: "Loading..."
                                            })
                                        ]
                                    })
                                }) : null,
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Header__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                                    showSidebar: showSidebar,
                                    setShowSidebar: setShowSidebar
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "jsx-5c4f6c8892c851cf" + " " + "px-8",
                                    children: children
                                })
                            ]
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AcceptOrder__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                            show: showAcceptOrder,
                            setShow: setShowAcceptOrder,
                            data: acceptOrderData,
                            setData: setAcceptOrderData
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Sidebar__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                            showSidebar: showSidebar,
                            setShowSidebar: setShowSidebar,
                            drawerWidth: drawerWidth,
                            setDrawerWidth: setDrawerWidth,
                            activeClasses: activeClasses
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_toastify__WEBPACK_IMPORTED_MODULE_3__.ToastContainer, {})
                    ]
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Layout);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4403:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ components_Sidebar)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "clsx"
var external_clsx_ = __webpack_require__(8103);
var external_clsx_default = /*#__PURE__*/__webpack_require__.n(external_clsx_);
// EXTERNAL MODULE: ./helpers/check-items.ts
var check_items = __webpack_require__(5422);
// EXTERNAL MODULE: ./helpers/format.ts
var format = __webpack_require__(890);
// EXTERNAL MODULE: ./helpers/offline.ts
var helpers_offline = __webpack_require__(9977);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(1853);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: external "react-toastify"
var external_react_toastify_ = __webpack_require__(1187);
// EXTERNAL MODULE: ./services/order.ts
var services_order = __webpack_require__(2145);
// EXTERNAL MODULE: ./services/persian.js
var persian = __webpack_require__(4272);
// EXTERNAL MODULE: ./services/table.ts
var table = __webpack_require__(3954);
// EXTERNAL MODULE: ./components/CustomerSuggest.tsx
var CustomerSuggest = __webpack_require__(5826);
// EXTERNAL MODULE: ./components/Products.ts
var Products = __webpack_require__(767);
// EXTERNAL MODULE: ./components/shared/image-component.tsx
var image_component = __webpack_require__(7930);
// EXTERNAL MODULE: external "antd"
var external_antd_ = __webpack_require__(5725);
;// CONCATENATED MODULE: ./components/AcceptPointModal.tsx





function AcceptPointModal({ show , setShow , setUserPoint , customer , userPoint  }) {
    const { 0: code , 1: setCode  } = (0,external_react_.useState)("");
    const { token  } = (0,Products/* useProductContext */.$)();
    const close = ()=>{
        setShow(false);
        setCode("");
    };
    const handleSms = async ()=>{
        try {
            let res = await (0,table/* request2 */.qC)(`/point-sms?user=${customer["name"]}`, "get");
            if (res["message"]) (0,table/* sendAlert */.O1)(res["success"], res["message"]);
        } catch (error) {}
    };
    const handleAccept = async ()=>{
        //console.log(userPoint);
        try {
            let _token = token;
            if (token) {
                _token = token.split("%")[1];
            }
            if (!code) return (0,table/* sendAlert */.O1)(false, "کد تایید را وارد کنید");
            let res = await (0,table/* request2 */.qC)(`/accept-point?user=${customer["name"]}&code=${code}&token=${_token}`, "get");
            if (res["message"]) (0,table/* sendAlert */.O1)(res["success"], res["message"]);
            if (res["success"]) {
                setUserPoint(userPoint);
                close();
            }
        } catch (error) {}
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)(external_antd_.Modal, {
        title: "تایید امتیاز",
        open: show,
        onCancel: close,
        footer: "",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Input, {
                placeholder: "کد تایید",
                className: "mt-3",
                onChange: (e)=>setCode(e.target.value),
                value: code
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "flex gap-2 mt-3",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Button, {
                        type: "default",
                        className: "w-full",
                        onClick: handleSms,
                        children: "ارسال اس ام اس"
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Button, {
                        type: "primary",
                        className: "w-full",
                        onClick: handleAccept,
                        children: "تایید"
                    })
                ]
            })
        ]
    });
}

;// CONCATENATED MODULE: ./components/PozModal.tsx




const PozModal = ({ open , setOpen , data , setData  })=>{
    const router = (0,router_.useRouter)();
    const close = ()=>{
        setOpen(false);
        setData({});
    };
    const onFinish = async (values)=>{};
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Modal, {
            title: `پرداخت مبلغ ${(0,format/* numberFormat */.Y4)(data["total"] * 10)} ریال`,
            centered: true,
            open: open,
            onCancel: close,
            footer: "",
            children: data["offline_id"] ? /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                children: /*#__PURE__*/ jsx_runtime_.jsx(external_antd_.Button, {
                    type: "primary",
                    className: " poz_cart w-full",
                    "data-price": data["total"] * 10,
                    "data-id": data.offline_id,
                    onClick: close,
                    children: "پرداخت با دستگاه پوز"
                })
            }) : ""
        })
    });
};
/* harmony default export */ const components_PozModal = (PozModal);

;// CONCATENATED MODULE: ./components/Sidebar.tsx

















const Sidebar = ({ showSidebar , setShowSidebar , activeClasses , drawerWidth , setDrawerWidth ,  })=>{
    const { order , setOrder , offline , setOfflineBills , token , detailEditOrder , setDetailEditOrder , tableId , setTableId , repeatPrinting , setRepeatPrinting , loader , setLoader , warehouse , tax ,  } = (0,Products/* useProductContext */.$)();
    // console.log(order);
    const { 0: customer , 1: setCustomer  } = (0,external_react_.useState)({
        name: "",
        id: -1
    });
    const { 0: freePoint , 1: setFreePoint  } = (0,external_react_.useState)(0);
    const { 0: poz , 1: setPoz  } = (0,external_react_.useState)(false);
    const product = {
        name: "esm",
        price: 30000,
        image: "url",
        options: [
            {
                name: "option 1",
                price: 2000,
                additional_property: "folan"
            },
            {
                name: "option 2",
                price: 7500,
                additional_property: "bisar"
            }, 
        ]
    };
    const inputTableList = (0,external_react_.useRef)(null);
    const { 0: isError , 1: setIsError  } = (0,external_react_.useState)(false);
    const { 0: tableList , 1: setTableList  } = (0,external_react_.useState)({
        "مجدد لاگین کنید": 0
    });
    const { 0: note , 1: setNote  } = (0,external_react_.useState)("");
    const { 0: orderId , 1: setOrderId  } = (0,external_react_.useState)(0);
    const { 0: customerNote , 1: setCustomerNote  } = (0,external_react_.useState)("");
    const { 0: orderTypeDefault , 1: setOrderTypeDefault  } = (0,external_react_.useState)(null);
    const { 0: printerBehaveDefault , 1: setPrinterBehaveDefault  } = (0,external_react_.useState)(null);
    const { 0: paymentTypeDefault , 1: setPaymentTypeDefault  } = (0,external_react_.useState)(null);
    const { 0: usePoint , 1: setUsePoint  } = (0,external_react_.useState)(false);
    const { 0: userPoint , 1: setUserPoint  } = (0,external_react_.useState)(0);
    const { 0: userPoint2 , 1: setUserPoint2  } = (0,external_react_.useState)(0);
    const { 0: userDiscount , 1: setUserDiscount  } = (0,external_react_.useState)(0);
    const { 0: numPeople , 1: setNumPeople  } = (0,external_react_.useState)("");
    const { 0: useDiscount , 1: setUseDiscount  } = (0,external_react_.useState)({
        text: "انتخاب تخفیف",
        id: 0
    });
    const { 0: discount , 1: setDiscount  } = (0,external_react_.useState)("");
    const { 0: totalPrice , 1: setTotalPrice  } = (0,external_react_.useState)("");
    const { 0: totalPrice2 , 1: setTotalPrice2  } = (0,external_react_.useState)(0);
    const { 0: service , 1: setService  } = (0,external_react_.useState)("");
    const { 0: service2 , 1: setService2  } = (0,external_react_.useState)("");
    const { 0: tip , 1: setTip  } = (0,external_react_.useState)("");
    const { 0: tip2 , 1: setTip2  } = (0,external_react_.useState)("");
    const { 0: payment_card , 1: setPayment_card  } = (0,external_react_.useState)("");
    const { 0: payment_pos , 1: setPayment_pos  } = (0,external_react_.useState)("");
    const { 0: payment_cash , 1: setPayment_cash  } = (0,external_react_.useState)("");
    const { 0: seconds , 1: setSeconds  } = (0,external_react_.useState)(0);
    const { 0: showModal , 1: setShowModal  } = (0,external_react_.useState)(false);
    const { 0: pozModal , 1: setPozModal  } = (0,external_react_.useState)(false);
    const { 0: pozData , 1: setPozData  } = (0,external_react_.useState)({});
    const { 0: isUpdate , 1: setIsUpdate  } = (0,external_react_.useState)(false);
    const router = (0,router_.useRouter)();
    (0,external_react_.useEffect)(()=>{
        console.log(customer);
    }, [
        customer
    ]);
    (0,external_react_.useEffect)(()=>{
        getTables();
        const localOrders = JSON.parse(localStorage.getItem("localOrders") || "[]");
        const myToken = localStorage.getItem("token");
        localOrders.forEach((item, i)=>{
            if (item["date"]) {
                setTimeout(()=>{
                    (0,helpers_offline/* uploadOfflineOrders */.E7)(myToken, 1);
                }, Date.now() - item["date"] > 5400000 ? 90000 * (i + 1) : 5400000 - (Date.now() - item["date"]) + 90000 * (i + 1));
            }
        });
        let queryList = localStorage.getItem("queryList");
        if (queryList) {
            queryList = JSON.parse(queryList);
            queryList.forEach((item, i)=>{
                setTimeout(()=>{
                    queryList = localStorage.getItem("queryList");
                    queryList = JSON.parse(queryList || "[]");
                    if (item.type == "setStatus") {
                        (0,table/* changeStatus */.wv)(item.order_id, item.st_id);
                        queryList = queryList.filter((it)=>it.order_id != item.order_id && it.st_id != item.st_id);
                    } else if (item.type == "changeTable") {
                        (0,table/* changeTable */.m8)(item.order_id, item.table_id);
                        queryList = queryList.filter((it)=>it.order_id != item.order_id && it.table_id != item.table_id);
                    }
                    localStorage.setItem("queryList", JSON.stringify(queryList));
                }, Date.now() - item["date"] > 5400000 ? 90000 * (i + 1) : 5400000 - (Date.now() - item["date"]) + 90000 * (i + 1));
            });
        }
    }, []);
    let { 0: ListDiscounts , 1: setListDiscounts  } = (0,external_react_.useState)([
        {
            text: "انتخاب تخفیف",
            id: 0
        }, 
    ]);
    (0,external_react_.useEffect)(()=>{
        if (Object.keys(detailEditOrder).length) {
            setIsUpdate(true);
            // console.log(detailEditOrder)
            if (detailEditOrder["detail"]["userDiscount"]) setUserDiscount(detailEditOrder["detail"]["userDiscount"]);
            setNote(detailEditOrder["detail"].note);
            setOrderId(detailEditOrder["detail"].id);
            setTableId(detailEditOrder["detail"].table_id);
            setUsePoint(detailEditOrder["detail"].use_point);
            setUserPoint(detailEditOrder["detail"].user_point);
            setService(detailEditOrder["detail"].service);
            setService2(detailEditOrder["detail"].service);
            setPayment_cash(detailEditOrder["detail"].payment_cash);
            setPayment_card(detailEditOrder["detail"].payment_card);
            setPayment_pos(detailEditOrder["detail"].payment_pos);
            setTip(detailEditOrder["detail"].tip);
            setTip2(detailEditOrder["detail"].tip);
            if (detailEditOrder["detail"].numPeople) setNumPeople(detailEditOrder["detail"].numPeople);
            // if (
            //   detailEditOrder["detail"].user_id != -1 &&
            //   detailEditOrder["detail"].user_name
            // ) {
            setCustomer({
                name: detailEditOrder["detail"].user_name,
                id: detailEditOrder["detail"].user_id
            });
            // }
            if (detailEditOrder["detail"].discount_id > 0) {
                let discount_id = detailEditOrder["detail"].discount_id;
                let d = JSON.parse(localStorage.getItem("discount_list_app"))[discount_id].name;
                setUseDiscount({
                    text: d,
                    id: discount_id
                });
            } else {
                setUseDiscount({
                    text: "انتخاب تخفیف",
                    id: 0
                });
            }
        }
    }, [
        detailEditOrder
    ]);
    (0,external_react_.useEffect)(()=>{
        calculate_discount();
    }, [
        useDiscount
    ]);
    (0,external_react_.useEffect)(()=>{
        if (service) {
            let totalAmount = (0,format/* cartTotalPrice2 */.a0)(order);
            totalAmount = totalAmount + parseFloat(service);
            if (discount) totalAmount -= parseInt(discount);
            if (tip) totalAmount += parseFloat(tip);
            setTotalPrice2(totalAmount);
            setTotalPrice((0,format/* formatPrice */.T4)(totalAmount));
        }
        calculate_discount();
    }, [
        service
    ]);
    (0,external_react_.useEffect)(()=>{
        if (tip) {
            let totalAmount = (0,format/* cartTotalPrice2 */.a0)(order);
            totalAmount = totalAmount + parseFloat(tip);
            if (discount) totalAmount -= parseInt(discount);
            if (service) totalAmount += parseFloat(service);
            setTotalPrice((0,format/* formatPrice */.T4)(totalAmount));
            setTotalPrice2(totalAmount);
        }
        calculate_discount();
    }, [
        tip
    ]);
    (0,external_react_.useEffect)(()=>{
        calculate_discount();
    }, [
        useDiscount
    ]);
    const calculate_discount = ()=>{
        let disc = 0;
        if (useDiscount["id"] > 0) {
            setUserDiscount(0);
            let totalAmount = (0,format/* cartTotalPrice2 */.a0)(order);
            if (service) totalAmount += parseFloat(service);
            let d = JSON.parse(localStorage.getItem("discount_list_app"))[useDiscount["id"]].discount;
            d = Math.round(totalAmount * (d / 100));
            totalAmount = totalAmount - d;
            if (tip) totalAmount += parseFloat(tip);
            setTotalPrice((0,format/* formatPrice */.T4)(totalAmount));
            setTotalPrice2(totalAmount);
            setDiscount((0,format/* formatPrice */.T4)(d));
            disc = d;
        } else if (userDiscount > 0) {
            let totalAmount1 = (0,format/* cartTotalPrice2 */.a0)(order);
            let d1 = userDiscount;
            d1 = Math.round(totalAmount1 * (d1 / 100));
            totalAmount1 = totalAmount1 - d1;
            setTotalPrice((0,format/* formatPrice */.T4)(totalAmount1));
            setTotalPrice2(totalAmount1);
            setDiscount((0,format/* formatPrice */.T4)(d1));
            disc = d1;
        } else {
            // setTotalPrice("");
            setDiscount("");
        }
        if (!service && !discount && !tip && !disc && !(userDiscount > 0 && useDiscount["id"] > 0)) {
            // console.log("test");
            setTotalPrice("");
            setTotalPrice2(0);
        }
    };
    (0,external_react_.useEffect)(()=>{
        calculate_discount();
    }, [
        userDiscount
    ]);
    (0,external_react_.useEffect)(()=>{
        if (orderTypeDefault === null) {
            setOrderTypeDefault(localStorage.getItem("order_type_default") ? localStorage.getItem("order_type_default") : "EXP");
        }
        if (printerBehaveDefault === null) {
            setPrinterBehaveDefault(localStorage.getItem("default_print_type") ? localStorage.getItem("default_print_type") : "1");
            localStorage.setItem("printer_behave_default", printerBehaves[+localStorage.getItem("default_print_type") - 1]);
        }
        if (paymentTypeDefault === null) {
            setPaymentTypeDefault(localStorage.getItem("paymentType") ? localStorage.getItem("paymentType") : "پوز");
        }
        if (tableList["مجدد لاگین کنید"] == 0 && localStorage.getItem("table_list")) {
            setTableList(JSON.parse(localStorage.getItem("table_list") || "[]") || {
                "مجدد لاگین کنید": 0
            });
        }
        if (localStorage.getItem("discount_list") && ListDiscounts.length == 1) {
            const dl = JSON.parse(localStorage.getItem("discount_list"));
            if (dl.length) setListDiscounts([
                ...ListDiscounts,
                ...dl
            ]);
        }
    });
    let // console.log(printerBehaveDefault);
    errorMessages;
    (function(errorMessages) {
        errorMessages["Customer"] = "لطفا ابتدا مشتری را ثبت نمایید";
        errorMessages[// TableId = 'لطفا ابتدا شماره میز را ثبت نمایید',
        "NoServer"] = "ارتباط با سرور داخلی برقرار نیست";
    })(errorMessages || (errorMessages = {}));
    const { 0: errorMessage , 1: setErrorMessage  } = (0,external_react_.useState)(errorMessages.NoServer);
    const { 0: noCustomer , 1: setNoCustomer  } = (0,external_react_.useState)(true);
    const handleSubmitOrder = (e)=>{
        if (tableId) {
            (0,services_order/* findOrder */.a_)({
                status: 6,
                table_id: tableId
            }, 1).then((order)=>{
                if (order["order"]) {
                    if (orderId && order["order"].offline_id == orderId) submitOrder(false);
                    else submitOrder(true);
                } else submitOrder(false);
            });
        } else {
            submitOrder(false);
        }
    };
    const submitOrder = (check)=>{
        if (check) {
            external_react_toastify_.toast.error("میز وارد شده پر میباشد", {
                position: "bottom-right",
                style: {
                    direction: "rtl",
                    fontFamily: "IRANSansX"
                },
                theme: "colored"
            });
            return;
        }
        let button = document.getElementById("submitOrder");
        button.disabled = true;
        if (payment_card || payment_pos || payment_cash) {
            let sum = (payment_card ? parseInt(payment_card.replace(/,/g, "")) : 0) + (payment_pos ? parseInt(payment_pos.replace(/,/g, "")) : 0) + (payment_cash ? parseInt(payment_cash.replace(/,/g, "")) : 0);
            let totalAmount = (0,format/* cartTotalPrice2 */.a0)(order);
            if (service) totalAmount += parseFloat(service);
            if (discount) totalAmount -= parseInt(discount);
            if (tip) totalAmount += parseFloat(tip);
            if (tax) totalAmount += (0,format/* cartTotalTax */.HJ)(totalPrice2 ? totalPrice2 : (0,format/* cartTotalPrice2 */.a0)(order), tax, tip, order);
            totalAmount = (0,format/* roundFinalPrice */.gz)(totalAmount);
            if (sum != totalAmount) {
                external_react_toastify_.toast.error("مبلغ های پرداختی وارد شده با مبلغ کل برابر نمیباشند", {
                    position: "bottom-right",
                    style: {
                        direction: "rtl",
                        fontFamily: "IRANSansX"
                    },
                    theme: "colored"
                });
                button.disabled = false;
                return;
            }
        }
        setIsError(false);
        setErrorMessage(errorMessages.NoServer);
        // if offline only save the order
        button.classList.add("loading");
        // if (offline) {
        const totalAmount1 = (0,format/* cartTotalPrice2 */.a0)(order);
        if (totalAmount1 <= 0) {
            button.disabled = false;
            button.classList.remove("loading");
            return external_react_toastify_.toast.error("مبلغ کل سفارش نمیتواند صفر باشد.", {
                position: "bottom-right",
                style: {
                    direction: "rtl",
                    fontFamily: "IRANSansX"
                },
                theme: "colored"
            });
        }
        (0,helpers_offline/* submitOrderLocally */.M3)(order, customer, totalAmount1, paymentTypeDefault, customerNote, noCustomer, orderId, numPeople, tableId, detailEditOrder, setDetailEditOrder, useDiscount, note, userPoint, usePoint, service, payment_card ? payment_card.replace(/,/g, "") : "", payment_pos ? payment_pos.replace(/,/g, "") : "", payment_cash ? payment_cash.replace(/,/g, "") : "", null, null, null, null, tip, userDiscount, warehouse, poz).then((res)=>{
            // console.log('res', res)
            setLoader(true);
            setOfflineBills(res);
            setCustomer({
                name: "",
                id: -1
            });
            setOrder([]);
            setTableId("");
            setNote("");
            setUseDiscount({
                text: "انتخاب تخفیف",
                id: 0
            });
            setOrderTypeDefault(localStorage.getItem("order_type_default") ? localStorage.getItem("order_type_default") : "1");
            setPaymentTypeDefault(localStorage.getItem("paymentType") ? localStorage.getItem("paymentType") : "پوز");
            setPrinterBehaveDefault(localStorage.getItem("default_print_type"));
            localStorage.setItem("printer_behave_default", printerBehaves[+localStorage.getItem("default_print_type") - 1]);
            setIsError(false);
            setCustomerNote("");
            setNoCustomer(true);
            setNote("");
            setOrderId(0);
            setDetailEditOrder({});
            setNumPeople("");
            setShowSidebar(false);
            setService("");
            setService2("");
            setTip("");
            setTip2("");
            setPayment_card("");
            setPayment_pos("");
            setPayment_cash("");
            setUserDiscount(0);
            setPoz(false);
            button.classList.remove("loading");
            setTimeout(()=>{
                router.push("/tables");
                setLoader(false);
            }, 500);
            if (res != 1 && res["status"] == -2) {
                setPozModal(true);
                setPozData(res);
            }
            setUserPoint(0);
            setUserPoint2(0);
            setUsePoint(false);
            setIsUpdate(false);
        });
    };
    const getTables = ()=>{
        if (offline) {
            let tables = localStorage.getItem("tables") || "[]";
            tables = JSON.parse(tables);
            let listTables = [];
            Object.keys(tables).forEach((salon)=>{
                Object.keys(tables[salon]).forEach((table)=>{
                    if (!tables[salon][table].length) {
                        listTables.push(table);
                    }
                });
            });
            // listTables = Object.assign({}, listTables);
            const listTablesOB = {};
            listTables.forEach((table)=>{
                listTablesOB[table] = 0;
            });
            localStorage.setItem("table_list", JSON.stringify(listTablesOB));
            setTableList(listTablesOB);
            return;
        }
        (0,services_order/* getTableList */.vs)().then((table_list)=>{
            localStorage.setItem("table_list", JSON.stringify(table_list) || "{}");
            setTableList(JSON.parse(localStorage.getItem("table_list") || "{'مجدد لاگین کنید': 0}"));
        }).catch(()=>{
            setIsError(true);
        });
    };
    (0,external_react_.useEffect)(()=>{
        if (router.pathname !== "/cart" && order.length >= 1 && window.innerWidth > 1130) {
            setShowSidebar(true);
            document.querySelector(".toggle-wrap").classList.add("active");
            document.querySelector("aside").classList.add("active");
        }
        setFreePoint(localStorage.getItem("point_free") ? parseInt(localStorage.getItem("point_free")) : 60);
    }, [
        order,
        router
    ]);
    (0,external_react_.useEffect)(()=>{
        // console.log(order);
        if (order.length == 0) {
            setNote("");
            setOrderId(0);
        // if(!detailEditOrder['items']) {
        //   setDetailEditOrder({});
        //   setTableId("");
        // }
        }
        calculate_discount();
    }, [
        order
    ]);
    const productHasOptions = (product)=>{
        return product.options.length > 0;
    };
    const printerBehaves = [
        "پرینت مشتری و باریستا",
        "پرینت باریستا",
        "بدون پرینت",
        "پرینت مشتری", 
    ];
    const keyPrinterBehaves = {
        "پرینت مشتری": 4,
        "بدون پرینت": 3,
        "پرینت باریستا": 2,
        "پرینت مشتری و باریستا": 1
    };
    const keysPrinter = {
        3: "بدون پرینت",
        2: "پرینت باریستا",
        1: "پرینت مشتری و باریستا"
    };
    const paymentTypes = [
        "نقدی",
        "پوز",
        "کارت به کارت"
    ];
    const orderTypes = [
        "EXP",
        "Delivery",
        "Salon"
    ];
    const keyOrderTypes = {
        EXP: 1,
        Delivery: 2,
        Salon: 3
    };
    const interval = ()=>{
        const interval_id = setInterval(()=>{
            setSeconds(seconds + 1);
            clearInterval(interval_id);
        }, 100);
    };
    (0,external_react_.useEffect)(()=>{
        if (totalPrice) {
            let totalAmount = (0,format/* cartTotalPrice2 */.a0)(order);
            if (service) totalAmount += parseFloat(service);
            // console.log(totalAmount)
            if (discount) totalAmount -= parseInt(discount);
            if (tip) totalAmount += parseFloat(tip);
            setTotalPrice2(totalAmount);
            interval();
        }
    }, [
        order
    ]);
    const acceptPoint = ()=>{
        if (userPoint > 0) return;
        setShowModal(true);
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("aside", {
        className: `${activeClasses} flex flex-col box-border fixed top-0 left-0 bottom-0 z-50 h-full shadow-md bg-yellow-50 opacity-98 rounded-r-2xl ${showSidebar ? "active" : ""}`,
        style: {
            width: `${drawerWidth}`,
            maxWidth: "calc(100% - 65px)"
        },
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: external_clsx_default()("toggle-wrap absolute", "-right-24 top-6") + ` hidden md:block z-50 ${showSidebar ? "active" : ""}`,
                onClick: (e)=>{
                    setShowSidebar(!showSidebar);
                },
                children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                    className: "toggle-bar"
                })
            }),
            order.length === 0 && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: `flex flex-col items-center justify-center h-full text-2xl text-gray-800 rounded-3xl overflow-hidden ${drawerWidth === "0" ? "pr-8" : ""}`,
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        children: /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                            src: "/images/empty.png",
                            alt: "empty basket",
                            layout: "fixed",
                            width: 100,
                            height: 100
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("p", {
                        className: "whitespace-nowrap",
                        children: "آماده سفارش بعدی"
                    })
                ]
            }),
            order.length > 0 && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: `static h-full ${order.length ? "grid grid-cols-1" : ""}`,
                style: {
                    gridTemplateRows: order.length ? "min-content auto min-content" : "none"
                },
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: `w-full ${drawerWidth === "0" ? "pr-20" : ""}`,
                        children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                            className: "flex items-center justify-center p-4 bg-yellow-100 rounded-xl",
                            children: /*#__PURE__*/ jsx_runtime_.jsx(CustomerSuggest/* default */.Z, {
                                customer: customer,
                                setCustomer: setCustomer,
                                setIsError: setIsError,
                                setUserPoint: setUserPoint2,
                                setUserDiscount: setUserDiscount
                            })
                        })
                    }),
                    isError && /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "mx-4 mb-2 alert alert-error mt-20 overflow-y-hidden",
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex items-center",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                    xmlns: "http://www.w3.org/2000/svg",
                                    fill: "none",
                                    viewBox: "0 0 24 24",
                                    className: "w-6 h-6 mx-2 stroke-current",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                        strokeLinecap: "round",
                                        strokeLinejoin: "round",
                                        strokeWidth: 2,
                                        d: "M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("label", {
                                    children: errorMessage
                                }),
                                errorMessage == errorMessages.Customer ? /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                    className: "btn btn-error",
                                    onClick: ()=>{
                                        setNoCustomer(true);
                                        setIsError(false);
                                    },
                                    children: "بدون مشتری"
                                }) : null
                            ]
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: `h-full overflow-y-auto sidebar_response`,
                        children: order.map((orderItem)=>{
                            return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                tabIndex: 0,
                                id: String(orderItem.product.id),
                                className: `flex flex-col collapse ${orderItem.note ? "collapse-open" : "collapse-close"}`,
                                children: [
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                        className: "flex justify-around py-0 pl-2 pr-4 text-sm border-b-2 collapse-title",
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                className: `flex items-center w-1/6 ${localStorage.getItem("access") && !JSON.parse(localStorage.getItem("access")).down_edit ? orderId != 0 && detailEditOrder["items"][orderItem.product.id + "_" + (orderItem.product.options.length ? orderItem.product.options.map((i)=>i.id).join(",") : "")] != undefined ? "opacity-50" : "cursor-pointer" : ""}`,
                                                onClick: ()=>{
                                                    if (localStorage.getItem("access") && !JSON.parse(localStorage.getItem("access")).down_edit) {
                                                        if (orderId != 0 && detailEditOrder["items"][orderItem.product.id + "_" + (orderItem.product.options.length ? orderItem.product.options.map((i)=>i.id).join(",") : "")] != undefined) return;
                                                    }
                                                    setOrder([
                                                        ...(0,check_items/* removeItemsFromCart */.Sg)(orderItem.product.unique, order), 
                                                    ]);
                                                },
                                                children: /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                                                    src: "/images/cancel.png",
                                                    width: 20,
                                                    height: 20,
                                                    alt: "remove"
                                                })
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "w-full align-middle cursor-pointer",
                                                onClick: ()=>{
                                                    const el = document.getElementById(String(orderItem.product.id));
                                                    if (el.classList.contains("collapse-close")) {
                                                        el.classList.remove("collapse-close");
                                                        el.classList.add("collapse-open");
                                                    } else {
                                                        el.classList.remove("collapse-open");
                                                        el.classList.add("collapse-close");
                                                    }
                                                },
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                        className: "py-4",
                                                        children: orderItem.product.baseName
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                        children: orderItem.product.options.map((productOption)=>{
                                                            return /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                                                className: "bg-gray-200 text-xs p-2 text-gray-800 rounded-lg mx-1 mt-2",
                                                                style: {
                                                                    wordBreak: "break-all"
                                                                },
                                                                children: productOption.name
                                                            }, orderItem.product.unique + productOption.id);
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "flex items-center justify-center w-2/6",
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                                        className: `${localStorage.getItem("access") && !JSON.parse(localStorage.getItem("access")).down_edit ? orderId != 0 && !(orderItem.count > (detailEditOrder["items"][orderItem.product.id + "_" + (orderItem.product.options.length ? orderItem.product.options.map((i)=>i.id).join(",") : "")] == undefined ? 0 : detailEditOrder["items"][orderItem.product.id + "_" + (orderItem.product.options.length ? orderItem.product.options.map((i)=>i.id).join(",") : "")]["qty"])) ? "opacity-50" : "cursor-pointer" : ""}`,
                                                        onClick: ()=>{
                                                            if (localStorage.getItem("access") && !JSON.parse(localStorage.getItem("access")).down_edit) {
                                                                if (orderId != 0 && !(orderItem.count > (detailEditOrder["items"][orderItem.product.id + "_" + (orderItem.product.options.length ? orderItem.product.options.map((i)=>i.id).join(",") : "")] == undefined ? 0 : detailEditOrder["items"][orderItem.product.id + "_" + (orderItem.product.options.length ? orderItem.product.options.map((i)=>i.id).join(",") : "")]["qty"]))) return;
                                                            }
                                                            setOrder([
                                                                ...(0,check_items/* removeItemFromCart */.Cn)(orderItem.product.unique, order), 
                                                            ]);
                                                        },
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                                                            src: "/images/minus.png",
                                                            width: 20,
                                                            height: 20,
                                                            alt: "minus"
                                                        })
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                                        className: "px-2 pb-1 text-green-00",
                                                        children: orderItem.count
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                                        className: "cursor-pointer",
                                                        onClick: ()=>{
                                                            setOrder([
                                                                ...(0,check_items/* addItemToCart */.dm)(orderItem.product.unique, order), 
                                                            ]);
                                                        },
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx(image_component/* default */.Z, {
                                                            src: "/images/plus.png",
                                                            width: 20,
                                                            height: 20,
                                                            alt: "minus"
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                className: "flex items-center justify-center w-1/6",
                                                children: orderItem.product.price ? orderItem.product.price / 1000 : orderItem.product.price
                                            }),
                                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                className: "flex items-center justify-center w-1/6",
                                                children: orderItem.count * orderItem.product.price / 1000
                                            })
                                        ]
                                    }),
                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                        className: "collapse-content",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("textarea", {
                                            placeholder: "توضیحات",
                                            value: orderItem.note,
                                            onChange: (e)=>{
                                                setOrder([
                                                    ...(0,check_items/* updateOrderNote */.V)(orderItem.product.unique, order, e.currentTarget.value), 
                                                ]);
                                            },
                                            className: "w-full h-24 textarea"
                                        })
                                    })
                                ]
                            }, orderItem.product.unique);
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        style: {
                            left: "-16px"
                        },
                        className: "w-full",
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex flex-col p-4 bg-red-100 rounded-2xl",
                            children: [
                                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                    className: "flex items-center justify-between gap-2",
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                                className: `btn text-sm btn-sm w-full border-0 ${usePoint ? "btn-success" : ""}`,
                                                onClick: ()=>setUsePoint(!usePoint),
                                                children: "استفاده از امتیاز"
                                            })
                                        }),
                                        !isUpdate ? /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                                className: `btn text-sm btn-sm w-full border-0 ${poz ? "btn-success" : ""}`,
                                                onClick: ()=>setPoz(!poz),
                                                children: "پرداخت با پوز"
                                            })
                                        }) : "",
                                        usePoint && userPoint2 > freePoint && !orderId ? /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                                className: `btn text-sm btn-sm w-full border-0 ${userPoint > 0 ? "btn-success" : ""}`,
                                                onClick: acceptPoint,
                                                children: "تایید امتیاز"
                                            })
                                        }) : "",
                                        localStorage.getItem("access") && JSON.parse(localStorage.getItem("access")).discount ? /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "w-full my-2 dropdown dropdown-top dropdown-end",
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                        tabIndex: 0,
                                                        className: "w-full btn text-sm btn-sm",
                                                        children: useDiscount.text
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("ul", {
                                                        tabIndex: 0,
                                                        className: "w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box overflow-y-auto",
                                                        style: {
                                                            maxHeight: "60vh"
                                                        },
                                                        children: ListDiscounts && ListDiscounts.map(({ text , id  })=>/*#__PURE__*/ jsx_runtime_.jsx("li", {
                                                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                                    onClick: ()=>{
                                                                        setUseDiscount({
                                                                            text,
                                                                            id
                                                                        });
                                                                        inputTableList.current.focus();
                                                                        inputTableList.current.blur();
                                                                    },
                                                                    children: text
                                                                })
                                                            }, text))
                                                    })
                                                ]
                                            })
                                        }) : null
                                    ]
                                }),
                                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                    className: "flex items-center justify-between gap-2",
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "w-full my-2 dropdown dropdown-top dropdown-end",
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                        tabIndex: 0,
                                                        className: "w-full btn text-sm btn-sm",
                                                        children: orderTypes[parseInt(orderTypeDefault) - 1]
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("ul", {
                                                        tabIndex: 0,
                                                        className: "w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box",
                                                        children: orderTypes && orderTypes.map((orderType)=>/*#__PURE__*/ jsx_runtime_.jsx("li", {
                                                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                                    onClick: ()=>{
                                                                        setOrderTypeDefault(keyOrderTypes[orderType]);
                                                                        inputTableList.current.focus();
                                                                        inputTableList.current.blur();
                                                                    },
                                                                    children: orderType
                                                                })
                                                            }, orderType))
                                                    })
                                                ]
                                            })
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "w-full my-2 dropdown dropdown-top dropdown-end",
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                        tabIndex: 0,
                                                        className: "w-full btn text-sm btn-sm",
                                                        children: paymentTypeDefault != null ? paymentTypeDefault : "پوز"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("ul", {
                                                        tabIndex: 0,
                                                        className: "w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box",
                                                        children: paymentTypes && paymentTypes.map((paymentType)=>/*#__PURE__*/ jsx_runtime_.jsx("li", {
                                                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                                    onClick: ()=>{
                                                                        setPaymentTypeDefault(paymentType);
                                                                        localStorage.setItem("paymentType", paymentType);
                                                                        inputTableList.current.focus();
                                                                        inputTableList.current.blur();
                                                                    },
                                                                    children: paymentType
                                                                })
                                                            }, paymentType))
                                                    })
                                                ]
                                            })
                                        })
                                    ]
                                }),
                                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                    className: "flex items-center justify-between mb-2 gap-2",
                                    children: [
                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                            className: "w-full",
                                            children: [
                                                tax === "1" ? /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                                                    children: [
                                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                            className: "flex text-sm",
                                                            children: [
                                                                /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                    children: "جمع ایتم ها: "
                                                                }),
                                                                /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                    className: "mr-2",
                                                                    children: (0,format/* cartTotalPrice */.Kf)(order)
                                                                })
                                                            ]
                                                        }),
                                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                            className: "flex text-sm",
                                                            children: [
                                                                /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                    children: "VAT: "
                                                                }),
                                                                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("p", {
                                                                    className: "mr-2",
                                                                    children: [
                                                                        (0,persian/* numberFormat */.Y4)((0,format/* cartTotalTax */.HJ)(totalPrice2 ? totalPrice2 : (0,format/* cartTotalPrice2 */.a0)(order), tax, tip, order) * 10),
                                                                        " ",
                                                                        "ریال"
                                                                    ]
                                                                })
                                                            ]
                                                        })
                                                    ]
                                                }) : "",
                                                !totalPrice2 ? /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                    className: "flex text-sm",
                                                    children: [
                                                        /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                            children: "جمع قیمت: "
                                                        }),
                                                        /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                            className: "mr-2",
                                                            children: (0,format/* cartTotalPrice */.Kf)(order, totalPrice ? "0" : tax)
                                                        })
                                                    ]
                                                }) : "",
                                                discount ? /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                                                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                        className: "flex text-sm",
                                                        children: [
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                children: "تخفیف: "
                                                            }),
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                className: "mr-2",
                                                                children: discount
                                                            })
                                                        ]
                                                    })
                                                }) : null,
                                                service ? /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                                                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                        className: "flex text-sm",
                                                        children: [
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                children: "سرویس: "
                                                            }),
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                className: "mr-2",
                                                                children: (0,format/* formatPrice */.T4)(service)
                                                            })
                                                        ]
                                                    })
                                                }) : null,
                                                tip ? /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                                                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                        className: "flex text-sm",
                                                        children: [
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                children: "tip: "
                                                            }),
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                className: "mr-2",
                                                                children: (0,format/* formatPrice */.T4)(parseFloat(tip))
                                                            })
                                                        ]
                                                    })
                                                }) : null,
                                                totalPrice ? /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                                                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                        className: "flex text-sm",
                                                        children: [
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                children: "مجموع: "
                                                            }),
                                                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                                                className: "mr-2",
                                                                children: (0,format/* formatPrice */.T4)((0,format/* roundFinalPrice */.gz)(totalPrice2 + (0,format/* cartTotalTax */.HJ)(totalPrice2, tax, tip, order)))
                                                            })
                                                        ]
                                                    })
                                                }) : null
                                            ]
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                                className: "btn btn-accent w-full btn-sm text-sm",
                                                onClick: (e)=>{
                                                    handleSubmitOrder(e);
                                                },
                                                id: "submitOrder",
                                                children: "ثبت"
                                            })
                                        })
                                    ]
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("textarea", {
                                    className: "textarea textarea-bordered p-3 py-0 h-8 min-h-0",
                                    value: customerNote,
                                    onChange: (e)=>{
                                        setCustomerNote(e.target.value);
                                    },
                                    placeholder: "یادداشت صندوق دار"
                                }),
                                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                    className: "flex items-center justify-between gap-2",
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "w-full my-2 dropdown dropdown-top dropdown-end",
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                        tabIndex: 0,
                                                        className: "w-full btn btn-sm text-sm",
                                                        children: printerBehaveDefault != null ? printerBehaves[printerBehaveDefault - 1] : "انتخاب نوع پرینت"
                                                    }),
                                                    localStorage.getItem("client_type") == "2" ? null : /*#__PURE__*/ jsx_runtime_.jsx("ul", {
                                                        tabIndex: 0,
                                                        className: "w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box",
                                                        children: printerBehaves && printerBehaves.map((printerBehave)=>/*#__PURE__*/ jsx_runtime_.jsx("li", {
                                                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                                    onClick: ()=>{
                                                                        setPrinterBehaveDefault(keyPrinterBehaves[printerBehave]);
                                                                        localStorage.setItem("printer_behave_default", printerBehave);
                                                                        inputTableList.current.focus();
                                                                        inputTableList.current.blur();
                                                                    },
                                                                    children: printerBehave
                                                                })
                                                            }, printerBehave))
                                                    })
                                                ]
                                            })
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "w-full",
                                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                                className: "w-full my-2 dropdown dropdown-top dropdown-end",
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                                        className: "h-4 textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0",
                                                        value: tableId,
                                                        onChange: (e)=>{
                                                            setTableId(e.target.value);
                                                        },
                                                        ref: inputTableList,
                                                        placeholder: "شماره میز"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx("ul", {
                                                        tabIndex: 0,
                                                        className: "p-2 shadow menu dropdown-content bg-base-100 rounded-box flex items-start justify-start flex-row flex-wrap overflow-y-auto gap-2",
                                                        style: {
                                                            maxHeight: "80vh",
                                                            width: "calc(200% + .5rem)"
                                                        },
                                                        children: Object.keys(tableList).map((tl)=>(tl.includes(tableId) || !tableId) && !tableList[tl] ? /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                                                style: {
                                                                    borderRadius: "3px",
                                                                    backgroundColor: "#eee"
                                                                },
                                                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                                    className: tableId == tl ? "active" : "",
                                                                    style: {
                                                                        borderRadius: "3px"
                                                                    },
                                                                    onClick: ()=>{
                                                                        setTableId(tl);
                                                                        inputTableList.current.focus();
                                                                        inputTableList.current.blur();
                                                                    },
                                                                    children: tl
                                                                })
                                                            }, tl) : null)
                                                    })
                                                ]
                                            })
                                        })
                                    ]
                                }),
                                localStorage.getItem("access") && JSON.parse(localStorage.getItem("access")).discount ? /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                                    children: [
                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                            className: "grid grid-cols-2 gap-2 hide_mobile",
                                            children: [
                                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                                    className: "h-4 textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0",
                                                    style: {
                                                        direction: "ltr"
                                                    },
                                                    value: service2,
                                                    onChange: (e)=>{
                                                        let val = e.target.value;
                                                        let val2 = val ? parseFloat(val.replace(/,/g, "")) : val;
                                                        setService(val2);
                                                        setService2((0,format/* maskm */.EJ)(e.target.value));
                                                        interval();
                                                    },
                                                    type: "text",
                                                    placeholder: "سرویس"
                                                }),
                                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                                    className: "h-4 textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0",
                                                    style: {
                                                        direction: "ltr"
                                                    },
                                                    value: payment_cash,
                                                    onChange: (e)=>{
                                                        setPayment_cash((0,format/* maskm */.EJ)(e.target.value));
                                                    },
                                                    type: "text",
                                                    placeholder: "پرداخت نقدی"
                                                })
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                            className: "grid grid-cols-2 gap-2 hide_mobile",
                                            children: [
                                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                                    className: "h-4 textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0",
                                                    style: {
                                                        direction: "ltr"
                                                    },
                                                    value: payment_pos,
                                                    onChange: (e)=>{
                                                        setPayment_pos((0,format/* maskm */.EJ)(e.target.value));
                                                    },
                                                    type: "text",
                                                    placeholder: "پز"
                                                }),
                                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                                    className: "h-4 textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0",
                                                    style: {
                                                        direction: "ltr"
                                                    },
                                                    value: payment_card,
                                                    onChange: (e)=>{
                                                        setPayment_card((0,format/* maskm */.EJ)(e.target.value));
                                                    },
                                                    type: "text",
                                                    placeholder: "کارت به کارت"
                                                })
                                            ]
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "grid grid-cols-2 gap-2 hide_mobile",
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                                className: "h-4 textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0",
                                                style: {
                                                    direction: "ltr"
                                                },
                                                value: tip2,
                                                onChange: (e)=>{
                                                    let val = e.target.value;
                                                    setTip(val ? parseFloat(val.replace(/,/g, "")) : val);
                                                    setTip2((0,format/* maskm */.EJ)(val));
                                                    interval();
                                                },
                                                type: "text",
                                                placeholder: "tip"
                                            })
                                        })
                                    ]
                                }) : null,
                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                    type: "number",
                                    className: "textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2",
                                    value: numPeople,
                                    onChange: (e)=>{
                                        setNumPeople(e.target.value);
                                    },
                                    placeholder: "تعداد نفرات"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("textarea", {
                                    className: "textarea textarea-bordered p-3 py-0 h-8 min-h-0",
                                    value: note,
                                    onChange: (e)=>{
                                        setNote(e.target.value);
                                    },
                                    placeholder: "توضیحات"
                                })
                            ]
                        })
                    })
                ]
            }),
            !showSidebar && order.length ? /*#__PURE__*/ jsx_runtime_.jsx("button", {
                className: `px-4 py-2 text-sm btn btn-accent rounded-none lg:hidden absolute bottom-0 left-0 w-100 z-40 w-screen`,
                onClick: (e)=>{
                    handleSubmitOrder(e);
                },
                children: "ثبت سفارش"
            }) : null,
            /*#__PURE__*/ jsx_runtime_.jsx(AcceptPointModal, {
                show: showModal,
                setShow: setShowModal,
                setUserPoint: setUserPoint,
                customer: customer,
                userPoint: userPoint2
            }),
            /*#__PURE__*/ jsx_runtime_.jsx(components_PozModal, {
                open: pozModal,
                setOpen: setPozModal,
                data: pozData,
                setData: setPozData
            })
        ]
    });
};
/* harmony default export */ const components_Sidebar = (Sidebar);


/***/ }),

/***/ 4373:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "O": () => (/* binding */ simpleContext),
/* harmony export */   "f": () => (/* binding */ SimpleStateContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const SimpleStateContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
    listMode: "",
    setListMode: ()=>{}
});
const simpleContext = ()=>(0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(SimpleStateContext);


/***/ }),

/***/ 1348:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_2__);



const PageTitle = (props)=>{
    const { children  } = props;
    const title = children || "";
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_head__WEBPACK_IMPORTED_MODULE_2___default()), {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("title", {
            children: [
                title,
                title ? " - " : "",
                "Viuna Cafe - کافه ویونا"
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);


/***/ }),

/***/ 5656:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components_Layout__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1641);
/* harmony import */ var components_shared_PageTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1348);
/* harmony import */ var apiUrl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(6479);
/* harmony import */ var components_Products__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(767);
/* harmony import */ var helpers_offline__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9977);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var services_order__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(2145);
/* harmony import */ var services_table__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(3954);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([components_Layout__WEBPACK_IMPORTED_MODULE_3__]);
components_Layout__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


// 3rd-parties

// Application


// Styles


// import 'styles/style2.css'







const FRONTEND_SERVER_URL = "http://localhost:3000";
var CronJob = (__webpack_require__(6857).CronJob);
(axios__WEBPACK_IMPORTED_MODULE_2___default().defaults.baseURL) = apiUrl__WEBPACK_IMPORTED_MODULE_11__/* ["default"][1] */ .Z[1];
axios__WEBPACK_IMPORTED_MODULE_2___default().interceptors.response.use(function(response) {
    // Call was successful, don't do anything special.
    return response;
}, function(error) {
    if (error.response) {
        switch(error.response.status){
            case 401:
                // console.log("خطا در احراز هویت.");
                localStorage.clear();
                window.location.href = `${FRONTEND_SERVER_URL}/login`;
                break;
            case 419:
            case 503:
                break;
            case 500:
                break;
            default:
                // Allow individual requests to handle other errors
                return Promise.reject(error);
        }
    }
});
function MyApp({ Component , pageProps  }) {
    {
        const router = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
        const { 0: menuItems , 1: setMenuItems  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)([]);
        const { 0: catItems , 1: setCatItems  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)([]);
        const { 0: order , 1: setOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)([]);
        const { 0: offline , 1: setOffline  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
        const { 0: offlineBills , 1: setOfflineBills  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(0);
        const { 0: token , 1: setToken  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(null);
        const { 0: detailEditOrder , 1: setDetailEditOrder  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)({});
        const { 0: tableId , 1: setTableId  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)("");
        const { 0: repeatPrinting , 1: setRepeatPrinting  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
        const { 0: cron_job , 1: setCron_job  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)("4");
        const { 0: runCron , 1: setRunCron  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(true);
        const { 0: loader , 1: setLoader  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
        const { 0: warehouse , 1: setWarehouse  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(true);
        const { 0: tax , 1: setTax  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)("0");
        const { 0: branchName , 1: setBranchName  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)("");
        const { 0: seconds , 1: setSeconds  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(1);
        const { 0: refresh , 1: setRefresh  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)("0");
        const interval = ()=>{
            const timer = setInterval(()=>{
                setSeconds(seconds + 1);
            }, 100);
            return ()=>clearInterval(timer);
        };
        (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(()=>{
            setOffline(!window.navigator.onLine);
        // let c = localStorage.getItem('cronjob');
        // if (c)
        //   setCron_job(c);
        });
        (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(()=>{
            let t = localStorage.getItem("tax");
            setTax(t ? t : "0");
            setRefresh(localStorage.getItem("refresh") ?? "0");
        // console.log('first')
        }, [
            router
        ]);
        (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(()=>{
            (0,services_order__WEBPACK_IMPORTED_MODULE_9__/* .saveBranch */ .hY)({
                id: 1
            }).then((res)=>{
                let w = res["order"] && res["order"].warehouse && res["order"].warehouse == 1 ? true : false;
                setWarehouse(w);
                if (res["order"] && res["order"]["name"]) setBranchName(res["order"]["name"]);
                if (!res["order"] || !res["order"].cronjob) {
                    localStorage.removeItem("token");
                    router.push("/login");
                } else {
                    var job = new CronJob("0 " + res["order"].cronjob + " * * * *", function() {
                        (0,helpers_offline__WEBPACK_IMPORTED_MODULE_6__/* .uploadOfflineOrders */ .E7)(null, null, w);
                    }, null, true, "Asia/Tehran");
                }
            });
            var job2 = new CronJob("0 0 12 * * *", function() {
                (0,helpers_offline__WEBPACK_IMPORTED_MODULE_6__/* .saveRawItems */ .wq)();
                if (warehouse) (0,services_table__WEBPACK_IMPORTED_MODULE_10__/* .getMaterial */ .Ut)(1);
            }, null, true, "Asia/Tehran");
            if (warehouse) (0,services_table__WEBPACK_IMPORTED_MODULE_10__/* .getMaterial */ .Ut)();
        }, []);
        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_Products__WEBPACK_IMPORTED_MODULE_5__/* .ProductsStateContext.Provider */ .M.Provider, {
            value: {
                menuItems,
                setMenuItems,
                order,
                setOrder,
                offline,
                setOffline,
                offlineBills,
                setOfflineBills,
                token,
                setToken,
                catItems,
                setCatItems,
                detailEditOrder,
                setDetailEditOrder,
                tableId,
                setTableId,
                repeatPrinting,
                setRepeatPrinting,
                loader,
                setLoader,
                warehouse,
                tax,
                setTax,
                branchName,
                setBranchName,
                interval,
                refresh,
                setRefresh
            },
            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_Layout__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_shared_PageTitle__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {}),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("meta", {
                                name: "viewport",
                                content: "width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=5"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("script", {
                                src: "/js/jquery.js"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("script", {
                                src: "/js/signalr.js"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("script", {
                                src: "http://localhost:8080/signalr/hubs"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("script", {
                                src: "/js/poz.js?v=1015"
                            })
                        ]
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Component, {
                        ...pageProps
                    })
                ]
            })
        });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MyApp);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8819:
/***/ (() => {



/***/ }),

/***/ 5725:
/***/ ((module) => {

"use strict";
module.exports = require("antd");

/***/ }),

/***/ 2167:
/***/ ((module) => {

"use strict";
module.exports = require("axios");

/***/ }),

/***/ 8103:
/***/ ((module) => {

"use strict";
module.exports = require("clsx");

/***/ }),

/***/ 6857:
/***/ ((module) => {

"use strict";
module.exports = require("cron");

/***/ }),

/***/ 3280:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 2796:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 4014:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 8524:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 8020:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 4406:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 4964:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 1751:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 6220:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 299:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 3938:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 9565:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 5789:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 8854:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 1292:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 4567:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 979:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 3297:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 6052:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 4226:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 5052:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 9232:
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 968:
/***/ ((module) => {

"use strict";
module.exports = require("next/head");

/***/ }),

/***/ 1853:
/***/ ((module) => {

"use strict";
module.exports = require("next/router");

/***/ }),

/***/ 6689:
/***/ ((module) => {

"use strict";
module.exports = require("react");

/***/ }),

/***/ 1187:
/***/ ((module) => {

"use strict";
module.exports = require("react-toastify");

/***/ }),

/***/ 997:
/***/ ((module) => {

"use strict";
module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9816:
/***/ ((module) => {

"use strict";
module.exports = require("styled-jsx/style");

/***/ }),

/***/ 4612:
/***/ ((module) => {

"use strict";
module.exports = import("socket.io-client");;

/***/ }),

/***/ 6113:
/***/ ((module) => {

"use strict";
module.exports = require("crypto");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [676,664,749,954,422,890,726,4,930,826,706], () => (__webpack_exec__(5656)));
module.exports = __webpack_exports__;

})();