"use strict";
exports.id = 954;
exports.ids = [954];
exports.modules = {

/***/ 6479:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ([
    "https://viunaorder.avishost.com",
    "https://viunaorder.avishost.com/restapi"
]);


/***/ }),

/***/ 3954:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AY": () => (/* binding */ saveLog),
/* harmony export */   "C2": () => (/* binding */ getPrintLocal),
/* harmony export */   "Jf": () => (/* binding */ requestPrintTablet),
/* harmony export */   "Lh": () => (/* binding */ getTable2),
/* harmony export */   "NL": () => (/* binding */ requestRepeatPrint),
/* harmony export */   "Nm": () => (/* binding */ getDetail),
/* harmony export */   "O1": () => (/* binding */ sendAlert),
/* harmony export */   "TZ": () => (/* binding */ getRawItems),
/* harmony export */   "Ut": () => (/* binding */ getMaterial),
/* harmony export */   "WY": () => (/* binding */ request),
/* harmony export */   "bL": () => (/* binding */ printChangeTable),
/* harmony export */   "hC": () => (/* binding */ getTable),
/* harmony export */   "m8": () => (/* binding */ changeTable),
/* harmony export */   "mF": () => (/* binding */ saveMaterialLog),
/* harmony export */   "qC": () => (/* binding */ request2),
/* harmony export */   "wv": () => (/* binding */ changeStatus)
/* harmony export */ });
/* unused harmony exports setQuery, getAndSaveMaterial, saveMaterial */
/* harmony import */ var _order__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2145);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _baseU_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7258);
/* harmony import */ var apiUrl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6479);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);





const status_text = {
    0: "معلق",
    1: " باز ",
    2: "ویرایش ",
    3: "کنسل ",
    4: " چاپ شده ",
    5: "پرداخت  و مانده",
    6: "پرداخت  و رفته",
    7: "DIGI JET",
    10: "refund"
};
const getTable = ()=>{
    return new Promise((resolve, reject)=>{
        const brancId = localStorage.getItem("user_client_id");
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/table?branch_id=${brancId}&offline=1`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const getTable2 = ()=>{
    return new Promise((resolve, reject)=>{
        const brancId = localStorage.getItem("user_client_id");
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/table_offline?branch_id=${brancId}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            if (res) resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const getDetail = (id)=>{
    return new Promise((resolve, reject)=>{
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/table_detail2?order_id=${id}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const getRawItems = ()=>{
    return new Promise((resolve, reject)=>{
        let token = localStorage.getItem("token");
        let id = "";
        if (token) id = token.split("%")[1];
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/raw_items?id=${id}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const changeStatus = (order_id, st_id)=>{
    return new Promise((resolve, reject)=>{
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/table_change_st?order_id=${order_id}&st_id=${st_id}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const changeTable = (order_id, table_id)=>{
    return new Promise((resolve, reject)=>{
        // console.log(order_id);
        // console.log(table_id);
        (0,_order__WEBPACK_IMPORTED_MODULE_0__/* .saveOrderOffline */ .oq)({
            id: order_id,
            table_id: table_id
        }).then((res)=>{
            if (res["order"]) {
                let r = res["order"];
                let d = JSON.parse(r.order_details);
                let data = {
                    final_price: r.total,
                    id: r.offline_id,
                    local_id: r.id,
                    table_id: r.table_id,
                    user_name: d.user_name,
                    user_id: d.user_id,
                    note: d.customer_note,
                    date: r.date,
                    date_orginal: r.date,
                    status_raw: r.status,
                    status: status_text[r.status],
                    pdf_customer: "",
                    pdf_bar: ""
                };
                resolve(data);
            }
        });
    // saveOrder
    });
};
const requestRepeatPrint = (order_id)=>{
    return new Promise((resolve, reject)=>{
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/table_print_all?order_id=${order_id}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const requestPrintTablet = (order_id)=>{
    return new Promise((resolve, reject)=>{
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-order/table_print_tablet?order_id=${order_id}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const getPrintLocal = (page, order_id, printer)=>{
    return new Promise((resolve, reject)=>{
        const url = `${_baseU_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z}/printLocal?page=${page}&order_id=${order_id}&printer=${printer}`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            resolve(res.data);
        }).catch((err)=>{
            reject(err);
        });
    });
};
const setQuery = (type, order_id, table_id, st_id)=>{
    // set query for server
    let queryList = localStorage.getItem("queryList");
    if (!queryList) {
        localStorage.setItem("queryList", "[]");
        queryList = localStorage.getItem("queryList");
    }
    queryList = JSON.parse(queryList);
    const newQuery = {
        type,
        order_id: order_id || "",
        table_id: table_id || "",
        st_id: st_id || "",
        date: Date.now()
    };
    queryList.push(newQuery);
    localStorage.setItem("queryList", JSON.stringify(queryList));
    setTimeout(()=>{
        queryList = localStorage.getItem("queryList") || "[]";
        queryList = JSON.parse(queryList);
        if (type == "setStatus") {
            changeStatus(order_id, st_id);
            queryList = queryList.filter((item)=>item.order_id != order_id && item.st_id != st_id);
        } else if (type == "changeTable") {
            changeTable(order_id, table_id);
            queryList = queryList.filter((item)=>item.order_id != order_id && item.table_id != table_id);
        }
        localStorage.setItem("queryList", JSON.stringify(queryList));
    }, 5400000);
};
const printChangeTable = (prewTable, nextTable)=>{
    const printer = localStorage.getItem("p2") || "";
    if (!printer) return;
    let phone = " ";
    if (localStorage.getItem("phone")) phone = localStorage.getItem("phone");
    let no_brand = localStorage.getItem("no_brand");
    if (!no_brand) no_brand = "0";
    let branchName = localStorage.getItem("branch_name");
    const url = `${_baseU_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z}/printChangeTable?prewTable=${prewTable}&nextTable=${nextTable}&printer=${printer}&phone=${phone}&no_brand=${no_brand}&branchName=${branchName}`;
    axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
        return;
    }).catch((err)=>{
        return;
    });
};
const getMaterial = (update)=>{
    return new Promise((resolve, reject)=>{
        if (update == 1) {
            getAndSaveMaterial().then((r)=>{
                resolve(r);
            });
        } else {
            request({
                _id: 1
            }, "/api/find2?model=Material").then((res)=>{
                if (!res.length) {
                    getAndSaveMaterial().then((r)=>{
                        resolve(r);
                    });
                }
            });
        }
    });
};
const getAndSaveMaterial = ()=>{
    return new Promise((resolve, reject)=>{
        const url = `${apiUrl__WEBPACK_IMPORTED_MODULE_3__/* ["default"][0] */ .Z[0]}/in-branch-item/qty-detail`;
        axios__WEBPACK_IMPORTED_MODULE_1___default().get(url).then((res)=>{
            if (res.data) {
                resolve(res.data);
                saveMaterial({
                    data: res.data
                });
            }
        }).catch((err)=>{
            reject(err);
        });
    });
};
const saveMaterial = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
            url: "api/material",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const saveMaterialLog = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
            url: "api/material_log",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const saveLog = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
            url: "api/saveLog",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const request = (req, url)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
            url: url,
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const request2 = (url, method, data)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: method,
            url: url,
            headers: {
                "Content-Type": "application/json"
            },
            data: data
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const sendAlert = (success = false, msg)=>{
    const option = {
        position: "bottom-right",
        style: {
            direction: "rtl",
            "text-align": "right",
            fontFamily: "Peyda-Medium",
            "white-space": "pre-line"
        },
        theme: "colored"
    };
    if (success) react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(msg, option);
    else react_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(msg, option);
};


/***/ })

};
;