"use strict";
exports.id = 930;
exports.ids = [930];
exports.modules = {

/***/ 7930:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const ImageComponent = ({ src , layout ="fixed" , width , height , alt  })=>{
    // return <Image src={src} layout="fixed" width={width} height={height} alt={alt} />
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
        src: src,
        alt: alt,
        style: {
            width: `${width}px`,
            height: `${height}px`
        },
        className: "m-auto"
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ImageComponent);


/***/ }),

/***/ 1930:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "socketConnection": () => (/* binding */ socketConnection)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_shared_Error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6726);
/* harmony import */ var components_shared_image_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7930);
/* harmony import */ var helpers_printer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3130);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var antd__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5725);
/* harmony import */ var antd__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(antd__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var components_Products__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(767);
/* harmony import */ var helpers_format__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(890);
/* harmony import */ var helpers_offline__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(9977);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var services_order__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(2145);
/* harmony import */ var services_persian__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(4272);
/* harmony import */ var services_table__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(3954);
/* harmony import */ var helpers_check_items__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(5422);
/* harmony import */ var socket_io_client__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(4612);
/* harmony import */ var services_branch__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(102);
/* harmony import */ var components_contexts_RefreshContext__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(2738);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([socket_io_client__WEBPACK_IMPORTED_MODULE_14__]);
socket_io_client__WEBPACK_IMPORTED_MODULE_14__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



















const socketConnection = (client_type, router, acceptOrder)=>{
    const playBellSound = async (order_id)=>{
        const branch_data = await (0,services_branch__WEBPACK_IMPORTED_MODULE_15__/* .getOnlineBranchData */ .L)();
        const bellSound = new Audio("/audio/notif.mp3");
        bellSound.loop = !isNaN(branch_data?.repeat_alert) && branch_data?.repeat_alert == 1 ? true : false;
        let play = bellSound.play();
        let id = react_toastify__WEBPACK_IMPORTED_MODULE_10__.toast.success(order_id, {
            autoClose: false,
            hideProgressBar: true,
            position: "bottom-right",
            style: {
                direction: "rtl",
                fontFamily: "IRANSansX"
            },
            onClose: ()=>{
                bellSound.pause();
            }
        });
    };
    const socket = (0,socket_io_client__WEBPACK_IMPORTED_MODULE_14__["default"])("http://socket.cafe-viuna.com:9999", {
        reconnectionDelayMax: 10000
    });
    socket.on("connect_error", (err)=>{
        console.log(`connect_error due to ${err.message}`);
    });
    socket.on("connect", ()=>{
        if (false) {}
    });
    socket.on("disconnect", function() {
        console.log("user disconnect");
    });
    socket.off("joinRoom");
    socket.on("joinRoom", (roomInfo)=>{
        console.log("joinRoom: " + roomInfo);
    });
    socket.off("receiveOrder");
    socket.on("receiveOrder", (order_id)=>{
        (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .findOrder */ .a_)({
            offline_id: order_id[0]
        }, 1).then((o)=>{
            if (o["order"]) return;
            createOrder(order_id[0], 0).then((res)=>{
                if (!res) return true;
                sendOrderSave(order_id[0]);
                playBellSound(order_id[1]);
                if (router.asPath == "/tables") {
                    (0,components_contexts_RefreshContext__WEBPACK_IMPORTED_MODULE_16__/* .triggerRefresh */ .Cb)();
                }
            });
        });
    });
    socket.off("receiveOrderUpdate");
    socket.on("receiveOrderUpdate", (order_id)=>{
        acceptOrder(order_id[0]);
    });
    socket.off("showMsg");
    socket.on("showMsg", (message)=>{
        playBellSound(message[0]);
    });
};
const sendOrderSave = async (id)=>{
    try {
        let res = await (0,services_table__WEBPACK_IMPORTED_MODULE_12__/* .request2 */ .qC)(`/saved-order?id=${id}`, "get");
    } catch (error) {}
};
const createOrder = (order_id, update)=>{
    return new Promise((resolve, _)=>{
        (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .getOnlineOrderData */ .yb)(order_id).then((res)=>{
            if (!res["order"].id) {
                resolve(false);
                return true;
            }
            let order = (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .createOrderData */ .Wy)(res);
            let customer = res["customer"];
            let totalAmount = (0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .cartTotalPrice2 */ .a0)(order);
            let paymentTypeDefault = localStorage.getItem("paymentType") ? localStorage.getItem("paymentType") : "پوز";
            let customFields = res["order"]?.custom ? JSON.stringify(res["order"].custom) : "{}";
            let customerNote = res["order"].customer_note;
            let numPeople = res["order"].numPeople;
            let tableId = res["order"].table_id;
            let note = res["order"].note;
            let service = res["order"].service;
            let id = res["order"].id;
            let status = res["order"]?.pay_status == 1 && res["order"]?.payment_trans_id && res["order"]?.status ? res["order"]?.status : -1;
            const flag = res["order"]?.pay_status == 1 && res["order"]?.payment_trans_id ? 0 : 1;
            let useDiscount = {
                text: "انتخاب تخفیف",
                id: 0
            };
            if (tableId && update != 1) {
                (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .findOrder */ .a_)({
                    status: 6,
                    table_id: tableId
                }, 1).then((res)=>{
                    let online_table_id = "";
                    if (res["order"]) {
                        online_table_id = tableId;
                        note += ` شماره میز : ${tableId}`;
                        tableId = "";
                    }
                    (0,helpers_offline__WEBPACK_IMPORTED_MODULE_9__/* .submitOrderLocally */ .M3)(order, customer, totalAmount, paymentTypeDefault, customerNote, false, update == 1 ? id : 0, numPeople, tableId, {}, {}, useDiscount, note, 0, false, service, "", "", "", id, -1, 1, online_table_id, null, null, null, null, true, customFields).then((res)=>{
                        resolve(true);
                    });
                });
            } else {
                (0,helpers_offline__WEBPACK_IMPORTED_MODULE_9__/* .submitOrderLocally */ .M3)(order, customer, totalAmount, paymentTypeDefault, customerNote, false, update == 1 ? id : 0, numPeople, tableId, {}, {}, useDiscount, note, 0, false, service, "", "", "", id, status, flag, null, null, null, null, null, true, customFields).then((res)=>{
                    resolve(true);
                });
            }
        });
    });
};
const PrintersPage = ()=>{
    const { 0: isError , 1: setIsError  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const { 0: printers , 1: setPrinters  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
    const { 0: printersName , 1: setPrintersName  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)({});
    const { 0: printerIds , 1: setPrinterIds  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
    const { 0: total , 1: setTotal  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)({
        count: "0",
        total: "0"
    });
    const { 0: total2 , 1: setTotal2  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)({
        count: "0",
        total: "0"
    });
    const { 0: total3 , 1: setTotal3  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)({
        count: "0",
        total: "0"
    });
    const { 0: borderSize , 1: setBorderSize  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    const { 0: fontSize , 1: setFontSize  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    const { 0: pageWidth , 1: setPageWidth  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)("");
    const { 0: com , 1: setCom  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)("COM4");
    const { 0: financialAccess , 1: setFinancialAccess  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(true);
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_5__.useRouter)();
    const { setLoader , setToken , setOrder , token , warehouse  } = (0,components_Products__WEBPACK_IMPORTED_MODULE_8__/* .useProductContext */ .$)();
    const getItems = async (id)=>{
        try {
            let resp = await (0,helpers_check_items__WEBPACK_IMPORTED_MODULE_13__/* .getChildren */ .G)(id, token);
            let normalizedItems = resp.items;
            localStorage.setItem(`level${id}`, JSON.stringify(normalizedItems));
            localStorage.setItem(`date${id}`, String(resp.last_update));
            for(let itmN in resp.items){
                if (resp.items[itmN].isCat) {
                    getItems(resp.items[itmN].id);
                }
            }
            return true;
        } catch (error) {
            console.log(error);
            return false;
        }
    };
    const updateMenu = async ()=>{
        try {
            let resp = await (0,helpers_check_items__WEBPACK_IMPORTED_MODULE_13__/* .getChildren */ .G)(0, token);
            for(let catItem in resp.items){
                getItems(resp.items[catItem].id);
            }
            return true;
        } catch (error) {
            console.log(error);
            return false;
        }
    };
    const handlePrinters = async ()=>{
        await (0,helpers_printer__WEBPACK_IMPORTED_MODULE_3__/* .getPrinters */ .VZ)().then((printersArr)=>{
            // console.log(printersArr)
            setPrinters([
                ...printersArr
            ]);
        }).catch(()=>setIsError(true));
    };
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(()=>{
        // get all nodes from localstorage
        let pids = localStorage.getItem("printers");
        // nodes are not available? need to re-login
        if (!pids) {
            localStorage.removeItem("token");
            router.push("/login");
        }
        let pidsArr = JSON.parse(pids) || "[]";
        let pidsObjArr = [];
        pidsArr.forEach((id)=>{
            let name = localStorage.getItem(id);
            let item = {
                id,
                name
            };
            pidsObjArr.push(item);
        });
        setPrinterIds([
            ...pidsObjArr
        ]);
        setPrintersName(JSON.parse(localStorage.getItem("printers_name") || "{}"));
        // get accessible printers from node server
        handlePrinters();
        orderSum();
        if (!localStorage.getItem("borderSize")) localStorage.setItem("borderSize", "3");
        if (!localStorage.getItem("fontSize")) localStorage.setItem("fontSize", "12");
        if (!localStorage.getItem("pageWidth")) localStorage.setItem("pageWidth", "90");
        setBorderSize(localStorage.getItem("borderSize"));
        setFontSize(localStorage.getItem("fontSize"));
        setPageWidth(localStorage.getItem("pageWidth"));
        if (localStorage.getItem("com")) setCom(localStorage.getItem("com"));
        let f = localStorage.getItem("access");
        if (f) {
            f = JSON.parse(f);
            f = f["financial"];
            setFinancialAccess(f ? true : false);
        }
    }, [
        router
    ]);
    const orderSum = ()=>{
        (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .findOrder */ .a_)({
            sum: 1
        }).then((o)=>{
            if (o["total"].length) setTotal(o["total"][0]);
            else setTotal({
                count: "0",
                total: "0"
            });
            if (o["total2"].length) setTotal2(o["total2"][0]);
            else setTotal2({
                count: "0",
                total: "0"
            });
            if (o["total3"].length) setTotal3(o["total3"][0]);
            else setTotal3({
                count: "0",
                total: "0"
            });
        });
    };
    function logOut() {
        if (confirm("آیا مطمئن هستید؟")) {
            setToken(null);
            localStorage.removeItem("token");
            setOrder([]);
            router.push("/login");
        }
    }
    const handleSendAllPrint = async ()=>{
        setLoader(true);
        let printers = localStorage.getItem("printers") || "[]";
        printers = JSON.parse(printers);
        const prints = {};
        for(let i = 0; i < printers.length; i++){
            const p = localStorage.getItem(printers[i]) || 0;
            if (p) {
                prints[printers[i]] = p;
            }
        }
        let orders = await (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .findOrder */ .a_)({
            sort: 1
        });
        if (orders["order"] && orders["order"]?.length) {
            let startDate = (0,services_persian__WEBPACK_IMPORTED_MODULE_18__/* .getPersianDate */ .T0)(orders["order"][0]["date"], "y/m/d");
            let endDate = (0,services_persian__WEBPACK_IMPORTED_MODULE_18__/* .getPersianDate */ .T0)(orders["order"][orders["order"].length - 1]["date"], "y/m/d");
            let totalPrice = 0;
            const orderData = [];
            for (const iterator of orders["order"]){
                totalPrice += iterator["total"];
                orderData.push({
                    _id: iterator["_id"],
                    date: iterator["date"],
                    total: iterator["total"]
                });
            }
            const print = await (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .printAllOrders */ .Q5)(orderData, pageWidth, startDate, endDate, borderSize, fontSize, (0,services_persian__WEBPACK_IMPORTED_MODULE_18__/* .numberFormat */ .Y4)(totalPrice), prints);
            if (print["success"]) {
                setLoader(false);
            }
        } else {
            setLoader(false);
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", {
            className: "flex flex-col items-center h-screen md:flex-row justify-center",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "hidden w-full h-screen bg-no-repeat bg-cover bg-printer-texture lg:block md:w-1/2"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "flex items-start justify-center w-full h-screen px-6 bg-white md:max-w-md lg:max-w-full md:mx-0 lg:px-16 xl:px-12 overflow-y-auto",
                    style: {
                        minWidth: "fit-content"
                    },
                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                        className: "flex flex-col items-center justify-center w-full h-100 m-auto pb-4 pt-32",
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "w-full text-yellow-700",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                                        href: "/",
                                        className: "float-right",
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
                                            children: "بازگشت"
                                        })
                                    }),
                                    token && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "px-4 cursor-pointer float-left flex items-center gap-2 bg-red-600 rounded-md py-1.5",
                                        onClick: (e)=>{
                                            logOut();
                                        },
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_shared_image_component__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                                                src: "/images/logout.png",
                                                alt: "logout",
                                                width: 25,
                                                height: 25
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                                className: "text-white",
                                                children: "خروج از حساب کاربری"
                                            })
                                        ]
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "bg-green-200 border-t-4 border-teal-500 rounded-b text-teal-900 px-4 py-3 shadow-md mb-3",
                                role: "alert",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "flex",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        children: [
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                className: "font-bold",
                                                children: [
                                                    "تعداد کل: ",
                                                    total["count"]
                                                ]
                                            }),
                                            financialAccess ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                className: "font-bold",
                                                children: [
                                                    "مجموع قیمت کل:",
                                                    " ",
                                                    (0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .formatPrice */ .T4)((0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .roundFinalPrice */ .gz)(parseFloat(total["total"]), true))
                                                ]
                                            }) : ""
                                        ]
                                    })
                                })
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "bg-yellow-200 border-t-4 border-teal-500 rounded-b text-teal-900 px-4 py-3 shadow-md mb-3",
                                role: "alert",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "flex",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        children: [
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                className: "font-bold",
                                                children: [
                                                    "تعداد تسویه شده های ارسال نشده: ",
                                                    total2["count"]
                                                ]
                                            }),
                                            financialAccess ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                className: "font-bold",
                                                children: [
                                                    "مجموع تسویه شده های ارسال نشده:",
                                                    " ",
                                                    (0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .formatPrice */ .T4)((0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .roundFinalPrice */ .gz)(parseFloat(total2["total"]), true))
                                                ]
                                            }) : ""
                                        ]
                                    })
                                })
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "bg-blue-200 border-t-4 border-teal-500 rounded-b text-teal-900 px-4 py-3 shadow-md mb-3",
                                role: "alert",
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "flex",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        children: [
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                className: "font-bold",
                                                children: [
                                                    "تعداد تسویه شده های ارسال شده: ",
                                                    total3["count"]
                                                ]
                                            }),
                                            financialAccess ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                className: "font-bold",
                                                children: [
                                                    "مجموع تسویه شده های ارسال شده:",
                                                    " ",
                                                    (0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .formatPrice */ .T4)((0,helpers_format__WEBPACK_IMPORTED_MODULE_17__/* .roundFinalPrice */ .gz)(parseFloat(total3["total"]), true))
                                                ]
                                            }) : ""
                                        ]
                                    })
                                })
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_shared_Error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                                isError: isError,
                                message: "هیچ پرینتری در دسترس نیست"
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "flex items-center justify-center mt-12",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "pt-2 ml-4 cursor-pointer",
                                        onClick: ()=>{
                                            // remove current nodes
                                            let printers = localStorage.getItem("printers") || "[]";
                                            JSON.parse(printers).forEach((node)=>{
                                                localStorage.removeItem(node);
                                            });
                                            // reload printers list
                                            handlePrinters();
                                        },
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_shared_image_component__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                                            src: "/images/undo.png",
                                            width: 24,
                                            height: 24,
                                            alt: "undo"
                                        })
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                                        className: "text-xl font-bold leading-tight md:text-2xl",
                                        children: "لیست پرینترهای تعریف شده"
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "flex items-center justify-center mt-12",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "pt-2 ml-4 cursor-pointer",
                                        onClick: ()=>{
                                            // remove current nodes
                                            let printers = localStorage.getItem("printers") || "[]";
                                            JSON.parse(printers).forEach((node)=>{
                                                localStorage.removeItem(node);
                                            });
                                            document.location.reload();
                                        //  ("#mysaid option:selected").prop("selected", false)
                                        },
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_shared_image_component__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                                            src: "/images/trash.png",
                                            width: 24,
                                            height: 24,
                                            alt: "trash"
                                        })
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h1", {
                                        className: "text-xl font-bold leading-tight md:text-2xl",
                                        children: "پاک کردن پرینترهای تعریف شده"
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("form", {
                                className: "mt-6 w-full flex flex-col",
                                children: printerIds.map((pid, index)=>{
                                    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "flex items-center justify-between",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                                className: "pb-4 ml-4",
                                                children: printersName[pid.id] || pid.id
                                            }),
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("select", {
                                                id: `select_${pid.id}`,
                                                className: `w-full mb-4 select`,
                                                style: {
                                                    maxWidth: "80%"
                                                },
                                                onChange: (e)=>{
                                                    localStorage.setItem(pid.id, e.target.value);
                                                },
                                                defaultValue: 0,
                                                children: [
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                        disabled: true,
                                                        value: 0,
                                                        id: `option_${pid.id}`,
                                                        children: pid.name ? pid.name : "انتخاب کنید"
                                                    }),
                                                    printers.map((printer, idx)=>{
                                                        // console.log(printer)
                                                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                            value: printer.name,
                                                            children: printer.name
                                                        }, idx);
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                type: "button",
                                                className: "inline-block px-2 py-2 bg-red-600 text-white font-medium text-xs leading-tight uppercase rounded-full shadow-md hover:bg-red-700 hover:shadow-lg focus:bg-red-700 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-red-800 active:shadow-lg transition duration-150 ease-in-out",
                                                onClick: ()=>{
                                                    localStorage.removeItem(pid.id);
                                                    document.getElementById(`select_${pid.id}`).value = "0";
                                                    document.getElementById(`option_${pid.id}`).innerHTML = "انتخاب کنید";
                                                },
                                                children: "خالی کردن"
                                            })
                                        ]
                                    }, index);
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "flex items-center justify-start w-full",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                        className: "pb-4 ml-4",
                                        children: "انتخاب COM"
                                    }),
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("select", {
                                        className: `w-full mb-4 select`,
                                        style: {
                                            maxWidth: "80%"
                                        },
                                        onChange: (e)=>{
                                            localStorage.setItem("com", e.target.value);
                                            setCom(e.target.value);
                                        },
                                        value: com,
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM1",
                                                children: "COM1"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM2",
                                                children: "COM2"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM3",
                                                children: "COM3"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM4",
                                                children: "COM4"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM5",
                                                children: "COM5"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM6",
                                                children: "COM6"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM7",
                                                children: "COM7"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM8",
                                                children: "COM8"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM9",
                                                children: "COM9"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                value: "COM10",
                                                children: "COM10"
                                            })
                                        ]
                                    })
                                ]
                            }, "com_select"),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                className: "w-full border p-2 rounded mt-2 mb-3",
                                children: [
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "mt-3 mb-3",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h6", {
                                                children: "تنظیمات پرینت"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("hr", {})
                                        ]
                                    }),
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "mt-3 mb-3",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                htmlFor: "",
                                                children: "قطر کادر (پیکسل) ( عدد پیشنهادی ۳ میباشد)"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                type: "number",
                                                value: borderSize,
                                                onChange: (e)=>{
                                                    setBorderSize(e.target.value);
                                                    localStorage.setItem("borderSize", e.target.value ? e.target.value : "3");
                                                },
                                                className: "textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2"
                                            })
                                        ]
                                    }),
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "mt-3 mb-3",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                htmlFor: "",
                                                children: "اندازه فونت (پیکسل) ( عدد پیشنهادی ۱۲ میباشد)"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                type: "number",
                                                value: fontSize,
                                                onChange: (e)=>{
                                                    setFontSize(e.target.value);
                                                    localStorage.setItem("fontSize", e.target.value ? e.target.value : "18");
                                                },
                                                className: "textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2"
                                            })
                                        ]
                                    }),
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "mt-3 mb-3",
                                        children: [
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("label", {
                                                htmlFor: "",
                                                children: [
                                                    " ",
                                                    "عرض صفحه (درصد) ( عدد پیشنهادی ۹۰ میباشد)"
                                                ]
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                type: "number",
                                                value: pageWidth,
                                                onChange: (e)=>{
                                                    setPageWidth(e.target.value);
                                                    localStorage.setItem("pageWidth", e.target.value ? e.target.value : "90");
                                                },
                                                className: "textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2"
                                            })
                                        ]
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                className: "w-full",
                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(antd__WEBPACK_IMPORTED_MODULE_7__.Row, {
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(antd__WEBPACK_IMPORTED_MODULE_7__.Col, {
                                            md: 12,
                                            lg: 12,
                                            sm: 24,
                                            xs: 24,
                                            className: "p-2",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                className: "btn btn-accent w-full mt-4",
                                                onClick: (e)=>{
                                                    if (confirm("آیا مطمئن هستید؟")) {
                                                        localStorage.clear();
                                                        router.push("/login");
                                                    }
                                                },
                                                children: "ریست تمام تنظمیات برنامه و حذف پرینتر ها"
                                            })
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(antd__WEBPACK_IMPORTED_MODULE_7__.Col, {
                                            md: 12,
                                            lg: 12,
                                            sm: 24,
                                            xs: 24,
                                            className: "p-2",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                className: "btn btn-accent w-full mt-4",
                                                onClick: (e)=>{
                                                    if (confirm("آیا مطمئن هستید؟")) {
                                                        setLoader(true);
                                                        updateMenu().then((res)=>{
                                                            (0,helpers_offline__WEBPACK_IMPORTED_MODULE_9__/* .saveRawItems */ .wq)().then(()=>{
                                                                setLoader(false);
                                                                router.push("/");
                                                            });
                                                        });
                                                    }
                                                },
                                                children: "به روز رسانی منو"
                                            })
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(antd__WEBPACK_IMPORTED_MODULE_7__.Col, {
                                            md: 12,
                                            lg: 12,
                                            sm: 24,
                                            xs: 24,
                                            className: "p-2",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                className: "btn btn-accent w-full mt-4",
                                                onClick: (e)=>{
                                                    if (confirm("آیا مطمئن هستید؟")) {
                                                        setLoader(true);
                                                        (0,services_table__WEBPACK_IMPORTED_MODULE_12__/* .getTable */ .hC)().then((res)=>{
                                                            if (res) {
                                                                localStorage.setItem("tables", JSON.stringify(res));
                                                                setLoader(false);
                                                            }
                                                        });
                                                        (0,services_table__WEBPACK_IMPORTED_MODULE_12__/* .getTable2 */ .Lh)().then((r)=>{
                                                            localStorage.setItem("salon", JSON.stringify(r));
                                                        });
                                                    }
                                                },
                                                children: "به روز رسانی میز ها"
                                            })
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(antd__WEBPACK_IMPORTED_MODULE_7__.Col, {
                                            md: 12,
                                            lg: 12,
                                            sm: 24,
                                            xs: 24,
                                            className: "p-2",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                className: "btn btn-accent w-full mt-4",
                                                onClick: (e)=>{
                                                    if (confirm("آیا مطمئن هستید؟")) {
                                                        setLoader(true);
                                                        (0,helpers_offline__WEBPACK_IMPORTED_MODULE_9__/* .uploadOfflineOrders */ .E7)(null, null, warehouse);
                                                        (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .findOrder */ .a_)({
                                                            status: 20
                                                        }).then((o)=>{
                                                            if (o["order"].length) {
                                                                react_toastify__WEBPACK_IMPORTED_MODULE_10__.toast.error("تمامی اطلاعات   هنوز به صورت کامل به  پایگاه  داده ارسال نشده", {
                                                                    hideProgressBar: true,
                                                                    position: "bottom-right",
                                                                    style: {
                                                                        direction: "rtl",
                                                                        fontFamily: "IRANSansX"
                                                                    }
                                                                });
                                                                setLoader(false);
                                                                return;
                                                            } else {
                                                                (0,services_order__WEBPACK_IMPORTED_MODULE_11__/* .findOrder */ .a_)({
                                                                    remove: 1
                                                                }).then((r)=>{
                                                                    if (r["order"].acknowledged === true) {
                                                                        (0,services_table__WEBPACK_IMPORTED_MODULE_12__/* .request */ .WY)({
                                                                            status: 0
                                                                        }, "/api/find2?model=Log").then((res)=>{
                                                                            if (!res?.length) (0,services_table__WEBPACK_IMPORTED_MODULE_12__/* .request */ .WY)({
                                                                                removeAll: 1
                                                                            }, "/api/find2?model=Log");
                                                                        });
                                                                        react_toastify__WEBPACK_IMPORTED_MODULE_10__.toast.success(" با موفقیت انجام شد", {
                                                                            hideProgressBar: true,
                                                                            position: "bottom-right",
                                                                            style: {
                                                                                direction: "rtl",
                                                                                fontFamily: "IRANSansX"
                                                                            }
                                                                        });
                                                                        setLoader(false);
                                                                        return;
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                },
                                                children: "صفر کردن صندق"
                                            })
                                        }),
                                        financialAccess ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(antd__WEBPACK_IMPORTED_MODULE_7__.Col, {
                                            md: 12,
                                            lg: 12,
                                            sm: 24,
                                            xs: 24,
                                            className: "p-2",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                className: "btn btn-accent w-full mt-4",
                                                onClick: (e)=>{
                                                    handleSendAllPrint();
                                                },
                                                children: "پرینت صندوق"
                                            })
                                        }) : "",
                                        warehouse ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(antd__WEBPACK_IMPORTED_MODULE_7__.Col, {
                                            md: 12,
                                            lg: 12,
                                            sm: 24,
                                            xs: 24,
                                            className: "p-2",
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                                                href: "/materials",
                                                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("button", {
                                                    className: "btn btn-primary w-full mt-4",
                                                    children: [
                                                        " ",
                                                        "ثبت ورود خروج انبار"
                                                    ]
                                                })
                                            })
                                        }) : ""
                                    ]
                                })
                            })
                        ]
                    })
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PrintersPage);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 102:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "L": () => (/* binding */ getOnlineBranchData)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);

const getOnlineBranchData = ()=>{
    return new Promise((resolve, reject)=>{
        const token = localStorage.getItem("token");
        const branchName = localStorage.getItem("branch_name");
        var data = new FormData();
        data.append("token", token);
        data.append("branch_name", branchName);
        const config = {
            method: "post",
            url: "/get-branch-data",
            data
        };
        axios__WEBPACK_IMPORTED_MODULE_0___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};


/***/ }),

/***/ 4272:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "T0": () => (/* binding */ getPersianDate),
/* harmony export */   "Y4": () => (/* binding */ numberFormat)
/* harmony export */ });
/* unused harmony exports replaceDigitsToEn, jalaliToGregorian, formatDate, p2e, e2p, getTime */
function replaceDigitsToEn(str) {
    let persianNumbers = [
        /۰/g,
        /۱/g,
        /۲/g,
        /۳/g,
        /۴/g,
        /۵/g,
        /۶/g,
        /۷/g,
        /۸/g,
        /۹/g
    ];
    let enNumber = [
        /0/g,
        /1/g,
        /2/g,
        /3/g,
        /4/g,
        /5/g,
        /6/g,
        /7/g,
        /8/g,
        /9/g
    ];
    if (typeof str === "string") {
        for(var i = 0; i < 10; i++){
            str = str.replace(persianNumbers[i], i).replace(enNumber[i], i);
        }
        return str;
    }
    ;
}
const getPersianDate = (date, format)=>{
    let week = new Array("يكشنبه", "دوشنبه", "سه شنبه", "چهارشنبه", "پنج شنبه", "جمعه", "شنبه");
    let months = new Array("فروردين", "ارديبهشت", "خرداد", "تير", "مرداد", "شهريور", "مهر", "آبان", "آذر", "دي", "بهمن", "اسفند");
    let today = new Date();
    if (date) today = new Date(date);
    let d = today.getDay();
    let day = today.getDate();
    let month = today.getMonth() + 1;
    let year = today.getYear();
    let y, i;
    year = window.navigator.userAgent.indexOf("MSIE") > 0 ? year : 1900 + year;
    if (year == 0) {
        year = 2000;
    }
    if (year < 100) {
        year += 1900;
    }
    y = 1;
    for(i = 0; i < 3000; i += 4){
        if (year == i) {
            y = 2;
        }
    }
    for(i = 1; i < 3000; i += 4){
        if (year == i) {
            y = 3;
        }
    }
    if (y == 1) {
        year -= month < 3 || month == 3 && day < 21 ? 622 : 621;
        switch(month){
            case 1:
                day < 21 ? (month = 10, day += 10) : (month = 11, day -= 20);
                break;
            case 2:
                day < 20 ? (month = 11, day += 11) : (month = 12, day -= 19);
                break;
            case 3:
                day < 21 ? (month = 12, day += 9) : (month = 1, day -= 20);
                break;
            case 4:
                day < 21 ? (month = 1, day += 11) : (month = 2, day -= 20);
                break;
            case 5:
            case 6:
                day < 22 ? (month -= 3, day += 10) : (month -= 2, day -= 21);
                break;
            case 7:
            case 8:
            case 9:
                day < 23 ? (month -= 3, day += 9) : (month -= 2, day -= 22);
                break;
            case 10:
                day < 23 ? (month = 7, day += 8) : (month = 8, day -= 22);
                break;
            case 11:
            case 12:
                day < 22 ? (month -= 3, day += 9) : (month -= 2, day -= 21);
                break;
            default:
                break;
        }
    }
    if (y == 2) {
        year -= month < 3 || month == 3 && day < 20 ? 622 : 621;
        switch(month){
            case 1:
                day < 21 ? (month = 10, day += 10) : (month = 11, day -= 20);
                break;
            case 2:
                day < 20 ? (month = 11, day += 11) : (month = 12, day -= 19);
                break;
            case 3:
                day < 20 ? (month = 12, day += 10) : (month = 1, day -= 19);
                break;
            case 4:
                day < 20 ? (month = 1, day += 12) : (month = 2, day -= 19);
                break;
            case 5:
                day < 21 ? (month = 2, day += 11) : (month = 3, day -= 20);
                break;
            case 6:
                day < 21 ? (month = 3, day += 11) : (month = 4, day -= 20);
                break;
            case 7:
                day < 22 ? (month = 4, day += 10) : (month = 5, day -= 21);
                break;
            case 8:
                day < 22 ? (month = 5, day += 10) : (month = 6, day -= 21);
                break;
            case 9:
                day < 22 ? (month = 6, day += 10) : (month = 7, day -= 21);
                break;
            case 10:
                day < 22 ? (month = 7, day += 9) : (month = 8, day -= 21);
                break;
            case 11:
                day < 21 ? (month = 8, day += 10) : (month = 9, day -= 20);
                break;
            case 12:
                day < 21 ? (month = 9, day += 10) : (month = 10, day -= 20);
                break;
            default:
                break;
        }
    }
    if (y == 3) {
        year -= month < 3 || month == 3 && day < 21 ? 622 : 621;
        switch(month){
            case 1:
                day < 20 ? (month = 10, day += 11) : (month = 11, day -= 19);
                break;
            case 2:
                day < 19 ? (month = 11, day += 12) : (month = 12, day -= 18);
                break;
            case 3:
                day < 21 ? (month = 12, day += 10) : (month = 1, day -= 20);
                break;
            case 4:
                day < 21 ? (month = 1, day += 11) : (month = 2, day -= 20);
                break;
            case 5:
            case 6:
                day < 22 ? (month -= 3, day += 10) : (month -= 2, day -= 21);
                break;
            case 7:
            case 8:
            case 9:
                day < 23 ? (month -= 3, day += 9) : (month -= 2, day -= 22);
                break;
            case 10:
                day < 23 ? (month = 7, day += 8) : (month = 8, day -= 22);
                break;
            case 11:
            case 12:
                day < 22 ? (month -= 3, day += 9) : (month -= 2, day -= 21);
                break;
            default:
                break;
        }
    }
    // if (format === null || format === undefined)
    //     return `${year} ${Num2persian(day)} ${months[month - 1]} ${Num2persian(year)}`
    if (format === "y/m/d") return `${year}/${month < 10 ? "0" + month : month}/${day < 10 ? "0" + day : day}`;
    if (format === "d/m/y") return `${day}/${month}/${year}`;
};
function jalaliToGregorian(str) {
    const g_days_in_month = [
        31,
        28,
        31,
        30,
        31,
        30,
        31,
        31,
        30,
        31,
        30,
        31
    ];
    const j_days_in_month = [
        31,
        31,
        31,
        31,
        31,
        31,
        30,
        30,
        30,
        30,
        30,
        29
    ];
    let date = str.split("/");
    let j_y = parseInt(date[0]);
    let j_m = parseInt(date[1]);
    let j_d = parseInt(date[2]);
    var jy = j_y - 979;
    var jm = j_m - 1;
    var jd = j_d - 1;
    var j_day_no = 365 * jy + parseInt(jy / 33) * 8 + parseInt((jy % 33 + 3) / 4);
    for(var i = 0; i < jm; ++i)j_day_no += j_days_in_month[i];
    j_day_no += jd;
    var g_day_no = j_day_no + 79;
    var gy = 1600 + 400 * parseInt(g_day_no / 146097); /* 146097 = 365*400 + 400/4 - 400/100 + 400/400 */ 
    g_day_no = g_day_no % 146097;
    var leap = true;
    if (g_day_no >= 36525) /* 36525 = 365*100 + 100/4 */ {
        g_day_no--;
        gy += 100 * parseInt(g_day_no / 36524); /* 36524 = 365*100 + 100/4 - 100/100 */ 
        g_day_no = g_day_no % 36524;
        if (g_day_no >= 365) g_day_no++;
        else leap = false;
    }
    gy += 4 * parseInt(g_day_no / 1461); /* 1461 = 365*4 + 4/4 */ 
    g_day_no %= 1461;
    if (g_day_no >= 366) {
        leap = false;
        g_day_no--;
        gy += parseInt(g_day_no / 365);
        g_day_no = g_day_no % 365;
    }
    for(var i = 0; g_day_no >= g_days_in_month[i] + (i == 1 && leap); i++)g_day_no -= g_days_in_month[i] + (i == 1 && leap);
    var gm = i + 1;
    var gd = g_day_no + 1;
    gm = gm < 10 ? "0" + gm : gm;
    gd = gd < 10 ? "0" + gd : gd;
    return gy + "-" + gm + "-" + gd;
}
function formatDate(date) {
    var d = new Date(date), month = "" + (d.getMonth() + 1), day = "" + d.getDate(), year = d.getFullYear();
    if (month.length < 2) month = "0" + month;
    if (day.length < 2) day = "0" + day;
    return [
        year,
        month,
        day
    ].join("-");
}
const p2e = (s)=>s.replace(/[۰-۹]/g, (d)=>"۰۱۲۳۴۵۶۷۸۹".indexOf(d));
const e2p = (s)=>s.replace(/\d/g, (d)=>"۰۱۲۳۴۵۶۷۸۹"[d]);
function numberFormat(price) {
    let formattedPrice = price ? price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") : 0;
    return formattedPrice;
}
const getTime = ()=>{
    const date = new Date().toLocaleDateString("fa-IR").replace("،", " ").replace(/([۰-۹])/g, (token)=>String.fromCharCode(token.charCodeAt(0) - 1728));
    const time = new Date().toLocaleTimeString("fa-IR").replace("،", " ").replace(/([۰-۹])/g, (token)=>String.fromCharCode(token.charCodeAt(0) - 1728));
    return [
        p2e(date),
        p2e(time)
    ];
};


/***/ })

};
;