"use strict";
exports.id = 890;
exports.ids = [890];
exports.modules = {

/***/ 890:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EJ": () => (/* binding */ maskm),
/* harmony export */   "HJ": () => (/* binding */ cartTotalTax),
/* harmony export */   "Kf": () => (/* binding */ cartTotalPrice),
/* harmony export */   "Oe": () => (/* binding */ parseInputValue),
/* harmony export */   "T4": () => (/* binding */ formatPrice),
/* harmony export */   "Y4": () => (/* binding */ numberFormat),
/* harmony export */   "a0": () => (/* binding */ cartTotalPrice2),
/* harmony export */   "gz": () => (/* binding */ roundFinalPrice)
/* harmony export */ });
/* unused harmony exports formatPrice2, p2e, e2p */
function formatPrice(price) {
    // console.log(price);
    price *= 10;
    let formattedPrice = price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice + " ریال";
}
function formatPrice2(price) {
    price = price;
    let price2 = price.toFixed();
    let formattedPrice = price2.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice;
}
function cartTotalPrice(cart, tax) {
    let totalPrice = cart.map((item)=>item.product.price * item.count).reduce((prev, next)=>prev + next, 0);
    if (tax === "1") {
        const noVat = cart.map((item)=>item.product.vat_include == 1 ? item.product.price * item.count : 0).reduce((prev, next)=>prev + next, 0);
        let final = totalPrice - noVat;
        let vat_percent = localStorage.getItem("vat_percent");
        vat_percent = vat_percent ? parseFloat(vat_percent) : 0.1;
        let taxPrice = final * vat_percent;
        totalPrice += taxPrice;
    }
    let finalPrice = formatPrice(roundFinalPrice(totalPrice));
    return finalPrice;
}
function roundFinalPrice(totalPrice, show_zero = false) {
    let text = totalPrice.toFixed();
    let replacement = "00";
    let result = text.substring(0, text.length - 2) + replacement;
    let finalPrice = parseInt(result);
    if (finalPrice == 0 && !show_zero) finalPrice = .1;
    return finalPrice;
}
function cartTotalPrice2(cart) {
    const totalPrice = cart.map((item)=>item.product.price * item.count).reduce((prev, next)=>prev + next, 0);
    return totalPrice;
}
function cartTotalTax(totalPrice, tax, tip, cart) {
    const noVat = cart.map((item)=>item.product.vat_include == 1 ? item.product.price * item.count : 0).reduce((prev, next)=>prev + next, 0);
    if (tip) totalPrice -= parseInt(tip);
    totalPrice -= noVat;
    if (tax !== "1") return 0;
    let vat_percent = localStorage.getItem("vat_percent");
    vat_percent = vat_percent ? parseFloat(vat_percent) : 0.1;
    let taxPrice = totalPrice * vat_percent;
    taxPrice = taxPrice;
    return Math.round(taxPrice);
}
const p2e = (s)=>s.replace(/[۰-۹]/g, (d)=>"۰۱۲۳۴۵۶۷۸۹".indexOf(d));
const e2p = (s)=>s.replace(/\d/g, (d)=>"۰۱۲۳۴۵۶۷۸۹"[d]);
const parseInputValue = (value, number = false)=>{
    if (value) {
        value = p2e(value);
        if (/\D/g.test(value) && number) {
            value = value.replace(/[^0-9.-]/g, "");
        }
        return value;
    }
    return value;
};
function numberFormat(price) {
    let formattedPrice = price ? price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") : "";
    return formattedPrice;
}
function maskm(val) {
    val = p2e(val).replace(/\D/g, "");
    val = val.replace(/,/g, "");
    val = numberFormat(val);
    return val;
}


/***/ })

};
;