"use strict";
exports.id = 749;
exports.ids = [749];
exports.modules = {

/***/ 7258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// export default "http://192.168.1.103:3000"
// export default "http://192.168.1.4:3000"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("http://localhost:3000");


/***/ }),

/***/ 767:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$": () => (/* binding */ useProductContext),
/* harmony export */   "M": () => (/* binding */ ProductsStateContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const ProductsStateContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
    menuItems: [
        {
            id: 0,
            name: "",
            img: "",
            isCat: true
        }
    ],
    setMenuItems: ()=>{},
    order: [
        {
            product: {
                name: "",
                id: 0
            },
            count: 1
        }
    ],
    setOrder: ()=>{},
    offline: false,
    setOffline: ()=>{},
    offlineBills: 0,
    setOfflineBills: ()=>{},
    token: null,
    setToken: ()=>{},
    setCatItems: ()=>{},
    catItems: [
        {
            id: 0,
            name: "",
            img: "",
            isCat: true
        }
    ],
    detailEditOrder: {},
    setDetailEditOrder: ()=>{},
    tableId: "",
    setTableId: ()=>{},
    repeatPrinting: false,
    setRepeatPrinting: ()=>{},
    loader: false,
    setLoader: ()=>{},
    warehouse: true,
    tax: "0",
    setTax: ()=>{},
    branchName: "",
    setBranchName: ()=>{},
    interval: ()=>{},
    refresh: "0",
    setRefresh: ()=>{}
});
const useProductContext = ()=>(0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ProductsStateContext);


/***/ }),

/***/ 3130:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VZ": () => (/* binding */ getPrinters)
/* harmony export */ });
/* unused harmony exports requestPrintOffline, requestPrint */
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _baseU_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7258);


const requestPrintOffline = (order)=>{
    return new Promise((resolve, reject)=>{
        // console.log(order)
        resolve("Thanks");
    });
};
const requestPrint = (order)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: basUrl,
            url: "/print",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(order)
        };
        axios(config).then(function(response) {
            if (response.data.success) {
                resolve(response.data);
            } else reject();
        }).catch(function(error) {
            reject();
        });
    });
};
const getPrinters = ()=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "get",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z,
            url: "/getprinters",
            headers: {}
        };
        axios__WEBPACK_IMPORTED_MODULE_0___default()(config).then(function(response) {
            if (!response.data) {
                //   setIsError(true)
                return reject();
            }
            if (response.data.printers.length === 0) {
                return reject;
            } else {
                // console.log(response.data)
                let printersArr = [];
                response.data.printers.forEach((p)=>{
                    let printer = {
                        name: p.name
                    };
                    printersArr.push(printer);
                });
                // console.log(printersArr)
                resolve(printersArr);
            }
        }).catch(function(error) {
            console.log(error);
            // setIsError(true)
            reject();
        });
    });
};


/***/ }),

/***/ 2145:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Q5": () => (/* binding */ printAllOrders),
/* harmony export */   "QS": () => (/* binding */ removeOrder),
/* harmony export */   "Wy": () => (/* binding */ createOrderData),
/* harmony export */   "a_": () => (/* binding */ findOrder),
/* harmony export */   "d": () => (/* binding */ submitOrderOffline),
/* harmony export */   "hY": () => (/* binding */ saveBranch),
/* harmony export */   "hn": () => (/* binding */ setOrderStatus),
/* harmony export */   "jy": () => (/* binding */ getCustomer),
/* harmony export */   "oq": () => (/* binding */ saveOrderOffline),
/* harmony export */   "vs": () => (/* binding */ getTableList),
/* harmony export */   "yb": () => (/* binding */ getOnlineOrderData)
/* harmony export */ });
/* unused harmony exports submitOrder, saveBill5 */
/* harmony import */ var helpers_printer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3130);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _baseU_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7258);




const getCustomer = (token, query, searchWithId = 0)=>{
    return new Promise((resolve, reject)=>{
        var data = new FormData();
        data.append("token", token);
        var config = {
            method: "post",
            url: `/check-user?q=${query}&point=${1}&search_with_id=${searchWithId}&is_seperate_name=1`,
            data: data
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data["results"]);
        }).catch(function(error) {
            // console.log(error)
            reject();
        });
    });
};
const submitOrderOffline = (order, customer, totalAmount, printers, offline_id, custom_print_valuet, raw_items, table_id, factorID, discount, print_type, p_bill, p_bar, phone, note, numPeople, borderSize, fontSize, pageWidth, service, reprint, tip, taxPrice, loviuna, branchData, isOnline, customFields)=>{
    let no_brand = "";
    let branchName = "";
    let custom_note = "";
    if (!branchData) {
        no_brand = localStorage.getItem("no_brand");
        if (!no_brand) no_brand = "0";
        branchName = localStorage.getItem("branch_name");
        if (localStorage.getItem("custom_note")) custom_note = localStorage.getItem("custom_note");
    } else {
        no_brand = branchData["no_brand"];
        branchName = branchData["branchName"];
        custom_note = branchData["custom_note"] ? branchData["custom_note"] : "";
    }
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
            url: "submit-order",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                order,
                customer,
                totalAmount,
                printers,
                offline_id,
                custom_print_valuet,
                raw_items,
                table_id,
                factorID,
                discount,
                print_type,
                p_bill,
                p_bar,
                phone,
                note,
                numPeople,
                borderSize,
                fontSize,
                pageWidth,
                service,
                reprint,
                tip,
                taxPrice,
                loviuna,
                no_brand,
                branchName,
                isOnline,
                custom_note,
                customFields
            })
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            // console.log(response.data)
            resolve(response.data);
        }).catch((error)=>{
            console.log(error);
            reject(error);
        });
    });
};
const saveOrderOffline = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
            url: "api/create",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const findOrder = (req, one)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
            url: "api/find" + (one == 1 ? "?one=1" : ""),
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const saveBranch = (req)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
            url: "api/branch",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify(req)
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const submitOrder = (order, token, customer, note, tableId, orderTypeDefault, paymentTypeDefault, usePoint, useDiscount, customerNote, noCustomer, orderId, numPeople)=>{
    return new Promise((resolve, reject)=>{
        let cart = [];
        order.forEach((item)=>{
            cart.push({
                id: item.product.id,
                options: item.product.options,
                qty: item.count,
                note: item.note
            });
        });
        let finalOrder = {
            cart,
            user_id: customer.id === 0 ? customer.name : customer.id
        };
        var data = new FormData();
        data.append("token", token);
        data.append("cart", JSON.stringify(finalOrder));
        data.append("note", note);
        data.append("table_id", tableId);
        data.append("order_type_default", orderTypeDefault);
        data.append("payment_type", paymentTypeDefault);
        data.append("usePoint", usePoint);
        data.append("useDiscount", useDiscount.id);
        data.append("customer_note", customerNote);
        data.append("noCustomer", noCustomer.toString());
        data.append("order_id", orderId == 0 ? "" : orderId);
        data.append("numPeople", numPeople ? numPeople : "");
        var config = {
            method: "post",
            url: "/submit-order",
            data: data
        };
        axios(config).then(function(response) {
            const printers = response.data.print_list;
            const printerBehave = localStorage.getItem("printer_behave_default");
            if (response.data.msg) {
                // alert(response.data.msg)
                toast.error(response.data.msg, {
                    position: "bottom-right",
                    style: {
                        direction: "rtl",
                        fontFamily: "IRANSansX"
                    },
                    theme: "colored"
                });
            }
            let printersArr = [];
            // console.log(printers);
            if (!printers) return reject();
            Object.keys(printers).forEach((node)=>{
                let printer = localStorage.getItem(node);
                let printerNode = printers[node];
                // Management of individual printers
                const custom_print_valuet = JSON.parse(localStorage.getItem("custom_print_valuet") || "[]");
                const raw_items = JSON.parse(localStorage.getItem("raw_items"));
                if (custom_print_valuet[node] && custom_print_valuet[node].cat) {
                    let PO = [];
                    order.map((item, i)=>{
                        if (custom_print_valuet[node].cat.includes(raw_items[item.product.id].category_id.toString())) {
                            PO.push(i);
                        }
                    });
                    if (PO.length == 0) {
                        return;
                    }
                }
                if (!printer) {
                // router.push('/printers')
                } else {
                    //print behave
                    if (printerBehave == "بدون پرینت") {}
                    if (printerBehave == "پرینت باریستا") {
                        if (printerNode.type == "bar_all") {
                            printersArr.push({
                                id: node,
                                name: printer,
                                page: printerNode.path
                            });
                        }
                    }
                    if (printerBehave == "پرینت مشتری و باریستا") {
                        printersArr.push({
                            id: node,
                            name: printer,
                            page: printerNode.path
                        });
                    }
                }
            });
            if (printerBehave != "بدون پرینت" && printersArr.length) {
                const printOrder = {
                    printers: printersArr,
                    orderId: response.data.order_id,
                    billUrl: printersArr[0].page,
                    totalItems: response.data.item.length
                };
                requestPrint(printOrder).then((resp)=>{
                    resolve(resp);
                }).catch((err)=>{
                    reject(err);
                });
            } else {
                resolve("ok");
            }
        }).catch(function(error) {
            console.log("catch");
            reject();
        });
    });
};
const saveBill5 = (printer_id, pinter_name, pdf_url, status, orderId)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: basUrl,
            url: "print1",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                printer_id,
                pinter_name,
                pdf_url,
                status,
                orderId
            })
        };
        axios(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const getTableList = ()=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        const config = {
            method: "post",
            url: "/table?offline=1",
            data
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function({ data  }) {
            resolve(data.table_list);
        }).catch((error)=>reject(error));
    });
};
const getOnlineOrderData = (order_id, action = null)=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        const config = {
            method: "post",
            url: action ? "/get-order-data2" : "/get-order-data",
            data
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const createOrderData = (order)=>{
    let raw_items = localStorage.getItem("raw_items") || "[]";
    raw_items = JSON.parse(raw_items);
    let newOrder = [];
    Object.keys(order["items"]).map((item)=>{
        let id_item = item.split("_")[0];
        let options = [];
        if (order["items"][item]["options"] != null) {
            const opts = JSON.parse(order["items"][item]["options"] || "[]");
            for (const opt of opts){
                options.push({
                    id: opt,
                    name: raw_items[opt]["name"],
                    price: raw_items[opt]["last_price"] * 1000,
                    image: ""
                });
            }
        }
        newOrder = [
            ...newOrder,
            {
                product: {
                    name: `${options.length ? `${raw_items[id_item].name}(${options.map((opt)=>opt.name).join("-")})` : raw_items[id_item].name}`,
                    baseName: raw_items[id_item].name,
                    id: Number(id_item),
                    price: (options.length ? options.map((i)=>i.price).reduce((accumulator, curr)=>accumulator + curr) + raw_items[id_item].last_price : raw_items[id_item].last_price) * 1000,
                    options: options,
                    vat_include: raw_items[id_item].vat_include,
                    unique: `${id_item}-${options.length ? `${raw_items[id_item].name}(${options.map((opt)=>opt.name).join("-")})` : raw_items[id_item].name}`
                },
                count: order["items"][item]["qty"],
                note: order["items"][item]["note"] ? order["items"][item]["note"] : "",
                custom_fields: order?.["order"]?.["custom"] || null
            }, 
        ];
    });
    return newOrder;
};
const setOrderStatus = (order_id, status)=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        data.append("status", status);
        const config = {
            method: "post",
            url: "/set-order-status",
            data
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const removeOrder = (order_id)=>{
    return new Promise((resolve, reject)=>{
        const client_id = localStorage.getItem("user_client_id");
        const token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        const config = {
            method: "post",
            url: "/remove-order",
            data
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};
const printAllOrders = (orders, pageWidth, startDate, endDate, borderSize, fontSize, totalAmount, printers)=>{
    return new Promise((resolve, reject)=>{
        const config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
            url: "print-all-order",
            // url: "api/test",
            headers: {
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                orders,
                pageWidth,
                startDate,
                endDate,
                borderSize,
                fontSize,
                totalAmount,
                printers
            })
        };
        axios__WEBPACK_IMPORTED_MODULE_1___default()(config).then(function(response) {
            resolve(response.data);
        }).catch((error)=>reject(error));
    });
};


/***/ })

};
;