"use strict";
exports.id = 422;
exports.ids = [422];
exports.modules = {

/***/ 5422:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Cn": () => (/* binding */ removeItemFromCart),
/* harmony export */   "G": () => (/* binding */ getChildren),
/* harmony export */   "Sg": () => (/* binding */ removeItemsFromCart),
/* harmony export */   "V": () => (/* binding */ updateOrderNote),
/* harmony export */   "X$": () => (/* binding */ saveItemsOffline),
/* harmony export */   "Z$": () => (/* binding */ getChildrenOffline),
/* harmony export */   "dm": () => (/* binding */ addItemToCart),
/* harmony export */   "r0": () => (/* binding */ GetCurrentPageUpdate)
/* harmony export */ });
/* unused harmony exports replaceSecondChar, getMenu */
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _baseU_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7258);



const replaceSecondChar = (word)=>{
    var t = 0;
    word = word.replace(/ /g, function(match) {
        t++;
        return t === 2 ? "-" : match;
    });
    return word;
};
const removeItemFromCart = (unique, orders)=>{
    orders.some((item, idx)=>{
        if (item.product.unique === unique) {
            --orders[idx].count;
            if (orders[idx].count <= 0) {
                orders.splice(idx, 1);
            }
            return;
        }
    });
    return orders;
};
const updateOrderNote = (unique, orders, note)=>{
    orders.some((item, idx)=>{
        if (item.product.unique === unique) {
            orders[idx].note = note;
            return;
        }
    });
    return orders;
};
const addItemToCart = (unique, orders)=>{
    orders.some((item, idx)=>{
        if (item.product.unique === unique) {
            ++orders[idx].count;
            return;
        }
    });
    return orders;
};
const removeItemsFromCart = (unique, orders)=>{
    orders.some((item, idx)=>{
        if (item.product.unique === unique) {
            orders.splice(idx, 1);
            return;
        }
    });
    return orders;
};
const getChildrenOffline = (parentId)=>{
    return new Promise((resolve, reject)=>{
        let subItems = [];
        const localItems = localStorage.getItem(`level${parentId}`);
        if (!localItems) {
            reject("local data does not exists");
        } else {
            subItems = JSON.parse(localItems);
            return resolve(subItems);
        }
    });
};
const GetCurrentPageUpdate = (parentId, token)=>{
    return new Promise((resolve, reject)=>{
        const brancId = localStorage.getItem("user_client_id");
        const query = parentId === 0 ? `?branch_id=${brancId}` : `?parent_id=${parentId}&branch_id=${brancId}`;
        const data = new FormData();
        data.append("token", token);
        axios__WEBPACK_IMPORTED_MODULE_0___default()({
            method: "POST",
            url: `/category${query}`,
            data
        }).then((resp)=>{
            if (resp) resolve(resp.data.last_update);
        }).catch((err)=>reject(err));
    });
};
const saveItemsOffline = (subItems, parentId, lastUpdate)=>{
    return new Promise((resolve, reject)=>{
        // save items locally
        var data = JSON.stringify(subItems);
        var config = {
            method: "post",
            baseURL: _baseU_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z,
            url: "/save",
            headers: {
                "Content-Type": "application/json"
            },
            data: data
        };
        axios__WEBPACK_IMPORTED_MODULE_0___default()(config).then(function(response) {
            // subItems.forEach((item: IMenuItem) => {
            //   item.img = `/images/products/${item.id}.jpeg`;
            // });
            return resolve(subItems);
        }).catch(function(error) {
            reject(error);
        });
    });
};
const getChildren = async (parentId, token)=>{
    return new Promise((resolve, reject)=>{
        let subItems = [];
        // Let's fetch the items from viuna server
        const brancId = localStorage.getItem("user_client_id");
        const query = parentId === 0 ? `?branch_id=${brancId}` : `?parent_id=${parentId}&branch_id=${brancId}`;
        const data = new FormData();
        data.append("token", token);
        axios__WEBPACK_IMPORTED_MODULE_0___default()({
            method: "POST",
            url: `/category${query}`,
            data
        }).then((resp)=>{
            if (resp.data.length <= 0) {
                reject("no data");
            }
            // normalizing subItems array
            Object.keys(resp.data).forEach((item)=>{
                if (item !== "items" && item !== "last_update") {
                    // it's a category
                    subItems.push({
                        ...resp.data[item],
                        id: item,
                        parent: parentId,
                        isCat: true
                    });
                } else if (item === "items") {
                    // it's a product
                    const products = resp.data[item];
                    Object.keys(products).forEach((id)=>{
                        subItems.push({
                            ...products[id],
                            id,
                            parent: parentId,
                            isCat: false
                        });
                    });
                }
            });
            const result = {
                items: subItems,
                last_update: resp.data.last_update
            };
            resolve(result);
        }).catch((err)=>{
            // console.log(err)
            return reject(err);
        });
    });
};
const saveItems = async (data, id, last_update)=>{
    localStorage.setItem(`level${id}`, JSON.stringify(data));
    localStorage.setItem(`date${id}`, String(last_update));
};
const getMenu = async (token)=>{
    return new Promise((resolve, reject)=>{
        const brancId = localStorage.getItem("user_client_id");
        const data = new FormData();
        data.append("token", token);
        axios({
            method: "POST",
            url: `${apiUrl[0]}/restapi/category?branch_id=${brancId}`,
            data
        }).then((resp)=>{
            let res = resp.data;
            let items = res["items"];
            let cats = res["cats"];
            // if (items) {
            //   for (const key in items) {
            //     saveItems(items[key], false, key, 0, res["last_update"]);
            //   }
            // }
            if (items) {
                let level0 = [];
                for(const key in cats){
                    let item = cats[key]["item"];
                    let child = [];
                    for(const k in item){
                        child.push({
                            ...item[k],
                            parent: key,
                            isCat: false,
                            id: k
                        });
                    }
                    saveItems(child, key, res["last_update"]);
                    delete cats[key]["item"];
                    level0.push({
                        ...cats[key],
                        parent: 0,
                        isCat: true,
                        id: key
                    });
                }
                saveItems(level0, 0, res["last_update"]);
            }
            resolve(true);
        }).catch((err)=>{
            // console.log(err)
            return reject(err);
        });
    });
};


/***/ })

};
;