"use strict";
exports.id = 11;
exports.ids = [11];
exports.modules = {

/***/ 3011:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ components_Menu)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "clsx"
var external_clsx_ = __webpack_require__(8103);
var external_clsx_default = /*#__PURE__*/__webpack_require__.n(external_clsx_);
// EXTERNAL MODULE: ./helpers/check-items.ts
var check_items = __webpack_require__(5422);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
var link_default = /*#__PURE__*/__webpack_require__.n(next_link);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(1853);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: ./components/Products.ts
var Products = __webpack_require__(767);
// EXTERNAL MODULE: external "react-toastify"
var external_react_toastify_ = __webpack_require__(1187);
;// CONCATENATED MODULE: ./components/shared/addToOrder.ts

const addToOrder = (e, isCat, onSelect, data, order, id, setOrder, price, name, count)=>{
    // console.log(data)
    if (price > 0) price *= 1000;
    let noAdd = false;
    if (e != false && data.option?.length != 0) {
        document.querySelectorAll(`#i${id} *`).forEach((item)=>{
            if (e.target == item) noAdd = true;
        });
    }
    if (noAdd) return;
    if (isCat) {
        onSelect(data);
    } else {
        const isDuplicateOrder = order.some((item, idx)=>{
            if (item.product.id === Number(id) && Object.keys(item.product.options).length === 0) {
                let garbage = [
                    ...order
                ];
                ++garbage[idx].count;
                setOrder([
                    ...garbage
                ]);
                return true;
            }
            return false;
        });
        if (!isDuplicateOrder) {
            setOrder([
                ...order,
                {
                    product: {
                        name,
                        baseName: name,
                        id: Number(id),
                        price,
                        options: [],
                        unique: `${id}-${name}`,
                        vat_include: data["vat_include"]
                    },
                    count: count
                }, 
            ]);
        }
        (0,external_react_toastify_.toast)("محصول به سبد خرید اضافه شد .", {
            position: "bottom-right",
            type: "success",
            style: {
                direction: "rtl",
                fontFamily: "IRANSansX"
            },
            theme: "colored"
        });
    }
};

;// CONCATENATED MODULE: ./components/AddToOrderButton.tsx



function AddToOrderButton({ isCat , onSelect , data , order , id , setOrder , price , name , noClick =false  }) {
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
            className: "mr-4 cursor-pointer hover:text-yellow-400",
            onClick: ()=>noClick ? void 0 : addToOrder(false, isCat, onSelect, data, order, id, setOrder, price, name, 1),
            children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                xmlns: "http://www.w3.org/2000/svg",
                className: "h-8 w-8",
                fill: "none",
                viewBox: "0 0 24 24",
                stroke: "currentColor",
                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                    strokeLinecap: "round",
                    strokeLinejoin: "round",
                    strokeWidth: 2,
                    d: "M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"
                })
            })
        })
    });
}
/* harmony default export */ const components_AddToOrderButton = (AddToOrderButton);

;// CONCATENATED MODULE: ./components/Option.tsx


function Option({ option , setSelectedOptions , selectedOptions , withImage =false  }) {
    const isOptionSelected = ()=>{
        return selectedOptions.filter((selectedOption)=>selectedOption.id === option.id && selectedOption.name === option.name).length;
    };
    const onOptionClick = ()=>{
        if (!isOptionSelected()) {
            setSelectedOptions([
                ...selectedOptions,
                option
            ]);
        } else {
            const newSelectedOptions = selectedOptions.filter((selectedOption)=>{
                //TODO refactor when backend option ids has been changed
                if (selectedOption.name !== option.name) {
                    return true;
                }
            });
            setSelectedOptions(newSelectedOptions);
        }
    };
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("li", {
            className: isOptionSelected() ? "bg-green-500 text-white" : "bg-white",
            onClick: ()=>onOptionClick(),
            style: {
                fontSize: "0.8rem"
            },
            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("a", {
                className: `active:bg-yellow-500 flex justify-between`,
                style: {
                    padding: "8px"
                },
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        children: option.name
                    }),
                    option.price ? /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "rounded-md bg-yellow-200",
                        style: {
                            padding: "3px 6px"
                        },
                        children: option.price
                    }) : ""
                ]
            })
        })
    });
}
/* harmony default export */ const components_Option = (Option);

;// CONCATENATED MODULE: ./components/AdditionalOptionsMenu.tsx




function AdditionalOptionsMenu({ data , withImage =false , idel  }) {
    const { setOrder , order  } = (0,Products/* useProductContext */.$)();
    const { 0: selectedOptions , 1: setSelectedOptions  } = (0,external_react_.useState)([]);
    const generateName = ()=>{
        if (selectedOptions.length) {
            return `${data.name}(${selectedOptions.map((option)=>option.name).join("-")})`;
        }
        return data.name;
    };
    const generatePrice = ()=>{
        let optionsPrice = 0;
        selectedOptions.map((option)=>{
            if (option.price) {
                optionsPrice = Number(option.price) + Number(optionsPrice);
            }
        });
        let price = Number(data.price) + optionsPrice;
        if (price > 0) price *= 1000;
        return price;
    };
    const setOptionalOrder = ()=>{
        const isDuplicateOrder = order.some((item, idx)=>{
            // if (item.product.id === Number(data.id) && item.product.options == selectedOptions) {
            if (item.product.unique === `${data.id}-${generateName()}`) {
                let garbage = [
                    ...order
                ];
                ++garbage[idx].count;
                setOrder([
                    ...garbage
                ]);
                return true;
            }
            return false;
        });
        if (!isDuplicateOrder) {
            setOrder([
                ...order,
                {
                    product: {
                        name: generateName(),
                        baseName: data.name,
                        id: Number(data.id),
                        price: generatePrice(),
                        options: selectedOptions,
                        unique: `${data.id}-${generateName()}`
                    },
                    count: 1
                }, 
            ]);
        }
        setSelectedOptions([]);
    };
    return /*#__PURE__*/ jsx_runtime_.jsx(external_react_.Fragment, {
        children: data.option?.length ? /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
            className: "dropdown",
            id: `i${idel}`,
            children: [
                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    tabIndex: 0,
                    className: "mx-4 cursor-pointer hover:text-yellow-500",
                    children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                        xmlns: "http://www.w3.org/2000/svg",
                        className: "h-8 w-8",
                        fill: "none",
                        viewBox: "0 0 24 24",
                        stroke: "currentColor",
                        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                            strokeLinecap: "round",
                            strokeLinejoin: "round",
                            strokeWidth: 2,
                            d: "M4 6h16M4 12h16M4 18h16"
                        })
                    })
                }),
                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("ul", {
                    tabIndex: 0,
                    className: "menu dropdown-content py-3 w-52 shadow-lg bg-base-100 rounded-box",
                    style: {
                        zIndex: 1000
                    },
                    children: [
                        data.option?.map((option, idx)=>{
                            return /*#__PURE__*/ jsx_runtime_.jsx(components_Option, {
                                option: option,
                                setSelectedOptions: setSelectedOptions,
                                selectedOptions: selectedOptions,
                                withImage: withImage
                            }, idx);
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx("li", {
                            className: "border-t-2",
                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("button", {
                                tabIndex: 0,
                                className: "flex justify-center items-center bg-yellow-300 hover:bg-yellow-400 shadow h-10 mt-2 text-gray-700",
                                onClick: ()=>setOptionalOrder(),
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                        className: "ml-1",
                                        style: {
                                            fontSize: "0.8rem"
                                        },
                                        children: "ثبت در سفارش"
                                    }),
                                    /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                        xmlns: "http://www.w3.org/2000/svg",
                                        className: "h-6 w-6",
                                        fill: "none",
                                        viewBox: "0 0 24 24",
                                        stroke: "currentColor",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                            strokeLinecap: "round",
                                            strokeLinejoin: "round",
                                            strokeWidth: 2,
                                            d: "M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"
                                        })
                                    })
                                ]
                            })
                        })
                    ]
                })
            ]
        }) : ""
    });
}
/* harmony default export */ const components_AdditionalOptionsMenu = (AdditionalOptionsMenu);

;// CONCATENATED MODULE: ./components/TextMenuItem.tsx






function classNames(...classes) {
    return classes.filter(Boolean).join(" ");
}
const TextMenuItem = ({ data , index , onSelect  })=>{
    const { name , isCat , price , id  } = data;
    const { setOrder , order  } = (0,Products/* useProductContext */.$)();
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: classNames("relative group bg-white px-4 py-2 focus-within:ring-2 focus-within:ring-inset focus-within:ring-indigo-500", isCat ? "bg-yellow-100 " : ""),
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("div", {}),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "h-full",
                children: isCat ? /*#__PURE__*/ jsx_runtime_.jsx("h3", {
                    className: "text-lg font-medium cursor-pointer h-full",
                    onClick: ()=>onSelect(data),
                    children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "flex justify-between items-center h-full",
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                            style: {
                                fontSize: "0.9rem"
                            },
                            className: "flex",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    className: "border-l pl-2 text-gray-500 text-baseline border-black ml-4",
                                    children: index + 1
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    className: "ltr",
                                    style: {
                                        textAlign: "right"
                                    },
                                    children: name
                                })
                            ]
                        })
                    })
                }) : /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                    children: /*#__PURE__*/ jsx_runtime_.jsx("h3", {
                        className: "text-lg font-medium",
                        onClick: (e)=>addToOrder(e, isCat, onSelect, data, order, id, setOrder, price, name, 1),
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex justify-between items-center",
                            children: [
                                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("span", {
                                    style: {
                                        fontSize: "0.9rem"
                                    },
                                    className: "flex",
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                            className: "border-l pl-2 text-gray-500 text-baseline border-black ml-4",
                                            children: index + 1
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                            className: "ltr",
                                            style: {
                                                textAlign: "right"
                                            },
                                            children: name
                                        })
                                    ]
                                }),
                                isCat ? "" : /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                    className: "flex justify-center items-center",
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx(components_AdditionalOptionsMenu, {
                                            data: data,
                                            idel: id
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                            className: "rounded-md bg-yellow-400",
                                            style: {
                                                padding: "3px 6px",
                                                fontSize: "0.9rem"
                                            },
                                            children: price
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx(components_AddToOrderButton, {
                                            noClick: true,
                                            order: order,
                                            setOrder: setOrder,
                                            onSelect: onSelect,
                                            id: id,
                                            name: name,
                                            data: data,
                                            isCat: isCat,
                                            price: price
                                        })
                                    ]
                                })
                            ]
                        })
                    })
                })
            })
        ]
    }, index);
};
/* harmony default export */ const components_TextMenuItem = (TextMenuItem);

;// CONCATENATED MODULE: ./components/TextMenu.tsx



function TextMenu({ menuItems , onSelectCategory  }) {
    return /*#__PURE__*/ jsx_runtime_.jsx("div", {
        className: "rounded-lg mx-auto max-w-7xl bg-gray-200 shadow divide-y divide-gray-200 grid grid-cols-1 sm:divide-y-0 sm:grid sm:grid-cols-2 xl:grid-cols-3 sm:gap-px mb-20",
        children: menuItems.map((menuItem, index)=>/*#__PURE__*/ jsx_runtime_.jsx(components_TextMenuItem, {
                data: menuItem,
                index: index,
                onSelect: onSelectCategory
            }, index))
    });
}
/* harmony default export */ const components_TextMenu = (TextMenu);

// EXTERNAL MODULE: ./components/contexts/simpleContext.ts
var simpleContext = __webpack_require__(4373);
// EXTERNAL MODULE: ./services/table.ts
var table = __webpack_require__(3954);
;// CONCATENATED MODULE: ./components/Menu.tsx










const Menu = ({ title  })=>{
    const { 0: errorMessage , 1: setErrorMessage  } = (0,external_react_.useState)("امکان خواندن اطلاعات از سرور وجود ندارد");
    const { 0: showErrBtn , 1: setShowErrBtn  } = (0,external_react_.useState)(false);
    const { 0: isError , 1: setIsError  } = (0,external_react_.useState)(false);
    const { 0: reloadItems , 1: setReloadItems  } = (0,external_react_.useState)(false);
    const { setListMode , listMode  } = (0,simpleContext/* simpleContext */.O)();
    (0,external_react_.useEffect)(()=>{
        setListMode(localStorage.getItem("list_mode") ? localStorage.getItem("list_mode") : "text");
    }, []);
    (0,external_react_.useEffect)(()=>{
        localStorage.setItem("list_mode", listMode);
    }, [
        listMode
    ]);
    const { menuItems , setMenuItems , setCatItems , catItems , token , offline  } = (0,Products/* useProductContext */.$)();
    const router = (0,router_.useRouter)();
    const onSelectCategory = (item)=>{
        setMenuItems([]);
        setCatItems([]);
        router.push(`/${item.parent}/${item.id}`);
    };
    const isMainPage = router.query.parentId ? false : true;
    const saveImportantData = ()=>{
        let s = localStorage.getItem("salon");
        if (!s || s == "null") {
            (0,table/* getTable2 */.Lh)().then((r)=>{
                localStorage.setItem("salon", JSON.stringify(r));
            });
        }
        if (!localStorage.getItem("tables")) {
            (0,table/* getTable */.hC)().then((data)=>{
                localStorage.setItem("tables", JSON.stringify(data));
            }).catch((err)=>{});
        }
        if (!localStorage.getItem("raw_items")) {
            (0,table/* getRawItems */.TZ)().then((res)=>{
                localStorage.setItem("raw_items", JSON.stringify(res));
            }).catch((err)=>{
                localStorage.setItem("raw_items", localStorage.getItem("raw_items") || "{}");
            });
        }
    };
    const generateItems = async (loadId)=>{
        // console.log('loading items')
        if (offline) {
            // console.log('Offline mode is ON, force loading items offline')
            (0,check_items/* getChildrenOffline */.Z$)(0).then((resp)=>{
                setIsError(false);
                setCatItems(resp);
            }).catch((err)=>{
                setShowErrBtn(true);
                setErrorMessage("اطلاعات محصول موجود نیست برای دریافت اطلاعات به اینترنت متصل شوید");
                setIsError(true);
            });
            (0,check_items/* getChildrenOffline */.Z$)(loadId).then((resp)=>{
                setIsError(false);
                setMenuItems(resp);
            }).catch((err)=>{
                setShowErrBtn(true);
                setErrorMessage("اطلاعات محصول موجود نیست برای دریافت اطلاعات به اینترنت متصل شوید");
                setIsError(true);
            });
        } else {
            saveImportantData();
            // check if available offline
            // console.log('Checking if items are available offline')
            const offlineItemsCat = localStorage.getItem(`level${0}`);
            if (offlineItemsCat) {
                // console.log('Items are available offline')
                let offlineItemsParsed = JSON.parse(offlineItemsCat);
                if (offlineItemsParsed.length > 0) {
                    (0,check_items/* getChildrenOffline */.Z$)(0).then((items)=>setCatItems(items)).catch(()=>{
                        const clientLastUpdate = localStorage.getItem(`date${0}`);
                        (0,check_items/* GetCurrentPageUpdate */.r0)(0, token).then((serverLastUpdate)=>{
                            if (Number(clientLastUpdate) < Number(serverLastUpdate)) {
                                // we need to update
                                setCatItems([]);
                                generateItemsOnline(0);
                            }
                        });
                    });
                }
            }
            const offlineItems = localStorage.getItem(`level${loadId}`);
            if (offlineItems) {
                // console.log('Items are available offline')
                let offlineItemsParsed1 = JSON.parse(offlineItems);
                if (offlineItemsParsed1.length > 0) {
                    (0,check_items/* getChildrenOffline */.Z$)(loadId).then((items)=>setMenuItems(items)).catch(()=>{
                        const clientLastUpdate = localStorage.getItem(`date${loadId}`);
                        (0,check_items/* GetCurrentPageUpdate */.r0)(loadId, token).then((serverLastUpdate)=>{
                            if (Number(clientLastUpdate) < Number(serverLastUpdate)) {
                                // we need to update
                                setMenuItems([]);
                                generateItemsOnline(loadId);
                            }
                        });
                    });
                }
            } else {
                generateItemsOnline(loadId);
            }
        }
    };
    const getItems = (id)=>{
        (0,check_items/* getChildren */.G)(id, token).then((resp)=>{
            setIsError(false);
            let normalizedItems = resp.items;
            localStorage.setItem(`level${id}`, JSON.stringify(normalizedItems));
            localStorage.setItem(`date${id}`, String(resp.last_update));
            for(let itmN in resp.items){
                if (resp.items[itmN].isCat) {
                    getItems(resp.items[itmN].id);
                }
            }
        //save items offline
        // saveItemsOffline(resp.items, id, resp.last_update)
        //   .then((normalizedItems) => {
        //     localStorage.setItem(`level${id}`, JSON.stringify(normalizedItems));
        //     localStorage.setItem(`date${id}`, String(resp.last_update));
        //     for (let itmN in resp.items) {
        //       if (resp.items[itmN].isCat) {
        //         getItems(resp.items[itmN].id);
        //       }
        //     }
        //   })
        //   .catch((err) => {
        //     setErrorMessage("سرور داخلی در دسترس نیست");
        //     setIsError(true);
        //   });
        }).catch((err)=>{
            console.log(err);
            if (err !== "no data") setIsError(true);
        });
    };
    function generateItemsOnline(loadId) {
        (0,check_items/* getChildren */.G)(0, token).then((resp)=>{
            setIsError(false);
            setCatItems(resp.items);
            for(let catItem in resp.items){
                getItems(resp.items[catItem].id);
            }
        }).catch((err)=>{
            console.log(err);
            if (err !== "no data") setIsError(true);
        });
        (0,check_items/* getChildren */.G)(loadId, token).then((resp)=>{
            setIsError(false);
            setMenuItems(resp.items);
            //save items offline
            (0,check_items/* saveItemsOffline */.X$)(resp.items, loadId, resp.last_update).then((normalizedItems)=>{
                localStorage.setItem(`level${loadId}`, JSON.stringify(normalizedItems));
                localStorage.setItem(`date${loadId}`, String(resp.last_update));
            }).catch((err)=>{
                setErrorMessage("سرور داخلی در دسترس نیست");
                setIsError(true);
            });
        }).catch((err)=>{
            console.log(err);
            if (err !== "no data") setIsError(true);
        });
    }
    (0,external_react_.useEffect)(()=>{
        // cleanup
        setIsError(false);
        setShowErrBtn(false);
        let loadId = 0;
        const parentId = router.query.parentId;
        const id = router.query.id;
        // console.log(parentId)
        if (!parentId) {
            loadId = 0;
        } else {
            loadId = Number(id);
        }
        generateItems(loadId);
    }, [
        router,
        token,
        reloadItems
    ]);
    const onBack = ()=>{
        router.back();
    };
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
            className: "flex flex-col h-screen",
            style: {
                paddingTop: "90px"
            },
            children: [
                isError && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                    className: "mt-12 alert alert-error",
                    children: [
                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex-1 ",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                    xmlns: "http://www.w3.org/2000/svg",
                                    fill: "none",
                                    viewBox: "0 0 24 24",
                                    className: "w-6 h-6 mx-2 stroke-current",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                        strokeLinecap: "round",
                                        strokeLinejoin: "round",
                                        strokeWidth: 2,
                                        d: "M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("label", {
                                    children: errorMessage
                                })
                            ]
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                            className: external_clsx_default()("flex-none", !showErrBtn && "hidden"),
                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                onClick: ()=>{
                                    setReloadItems(!reloadItems);
                                },
                                className: "mr-2 btn btn-sm btn-accent",
                                children: "دریافت"
                            })
                        })
                    ]
                }),
                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("main", {
                    className: "w-full my-8",
                    children: [
                        !isMainPage && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex w-full pr-8 mb-4 text-yellow-700",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                    style: {
                                        fontSize: "0.8rem"
                                    },
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: "/",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: "cursor-pointer",
                                            children: "بازگشت"
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                    style: {
                                        fontSize: "0.8rem"
                                    },
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                        className: "pr-8 cursor-pointer",
                                        onClick: onBack,
                                        children: "صفحه قبل"
                                    })
                                })
                            ]
                        }),
                        router.query.id ? /*#__PURE__*/ jsx_runtime_.jsx(components_TextMenu, {
                            menuItems: catItems,
                            onSelectCategory: onSelectCategory
                        }) : "",
                        /*#__PURE__*/ jsx_runtime_.jsx("br", {}),
                        /*#__PURE__*/ jsx_runtime_.jsx("br", {}),
                        /*#__PURE__*/ jsx_runtime_.jsx(components_TextMenu, {
                            menuItems: menuItems,
                            onSelectCategory: onSelectCategory
                        })
                    ]
                })
            ]
        })
    });
};
/* harmony default export */ const components_Menu = (Menu);


/***/ }),

/***/ 4373:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "O": () => (/* binding */ simpleContext),
/* harmony export */   "f": () => (/* binding */ SimpleStateContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const SimpleStateContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
    listMode: "",
    setListMode: ()=>{}
});
const simpleContext = ()=>(0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(SimpleStateContext);


/***/ })

};
;