"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

function _default() {
  return function ({
    config,
    matchUtilities,
    theme,
    variants
  }) {
    matchUtilities({
      'backdrop-grayscale': value => {
        return {
          '--tw-backdrop-grayscale': `grayscale(${value})`,
          ...(config('mode') === 'jit' ? {
            'backdrop-filter': 'var(--tw-backdrop-filter)'
          } : {})
        };
      }
    }, {
      values: theme('backdropGrayscale'),
      variants: variants('backdropGrayscale'),
      type: 'any'
    });
  };
}