import React from 'react';
import { Theme, TypeOptions } from '../types';
/**
 * Used when providing custom icon
 */
export interface IconProps {
    theme: Theme;
    type: TypeOptions;
}
export declare type BuiltInIconProps = React.SVGProps<SVGSVGElement> & IconProps;
declare function Warning(props: BuiltInIconProps): JSX.Element;
declare function Info(props: BuiltInIconProps): JSX.Element;
declare function Success(props: BuiltInIconProps): JSX.Element;
declare function Error(props: BuiltInIconProps): JSX.Element;
declare function Spinner(): JSX.Element;
export declare const Icons: {
    info: typeof Info;
    warning: typeof Warning;
    success: typeof Success;
    error: typeof Error;
    spinner: typeof Spinner;
};
export {};
