import type { webpack } from 'next/dist/compiled/webpack/webpack';
import type { NextConfigComplete } from '../../../server/config-shared';
export declare type ConfigurationContext = {
    supportedBrowsers: string[] | undefined;
    rootDirectory: string;
    customAppFile: RegExp | undefined;
    isDevelopment: boolean;
    isProduction: boolean;
    isServer: boolean;
    isClient: boolean;
    isEdgeRuntime: boolean;
    targetWeb: boolean;
    assetPrefix: string;
    sassOptions: any;
    productionBrowserSourceMaps: boolean;
    future: NextConfigComplete['future'];
    experimental: NextConfigComplete['experimental'];
};
export declare type ConfigurationFn = (a: webpack.Configuration) => webpack.Configuration;
export declare const pipe: <R>(...fns: ((a: R) => R | Promise<R>)[]) => (param: R) => R | Promise<R>;
