"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_ID_INTERPOLATION_PATTERN = void 0;
var tslib_1 = require("tslib");
var helper_plugin_utils_1 = require("@babel/helper-plugin-utils");
var plugin_syntax_jsx_1 = tslib_1.__importDefault(require("@babel/plugin-syntax-jsx"));
var jsx_opening_element_1 = require("./visitors/jsx-opening-element");
var call_expression_1 = require("./visitors/call-expression");
exports.DEFAULT_ID_INTERPOLATION_PATTERN = '[sha512:contenthash:base64:6]';
// @ts-expect-error PluginPass doesn't allow custom state but it actually does
exports.default = helper_plugin_utils_1.declare(function (api, options) {
    api.assertVersion(7);
    if (!options.idInterpolationPattern) {
        options.idInterpolationPattern = exports.DEFAULT_ID_INTERPOLATION_PATTERN;
    }
    var pragma = options.pragma;
    var componentNames = new Set(options.additionalComponentNames);
    componentNames.add('FormattedMessage');
    var functionNames = new Set(options.additionalFunctionNames);
    functionNames.add('formatMessage');
    // Vue
    functionNames.add('$formatMessage');
    return {
        inherits: plugin_syntax_jsx_1.default,
        pre: function () {
            this.componentNames = Array.from(componentNames);
            this.functionNames = Array.from(functionNames);
        },
        visitor: {
            Program: {
                enter: function (path) {
                    var _this = this;
                    this.messages = [];
                    this.meta = {};
                    if (!pragma) {
                        return;
                    }
                    for (var _i = 0, _a = path.node.body; _i < _a.length; _i++) {
                        var leadingComments = _a[_i].leadingComments;
                        if (!leadingComments) {
                            continue;
                        }
                        var pragmaLineNode = leadingComments.find(function (c) {
                            return c.value.includes(pragma);
                        });
                        if (!pragmaLineNode) {
                            continue;
                        }
                        pragmaLineNode.value
                            .split(pragma)[1]
                            .trim()
                            .split(/\s+/g)
                            .forEach(function (kv) {
                            var _a = kv.split(':'), k = _a[0], v = _a[1];
                            _this.meta[k] = v;
                        });
                    }
                },
                exit: function (_, _a) {
                    var _opts = _a.opts, filename = _a.file.opts.filename;
                    var opts = _opts;
                    if (typeof (opts === null || opts === void 0 ? void 0 : opts.onMetaExtracted) === 'function') {
                        opts.onMetaExtracted(filename || '', this.meta);
                    }
                    if (typeof (opts === null || opts === void 0 ? void 0 : opts.onMsgExtracted) === 'function') {
                        opts.onMsgExtracted(filename || '', this.messages);
                    }
                },
            },
            JSXOpeningElement: jsx_opening_element_1.visitor,
            CallExpression: call_expression_1.visitor,
        },
    };
});
