"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useWatch;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _useLayoutEffect = _interopRequireDefault(require("rc-util/lib/hooks/useLayoutEffect"));
var _util = require("../util");
function useWatch(open, target, popup, onAlign) {
  (0, _useLayoutEffect.default)(function () {
    if (open && target && popup) {
      var targetElement = target;
      var popupElement = popup;
      var targetScrollList = (0, _util.collectScroller)(targetElement);
      var popupScrollList = (0, _util.collectScroller)(popupElement);
      var win = (0, _util.getWin)(popupElement);
      var mergedList = new Set([win].concat((0, _toConsumableArray2.default)(targetScrollList), (0, _toConsumableArray2.default)(popupScrollList)));
      function notifyScroll() {
        onAlign();
      }
      mergedList.forEach(function (scroller) {
        scroller.addEventListener('scroll', notifyScroll, {
          passive: true
        });
      });
      win.addEventListener('resize', notifyScroll, {
        passive: true
      });

      // First time always do align
      onAlign();
      return function () {
        mergedList.forEach(function (scroller) {
          scroller.removeEventListener('scroll', notifyScroll);
          win.removeEventListener('resize', notifyScroll);
        });
      };
    }
  }, [open, target, popup]);
}