"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBuiltinFormatter = void 0;
var tslib_1 = require("tslib");
var defaultFormatter = tslib_1.__importStar(require("./default"));
var transifex = tslib_1.__importStar(require("./transifex"));
var smartling = tslib_1.__importStar(require("./smartling"));
var simple = tslib_1.__importStar(require("./simple"));
var lokalise = tslib_1.__importStar(require("./lokalise"));
var crowdin = tslib_1.__importStar(require("./crowdin"));
var path_1 = require("path");
function resolveBuiltinFormatter(format) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            if (!format) {
                return [2 /*return*/, defaultFormatter];
            }
            if (typeof format !== 'string') {
                return [2 /*return*/, format];
            }
            switch (format) {
                case 'transifex':
                    return [2 /*return*/, transifex];
                case 'smartling':
                    return [2 /*return*/, smartling];
                case 'simple':
                    return [2 /*return*/, simple];
                case 'lokalise':
                    return [2 /*return*/, lokalise];
                case 'crowdin':
                    return [2 /*return*/, crowdin];
            }
            try {
                // eslint-disable-next-line import/dynamic-import-chunkname
                return [2 /*return*/, Promise.resolve().then(function () { return tslib_1.__importStar(require(path_1.resolve(process.cwd(), format))); })];
            }
            catch (e) {
                console.error("Cannot resolve formatter " + format);
                throw e;
            }
            return [2 /*return*/];
        });
    });
}
exports.resolveBuiltinFormatter = resolveBuiltinFormatter;
