"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var compile_1 = require("./compile");
var path_1 = require("path");
var fs_extra_1 = require("fs-extra");
function compileFolder(files, outFolder, opts) {
    if (opts === void 0) { opts = {}; }
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var results, outFiles;
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.all(files.map(function (f) { return compile_1.compile([f], opts); }))];
                case 1:
                    results = _a.sent();
                    outFiles = files.map(function (f) { return path_1.join(outFolder, path_1.basename(f)); });
                    return [2 /*return*/, Promise.all(outFiles.map(function (outFile, i) { return fs_extra_1.outputFile(outFile, results[i]); }))];
            }
        });
    });
}
exports.default = compileFolder;
